/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import kihira.tails.api.IRenderHelper;
import kihira.tails.client.model.ModelPartBase;
import kihira.tails.client.texture.TextureHelper;
import kihira.tails.common.PartInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPart {
    private static final HashMap<Class<? extends EntityLivingBase>, IRenderHelper> renderHelpers = new HashMap();
    protected final String name;
    protected final String[] textureNames;
    protected final int subTypes;
    protected final String[][] authors;
    protected final String modelAuthor;
    public final ModelPartBase modelPart;

    public RenderPart(String name, int subTypes, String modelAuthor, ModelPartBase modelPart, String ... textureNames) {
        this.name = name;
        this.subTypes = subTypes;
        this.modelAuthor = modelAuthor;
        this.modelPart = modelPart;
        this.textureNames = textureNames;
        this.authors = new String[subTypes + 1][textureNames.length];
    }

    public void render(EntityLivingBase entity, PartInfo info, double x, double y, double z, float partialTicks) {
        if (info.needsTextureCompile || info.getTexture() == null) {
            info.setTexture(TextureHelper.generateTexture(info));
            info.needsTextureCompile = false;
        }
        GL11.glPushMatrix();
        IRenderHelper helper = entity instanceof EntityPlayer ? RenderPart.getRenderHelper(EntityPlayer.class) : RenderPart.getRenderHelper(entity.getClass());
        if (helper != null) {
            helper.onPreRenderTail(entity, this, info, x, y, z);
        }
        this.doRender(entity, info, partialTicks);
        GL11.glPopMatrix();
    }

    protected void doRender(EntityLivingBase entity, PartInfo info, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(info.getTexture());
        this.modelPart.render(entity, info.subid, partialTicks);
    }

    public String[] getTextureNames(int subid) {
        return this.textureNames;
    }

    public int getAvailableSubTypes() {
        return this.subTypes;
    }

    public String getUnlocalisedName(int subType) {
        return this.name + "." + subType + ".name";
    }

    public RenderPart setAuthor(String author, int subID, int textureID) {
        this.authors[subID][textureID] = author;
        return this;
    }

    public RenderPart setAuthor(String author, int subID) {
        for (int textureID = 0; textureID < this.getTextureNames(subID).length; ++textureID) {
            this.setAuthor(author, subID, textureID);
        }
        return this;
    }

    public RenderPart setAuthor(String author) {
        for (int subID = 0; subID <= this.subTypes; ++subID) {
            this.setAuthor(author, subID);
        }
        return this;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getAuthor(int subID, int textureID) {
        return this.authors[subID][textureID];
    }

    public boolean hasAuthor(int subID, int textureID) {
        return this.getAuthor(subID, textureID) != null;
    }

    public static void registerRenderHelper(Class<? extends EntityLivingBase> clazz, IRenderHelper helper) {
        if (renderHelpers.containsKey(clazz) || helper == null) {
            throw new IllegalArgumentException("An invalid RenderHelper was registered!");
        }
        renderHelpers.put(clazz, helper);
    }

    public static IRenderHelper getRenderHelper(Class<? extends EntityLivingBase> clazz) {
        if (renderHelpers.containsKey(clazz)) {
            return renderHelpers.get(clazz);
        }
        return null;
    }
}

