/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.gui;

import cofh.api.energy.IEnergyStorage;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import tonius.simplyjetpacks.gui.ContainerPack;
import tonius.simplyjetpacks.gui.element.ElementEnergyStoredAdv;
import tonius.simplyjetpacks.gui.element.ElementFluidTankAdv;
import tonius.simplyjetpacks.network.PacketHandler;
import tonius.simplyjetpacks.network.message.MessageModKey;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.util.SJStringHelper;

public class GuiPack
extends GuiBase {
    private final ContainerPack container;

    public GuiPack(ContainerPack container) {
        super((Container)container, new ResourceLocation("simplyjetpacks:textures/gui/pack.png"));
        this.container = container;
        String unlocalizedTitle = "item.simplyjetpacks." + container.pack.getBaseName(false) + container.packItem.modType.suffix + ".name";
        this.name = SJStringHelper.localize(unlocalizedTitle, false, (Object[])null);
        this.drawInventory = false;
        this.field_146294_l = 176;
        this.field_146295_m = 100;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.container.energyStored != null) {
            this.addElement((ElementBase)new ElementEnergyStoredAdv(this, 12, 28, (IEnergyStorage)this.container.energyStored));
        } else if (this.container.fluidStored != null) {
            this.addElement((ElementBase)new ElementFluidTankAdv(this, 12, 24, (IFluidTank)this.container.fluidStored).setAlwaysShow(true).setGauge(1));
        }
        ModKey[] controls = this.container.pack.getGuiControls();
        int startX = 76 + (4 - controls.length) * 22;
        for (int i = 0; i < controls.length; ++i) {
            ModKey key = controls[i];
            ElementButton button = new ElementButton((GuiBase)this, startX + i * 22, 40, key.name, key.sheetX, key.sheetY, key.hoverX, key.hoverY, key.disabledX, key.disabledY, 20, 20, this.texture.toString());
            button.setToolTip(SJStringHelper.localize(String.format("%s.button.%s", this.container.pack.getGuiTitlePrefix(), key.name), new Object[0])).setToolTipLocalized(true);
            this.addElement((ElementBase)button);
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        GuiBase.playSound((String)"random.click", (float)0.5f, (float)1.0f);
        if (buttonName.equals(ModKey.TOGGLE_PRIMARY.name)) {
            PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModKey.TOGGLE_PRIMARY, true));
            this.container.pack.togglePrimary(this.container.chestplate, (EntityPlayer)this.field_146297_k.field_71439_g, false);
        } else if (buttonName.equals(ModKey.TOGGLE_SECONDARY.name)) {
            PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModKey.TOGGLE_SECONDARY, true));
            this.container.pack.toggleSecondary(this.container.chestplate, (EntityPlayer)this.field_146297_k.field_71439_g, false);
        } else if (buttonName.equals(ModKey.MODE_PRIMARY.name)) {
            PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModKey.MODE_PRIMARY, true));
            this.container.pack.switchModePrimary(this.container.chestplate, (EntityPlayer)this.field_146297_k.field_71439_g, false);
        } else if (buttonName.equals(ModKey.MODE_SECONDARY.name)) {
            PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModKey.MODE_SECONDARY, true));
            this.container.pack.switchModeSecondary(this.container.chestplate, (EntityPlayer)this.field_146297_k.field_71439_g, false);
        }
    }
}

