/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import codechicken.nei.api.IConfigureNEI;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openblocks.OpenBlocks;
import openmods.Log;

public class NEIOpenBlocksConfig
implements IConfigureNEI {
    private static final String API = "codechicken.nei.api.API";
    private static final String HIDE_ITEM = "hideItem";
    private Method hideItem;

    public void loadConfig() {
        if (OpenBlocks.Blocks.canvasGlass != null) {
            this.API$hideItem(new ItemStack((Block)OpenBlocks.Blocks.canvasGlass));
        }
        if (OpenBlocks.Items.heightMap != null) {
            this.API$hideItem(new ItemStack((Item)OpenBlocks.Items.heightMap, 1, Short.MAX_VALUE));
        }
        Log.info((String)"OpenBlocks NEI Integration loaded successfully", (Object[])new Object[0]);
    }

    public String getName() {
        return "OpenBlocks-ItemHider";
    }

    public String getVersion() {
        return "0.0";
    }

    private void API$hideItem(ItemStack stack) {
        try {
            if (this.hideItem == null) {
                this.hideItem = Class.forName(API).getMethod(HIDE_ITEM, ItemStack.class);
            }
            this.hideItem.invoke(null, stack);
        }
        catch (Throwable thr) {
            Throwables.propagate((Throwable)thr);
        }
    }
}

