/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.api.IElevatorBlock;
import openblocks.common.ElevatorBlockRules;
import openblocks.events.ElevatorActionEvent;
import openmods.movement.PlayerMovementEvent;
import openmods.utils.EnchantmentUtils;

public class ElevatorActionHandler {
    private static boolean canTeleportPlayer(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (!Config.irregularBlocksArePassable) {
            return false;
        }
        AxisAlignedBB aabb = block.func_149668_a(world, x, y, z);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private static boolean canTeleportPlayer(EntityPlayer entity, World world, int x, int y, int z) {
        AxisAlignedBB aabb = entity.field_70121_D;
        double height = Math.abs(aabb.field_72337_e - aabb.field_72338_b);
        int blockHeight = Math.max(1, MathHelper.func_76143_f((double)height));
        for (int dy = 0; dy < blockHeight; ++dy) {
            if (ElevatorActionHandler.canTeleportPlayer(world, x, y + dy, z)) continue;
            return false;
        }
        return true;
    }

    private static SearchResult findLevel(EntityPlayer player, World world, int x, int y, int z, ForgeDirection direction) {
        Preconditions.checkArgument((direction == ForgeDirection.UP || direction == ForgeDirection.DOWN ? 1 : 0) != 0, (Object)"Must be either up or down... for now");
        IElevatorBlock thisElevatorBlock = (IElevatorBlock)world.func_147439_a(x, y, z);
        int thisColor = thisElevatorBlock.getColor(world, x, y, z);
        int blocksInTheWay = 0;
        int delta = direction.offsetY;
        block4: for (int i = 0; i < Config.elevatorTravelDistance && world.func_72899_e(x, y += delta, z); ++i) {
            IElevatorBlock otherElevatorBlock;
            int otherColor;
            if (world.func_147437_c(x, y, z)) continue;
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof IElevatorBlock && (otherColor = (otherElevatorBlock = (IElevatorBlock)block).getColor(world, x, y, z)) == thisColor && ElevatorActionHandler.canTeleportPlayer(player, world, x, y + 1, z)) {
                IElevatorBlock.PlayerRotation rotation = otherElevatorBlock.getRotation(world, x, y, z);
                return new SearchResult(y, rotation);
            }
            if (Config.elevatorIgnoreBlocks) continue;
            ElevatorBlockRules.Action action = ElevatorBlockRules.instance.getActionForBlock(block);
            switch (action) {
                case ABORT: {
                    return null;
                }
                case IGNORE: {
                    continue block4;
                }
                default: {
                    if (++blocksInTheWay > Config.elevatorMaxBlockPassCount) break block4;
                }
            }
        }
        return null;
    }

    private static void activate(EntityPlayer player, World world, int x, int y, int z, ForgeDirection dir) {
        boolean doTeleport;
        SearchResult result = ElevatorActionHandler.findLevel(player, world, x, y, z, dir);
        if (result != null && (doTeleport = ElevatorActionHandler.checkXpCost(player, result))) {
            if (result.rotation != IElevatorBlock.PlayerRotation.NONE) {
                player.field_70177_z = ElevatorActionHandler.getYaw(result.rotation);
            }
            if (Config.elevatorCenter) {
                player.func_70634_a((double)x + 0.5, (double)result.level + 1.1, (double)z + 0.5);
            } else {
                player.func_70634_a(player.field_70165_t, (double)result.level + 1.1, player.field_70161_v);
            }
            world.func_72956_a((Entity)player, "openblocks:elevator.activate", 1.0f, 1.0f);
        }
    }

    private static float getYaw(IElevatorBlock.PlayerRotation rotation) {
        switch (rotation) {
            case EAST: {
                return 90.0f;
            }
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    protected static boolean checkXpCost(EntityPlayer player, SearchResult result) {
        int neededXP;
        int distance = (int)Math.abs(player.field_70163_u - (double)result.level);
        if (Config.elevatorXpDrainRatio == 0.0f || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
        if (playerXP >= (neededXP = MathHelper.func_76143_f((double)(Config.elevatorXpDrainRatio * (float)distance)))) {
            EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-neededXP));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onElevatorEvent(ElevatorActionEvent evt) {
        int z;
        int y;
        int x;
        World world = evt.getWorld();
        if (!(world.func_147439_a(x = evt.xCoord, y = evt.yCoord, z = evt.zCoord) instanceof IElevatorBlock)) {
            return;
        }
        if (evt.sender != null) {
            if (evt.sender.field_70154_o != null) {
                return;
            }
            switch (evt.type) {
                case JUMP: {
                    ElevatorActionHandler.activate(evt.sender, world, x, y, z, ForgeDirection.UP);
                    break;
                }
                case SNEAK: {
                    ElevatorActionHandler.activate(evt.sender, world, x, y, z, ForgeDirection.DOWN);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerMovement(PlayerMovementEvent evt) {
        int z;
        int y;
        EntityPlayer player = evt.entityPlayer;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        Block block = world.func_147439_a(x, y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v));
        if (block instanceof IElevatorBlock) {
            new ElevatorActionEvent(world.field_73011_w.field_76574_g, x, y, z, evt.type).sendToServer();
        }
    }

    private static class SearchResult {
        public final int level;
        public final IElevatorBlock.PlayerRotation rotation;

        public SearchResult(int level, IElevatorBlock.PlayerRotation rotation) {
            this.level = level;
            this.rotation = rotation;
        }
    }
}

