/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus;

import com.austinv11.collectiveframework.minecraft.config.ConfigException;
import com.austinv11.collectiveframework.minecraft.config.ConfigRegistry;
import com.austinv11.collectiveframework.minecraft.logging.Logger;
import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import com.austinv11.peripheralsplusplus.client.gui.GuiHandler;
import com.austinv11.peripheralsplusplus.creativetab.CreativeTabPPP;
import com.austinv11.peripheralsplusplus.entities.EntityNanoBotSwarm;
import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftHooks;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftNotFoundException;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.init.ModItems;
import com.austinv11.peripheralsplusplus.init.Recipes;
import com.austinv11.peripheralsplusplus.items.ItemNanoSwarm;
import com.austinv11.peripheralsplusplus.mount.DynamicMount;
import com.austinv11.peripheralsplusplus.network.AudioPacket;
import com.austinv11.peripheralsplusplus.network.AudioResponsePacket;
import com.austinv11.peripheralsplusplus.network.ChatPacket;
import com.austinv11.peripheralsplusplus.network.CommandPacket;
import com.austinv11.peripheralsplusplus.network.GuiPacket;
import com.austinv11.peripheralsplusplus.network.InputEventPacket;
import com.austinv11.peripheralsplusplus.network.ParticlePacket;
import com.austinv11.peripheralsplusplus.network.PermCardChangePacket;
import com.austinv11.peripheralsplusplus.network.RidableTurtlePacket;
import com.austinv11.peripheralsplusplus.network.RobotEventPacket;
import com.austinv11.peripheralsplusplus.network.ScaleRequestPacket;
import com.austinv11.peripheralsplusplus.network.ScaleRequestResponsePacket;
import com.austinv11.peripheralsplusplus.network.SynthPacket;
import com.austinv11.peripheralsplusplus.network.SynthResponsePacket;
import com.austinv11.peripheralsplusplus.network.TextFieldInputEventPacket;
import com.austinv11.peripheralsplusplus.pocket.PocketMotionDetector;
import com.austinv11.peripheralsplusplus.pocket.PocketPeripheralContainer;
import com.austinv11.peripheralsplusplus.proxy.CommonProxy;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.TurtleBarrel;
import com.austinv11.peripheralsplusplus.turtles.TurtleBluePower;
import com.austinv11.peripheralsplusplus.turtles.TurtleChatBox;
import com.austinv11.peripheralsplusplus.turtles.TurtleChunkLoader;
import com.austinv11.peripheralsplusplus.turtles.TurtleCompass;
import com.austinv11.peripheralsplusplus.turtles.TurtleDispenser;
import com.austinv11.peripheralsplusplus.turtles.TurtleDropCollector;
import com.austinv11.peripheralsplusplus.turtles.TurtleEnvironmentScanner;
import com.austinv11.peripheralsplusplus.turtles.TurtleFeeder;
import com.austinv11.peripheralsplusplus.turtles.TurtleGarden;
import com.austinv11.peripheralsplusplus.turtles.TurtleNoteBlock;
import com.austinv11.peripheralsplusplus.turtles.TurtleOreDictionary;
import com.austinv11.peripheralsplusplus.turtles.TurtlePlayerSensor;
import com.austinv11.peripheralsplusplus.turtles.TurtleProjRed;
import com.austinv11.peripheralsplusplus.turtles.TurtleResupply;
import com.austinv11.peripheralsplusplus.turtles.TurtleRidable;
import com.austinv11.peripheralsplusplus.turtles.TurtleShear;
import com.austinv11.peripheralsplusplus.turtles.TurtleSignReader;
import com.austinv11.peripheralsplusplus.turtles.TurtleSpeaker;
import com.austinv11.peripheralsplusplus.turtles.TurtleTank;
import com.austinv11.peripheralsplusplus.turtles.TurtleXP;
import com.austinv11.peripheralsplusplus.turtles.peripherals.PeripheralChunkLoader;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import net.minecraft.block.BlockDispenser;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="PeripheralsPlusPlus", name="Peripherals++", version="1.3.6", dependencies="after:CollectiveFramework")
public class PeripheralsPlusPlus {
    public static int VILLAGER_ID = 1337;
    public static SimpleNetworkWrapper NETWORK;
    @Mod.Instance(value="PeripheralsPlusPlus")
    public static PeripheralsPlusPlus instance;
    @SidedProxy(clientSide="com.austinv11.peripheralsplusplus.proxy.ClientProxy", serverSide="com.austinv11.peripheralsplusplus.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger LOGGER;
    public static String BASE_PPP_DIR;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            ConfigRegistry.registerConfig((Object)new Config());
        }
        catch (ConfigException e) {
            LOGGER.fatal((Object)"Fatal problem with the Peripherals++ config has been caught, if this continues, please delete the config file");
            e.printStackTrace();
        }
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("ppp");
        NETWORK.registerMessage(AudioPacket.AudioPacketHandler.class, AudioPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage(AudioResponsePacket.AudioResponsePacketHandler.class, AudioResponsePacket.class, 1, Side.SERVER);
        NETWORK.registerMessage(ChatPacket.ChatPacketHandler.class, ChatPacket.class, 4, Side.CLIENT);
        NETWORK.registerMessage(ScaleRequestPacket.ScaleRequestPacketHandler.class, ScaleRequestPacket.class, 5, Side.CLIENT);
        NETWORK.registerMessage(ScaleRequestResponsePacket.ScaleRequestResponsePacketHandler.class, ScaleRequestResponsePacket.class, 6, Side.SERVER);
        NETWORK.registerMessage(CommandPacket.CommandPacketHandler.class, CommandPacket.class, 7, Side.CLIENT);
        NETWORK.registerMessage(ParticlePacket.ParticlePacketHandler.class, ParticlePacket.class, 8, Side.CLIENT);
        NETWORK.registerMessage(InputEventPacket.InputEventPacketHandler.class, InputEventPacket.class, 9, Side.SERVER);
        NETWORK.registerMessage(GuiPacket.GuiPacketHandler.class, GuiPacket.class, 10, Side.CLIENT);
        NETWORK.registerMessage(TextFieldInputEventPacket.TextFieldInputEventPacketHandler.class, TextFieldInputEventPacket.class, 11, Side.SERVER);
        NETWORK.registerMessage(RidableTurtlePacket.RidableTurtlePacketHandler.class, RidableTurtlePacket.class, 12, Side.SERVER);
        NETWORK.registerMessage(RobotEventPacket.RobotEventPacketHandler.class, RobotEventPacket.class, 13, Side.CLIENT);
        NETWORK.registerMessage(PermCardChangePacket.PermCardChangePacketHandler.class, PermCardChangePacket.class, 14, Side.SERVER);
        NETWORK.registerMessage(SynthPacket.SynthPacketHandler.class, SynthPacket.class, 15, Side.CLIENT);
        NETWORK.registerMessage(SynthResponsePacket.SynthResponsePacketHandler.class, SynthResponsePacket.class, 16, Side.SERVER);
        proxy.iconManagerInit();
        proxy.prepareGuis();
        proxy.registerEvents();
        ModItems.preInit();
        ModBlocks.init();
        LOGGER.info((Object)"Preparing the mount...");
        DynamicMount.prepareMount();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        LOGGER.info((Object)"Registering peripherals...");
        proxy.registerTileEntities();
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new IPlusPlusPeripheral.Provider());
        LOGGER.info((Object)"Registering turtle upgrades...");
        PeripheralsPlusPlus.registerUpgrade(new TurtleChatBox());
        PeripheralsPlusPlus.registerUpgrade(new TurtlePlayerSensor());
        PeripheralsPlusPlus.registerUpgrade(new TurtleCompass());
        PeripheralsPlusPlus.registerUpgrade(new TurtleXP());
        if (Loader.isModLoaded((String)"factorization") || Loader.isModLoaded((String)"JABBA")) {
            LOGGER.info((Object)"A mod that adds barrels is loaded! Registering the barrel turtle upgrade...");
            PeripheralsPlusPlus.registerUpgrade(new TurtleBarrel());
        } else {
            LOGGER.info((Object)"No barrel-adding mods found, skipping the barrel turtle upgrade");
        }
        PeripheralsPlusPlus.registerUpgrade(new TurtleOreDictionary());
        PeripheralsPlusPlus.registerUpgrade(new TurtleEnvironmentScanner());
        PeripheralsPlusPlus.registerUpgrade(new TurtleFeeder());
        PeripheralsPlusPlus.registerUpgrade(new TurtleShear());
        PeripheralsPlusPlus.registerUpgrade(new TurtleSignReader());
        PeripheralsPlusPlus.registerUpgrade(new TurtleGarden());
        if (Loader.isModLoaded((String)"ProjRed|Exploration") || Loader.isModLoaded((String)"bluepower")) {
            LOGGER.info((Object)"At least one RedPower-like mod is loaded! Registering RedPower-like turtle upgrades...");
            this.registerRedPowerLikeUpgrades();
        } else {
            LOGGER.info((Object)"No RedPower-like mods found, skipping RedPower-like turtle upgrades");
        }
        PeripheralsPlusPlus.registerUpgrade(new TurtleSpeaker());
        PeripheralsPlusPlus.registerUpgrade(new TurtleTank());
        PeripheralsPlusPlus.registerUpgrade(new TurtleNoteBlock());
        PeripheralsPlusPlus.registerUpgrade(new TurtleRidable());
        PeripheralsPlusPlus.registerUpgrade(new TurtleDispenser());
        PeripheralsPlusPlus.registerUpgrade(new TurtleResupply());
        PeripheralsPlusPlus.registerUpgrade(new TurtleChunkLoader());
        LOGGER.info((Object)"Registering pocket computer upgrades...");
        try {
            ComputerCraftRegistry.registerPocketUpgrade(new PocketMotionDetector());
            ComputerCraftRegistry.registerPocketUpgrade(new PocketPeripheralContainer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info((Object)"All peripherals and turtle upgrades registered!");
        proxy.registerRenderers();
        if (Config.enableVillagers) {
            proxy.setupVillagers();
        }
        EntityRegistry.registerModEntity(EntityRidableTurtle.class, (String)"Ridable Turtle", (int)1, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityNanoBotSwarm.class, (String)"NanoBotSwarm", (int)2, (Object)instance, (int)64, (int)20, (boolean)true);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new PeripheralChunkLoader.LoaderHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws ComputerCraftNotFoundException {
        Recipes.init();
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.nanoSwarm, (Object)new ItemNanoSwarm.BehaviorNanoSwarm());
        SimpleRunnable.RESTRICT_THREAD_USAGE = false;
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppedEvent event) {
        ComputerCraftHooks.cachedPeripherals.clear();
        ComputerCraftHooks.cachedExtraPeripherals.clear();
    }

    public static void registerUpgrade(ITurtleUpgrade u) {
        ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)u);
        CreativeTabPPP.upgrades.add(u);
        if (u instanceof TurtleDropCollector) {
            MinecraftForge.EVENT_BUS.register(((TurtleDropCollector)u).newInstanceOfListener());
        }
    }

    private void registerRedPowerLikeUpgrades() {
        int id;
        if (Loader.isModLoaded((String)"ProjRed|Exploration")) {
            int i = 0;
            for (Enum enum_ : new TurtleProjRed.ToolMaterial[]{TurtleProjRed.ToolMaterial.PERIDOT, TurtleProjRed.ToolMaterial.RUBY, TurtleProjRed.ToolMaterial.SAPPHIRE}) {
                for (Enum enum_2 : new TurtleProjRed.ToolType[]{TurtleProjRed.ToolType.AXE, TurtleProjRed.ToolType.HOE, TurtleProjRed.ToolType.PICKAXE, TurtleProjRed.ToolType.SHOVEL, TurtleProjRed.ToolType.SWORD}) {
                    id = i++;
                    PeripheralsPlusPlus.registerUpgrade(new TurtleProjRed((TurtleProjRed.ToolType)enum_2, (TurtleProjRed.ToolMaterial)enum_, id){
                        final /* synthetic */ TurtleProjRed.ToolType val$type;
                        final /* synthetic */ TurtleProjRed.ToolMaterial val$material;
                        final /* synthetic */ int val$id;
                        {
                            this.val$type = toolType;
                            this.val$material = toolMaterial;
                            this.val$id = n;
                        }

                        @Override
                        public TurtleProjRed.ToolType getToolType() {
                            return this.val$type;
                        }

                        @Override
                        public TurtleProjRed.ToolMaterial getToolMaterial() {
                            return this.val$material;
                        }

                        @Override
                        public int getID() {
                            return this.val$id;
                        }
                    });
                }
            }
        }
        if (Loader.isModLoaded((String)"bluepower")) {
            int j = 0;
            for (Enum enum_ : new TurtleBluePower.ToolMaterial[]{TurtleBluePower.ToolMaterial.AMETHYST, TurtleBluePower.ToolMaterial.RUBY, TurtleBluePower.ToolMaterial.SAPPHIRE}) {
                for (Enum enum_3 : new TurtleBluePower.ToolType[]{TurtleBluePower.ToolType.AXE, TurtleBluePower.ToolType.HOE, TurtleBluePower.ToolType.PICKAXE, TurtleBluePower.ToolType.SHOVEL, TurtleBluePower.ToolType.SWORD}) {
                    id = j++;
                    PeripheralsPlusPlus.registerUpgrade(new TurtleBluePower((TurtleBluePower.ToolType)enum_3, (TurtleBluePower.ToolMaterial)enum_, id){
                        final /* synthetic */ TurtleBluePower.ToolType val$type;
                        final /* synthetic */ TurtleBluePower.ToolMaterial val$material;
                        final /* synthetic */ int val$id;
                        {
                            this.val$type = toolType;
                            this.val$material = toolMaterial;
                            this.val$id = n;
                        }

                        @Override
                        public TurtleBluePower.ToolType getToolType() {
                            return this.val$type;
                        }

                        @Override
                        public TurtleBluePower.ToolMaterial getToolMaterial() {
                            return this.val$material;
                        }

                        @Override
                        public int getID() {
                            return this.val$id;
                        }
                    });
                }
            }
        }
    }

    static {
        LOGGER = new Logger("Peripherals++");
        BASE_PPP_DIR = "./mods/PPP/";
    }
}

