/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.entities;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.RidableTurtlePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.TurtleRidable;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class EntityRidableTurtle
extends Entity {
    private ITurtleAccess turtle = null;
    private int queuedActionCode = -1;
    private int tick = 0;
    private boolean canPerformAction = true;
    private int[] turtleLastPos;

    public EntityRidableTurtle(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.turtleLastPos = nbtTagCompound.func_74759_k("turtleLastPos");
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        if (this.turtle != null) {
            nbtTagCompound.func_74783_a("turtleLastPos", new int[]{this.turtle.getPosition().field_71574_a, this.turtle.getPosition().field_71572_b, this.turtle.getPosition().field_71573_c});
        }
    }

    public void func_70056_a(double x, double y, double z, float pitch, float yaw, int par) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(pitch, yaw);
    }

    public boolean func_70067_L() {
        return this.field_70170_p.field_72995_K && (Keyboard.isKeyDown((int)29) || this.playerIsHoldingRideEnablingItem());
    }

    private boolean playerIsHoldingRideEnablingItem() {
        if (!this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack item = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        return item != null && (item.func_77969_a(new ItemStack(Items.field_151146_bM)) || item.func_77969_a(new ItemStack(Items.field_151055_y)));
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (this.field_70153_n != null && this.field_70153_n != player) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return true;
    }

    public void func_70071_h_() {
        this.checkRemove();
        this.checkMovementQueue();
        this.checkPlayerMovementRequest();
        this.checkLocation();
        this.updateTick();
    }

    private void checkRemove() {
        if (this.turtleLastPos != null) {
            try {
                TileEntity turtleTile = this.field_70170_p.func_147438_o(this.turtleLastPos[0], this.turtleLastPos[1], this.turtleLastPos[2]);
                this.turtle = ReflectionHelper.getTurtle(turtleTile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.turtleLastPos = null;
        }
        if (!(this.field_70170_p.field_72995_K || this.turtle != null && this.isTurleInWorld() && this.turtleHasUpgrade())) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    private boolean turtleHasUpgrade() {
        return this.turtle.getUpgrade(TurtleSide.Left) instanceof TurtleRidable || this.turtle.getUpgrade(TurtleSide.Right) instanceof TurtleRidable;
    }

    private boolean isTurleInWorld() {
        TileEntity turtleTile = this.field_70170_p.func_147438_o(this.turtle.getPosition().field_71574_a, this.turtle.getPosition().field_71572_b, this.turtle.getPosition().field_71573_c);
        return turtleTile != null;
    }

    private void updateTick() {
        if (this.canPerformAction) {
            return;
        }
        if (this.tick < 10) {
            ++this.tick;
        } else {
            this.tick = 0;
            this.canPerformAction = true;
        }
    }

    private void checkLocation() {
        if (this.field_70170_p.field_72995_K || this.turtle == null || this.turtle.getPosition().equals((Object)new ChunkCoordinates((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)))) {
            return;
        }
        this.func_70107_b((double)this.turtle.getPosition().field_71574_a + 0.5, this.turtle.getPosition().field_71572_b, (double)this.turtle.getPosition().field_71573_c + 0.5);
    }

    private void checkMovementQueue() {
        if (!this.canPerformAction || this.field_70170_p.field_72995_K || this.queuedActionCode < 0 || this.queuedActionCode > RidableTurtlePacket.MovementCode.values().length - 1 || this.turtle == null) {
            return;
        }
        RidableTurtlePacket.MovementCode which = RidableTurtlePacket.MovementCode.values()[this.queuedActionCode];
        switch (which) {
            case FORWARD: {
                this.moveTurtle(0);
                break;
            }
            case TURN_LEFT: {
                this.turnTurtle("left");
                break;
            }
            case TURN_RIGHT: {
                this.turnTurtle("right");
                break;
            }
            case DESCEND: {
                this.moveTurtle(1);
                break;
            }
            case ASCEND: {
                this.moveTurtle(2);
            }
        }
        this.queuedActionCode = -1;
        this.canPerformAction = false;
    }

    private void turnTurtle(String turnTo) {
        int[] directions = new int[]{2, 5, 3, 4};
        int index = 0;
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != this.turtle.getDirection()) continue;
            index = i;
            break;
        }
        index = turnTo.equalsIgnoreCase("left") ? --index : ++index;
        if (index < 0) {
            index = directions.length - 1;
        }
        if (index >= directions.length) {
            index = 0;
        }
        this.turtle.setDirection(directions[index]);
        if (turnTo.equalsIgnoreCase("left")) {
            this.turtle.playAnimation(TurtleAnimation.TurnLeft);
        } else {
            this.turtle.playAnimation(TurtleAnimation.TurnRight);
        }
    }

    private void moveTurtle(int direction) {
        int x = this.turtle.getPosition().field_71574_a;
        int y = this.turtle.getPosition().field_71572_b;
        int z = this.turtle.getPosition().field_71573_c;
        TurtleAnimation animation = TurtleAnimation.None;
        switch (direction) {
            case 0: {
                switch (this.turtle.getDirection()) {
                    case 2: {
                        --z;
                        break;
                    }
                    case 5: {
                        ++x;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                    case 4: {
                        --x;
                    }
                }
                animation = TurtleAnimation.MoveForward;
                break;
            }
            case 1: {
                --y;
                animation = TurtleAnimation.MoveDown;
                break;
            }
            case 2: {
                ++y;
                animation = TurtleAnimation.MoveUp;
            }
        }
        if (this.field_70170_p.func_147437_c(x, y, z) && (this.turtle.getFuelLevel() >= Config.fuelPerTurtleMovement || !this.turtle.isFuelNeeded())) {
            this.turtle.playAnimation(animation);
            this.turtle.teleportTo(this.turtle.getWorld(), x, y, z);
            this.turtle.consumeFuel(Config.fuelPerTurtleMovement);
        }
    }

    private void checkPlayerMovementRequest() {
        if (this.field_70170_p.field_72995_K && this.field_70153_n != null && this.field_70153_n == Minecraft.func_71410_x().field_71439_g) {
            if (Keyboard.isKeyDown((int)17)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.func_145782_y(), RidableTurtlePacket.MovementCode.FORWARD.code, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)32)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.func_145782_y(), RidableTurtlePacket.MovementCode.TURN_RIGHT.code, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)30)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.func_145782_y(), RidableTurtlePacket.MovementCode.TURN_LEFT.code, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)31)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.func_145782_y(), RidableTurtlePacket.MovementCode.DESCEND.code, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)45)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.func_145782_y(), RidableTurtlePacket.MovementCode.ASCEND.code, this.field_71093_bK));
            }
        }
    }

    public void setTurtle(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public void queueAction(int movementCode) {
        if (this.canPerformAction) {
            this.queuedActionCode = movementCode;
        }
    }

    public boolean canMoveUp() {
        return this.field_70170_p.func_147437_c(this.turtle.getPosition().field_71574_a, this.turtle.getPosition().field_71572_b + 1, this.turtle.getPosition().field_71573_c) && (this.turtle.getFuelLevel() >= Config.fuelPerTurtleMovement || !this.turtle.isFuelNeeded());
    }
}

