/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.lua;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityPlayerInterface;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class LuaObjectPlayerInv
implements ILuaObject {
    private InventoryPlayer inv;
    private TileEntityPlayerInterface playerInterface;
    private ItemStack permCard;

    public LuaObjectPlayerInv(EntityPlayer player, TileEntityPlayerInterface playerInterface, ItemStack permCard) {
        this.inv = player.field_71071_by;
        this.playerInterface = playerInterface;
        this.permCard = permCard;
    }

    public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                if (arguments.length != 1) {
                    throw new LuaException("Wrong number of arguments. 1 expected.");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!this.hasGetStacksPermission()) break;
                return new Object[]{this.getObjectFromStack(this.inv.func_70301_a(((Double)arguments[0]).intValue()))};
            }
            case 1: {
                if (arguments.length != 2) {
                    throw new LuaException("Wrong number of arguments. 2 expected.");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (this.getOutputInventory() == null) {
                    throw new LuaException("No output side set.");
                }
                if (!this.hasWithdrawPermission()) break;
                ItemStack origStack = this.inv.func_70301_a(((Double)arguments[0]).intValue());
                if (origStack == null) {
                    return new Object[0];
                }
                ItemStack newStack = this.inv.func_70298_a(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue());
                if (!this.addStackToInv(this.getOutputInventory(), newStack, -1)) {
                    this.inv.func_70441_a(newStack);
                    return new Object[]{false};
                }
                return new Object[]{true};
            }
            case 2: {
                if (arguments.length != 3) {
                    throw new LuaException("Wrong number of arguments. 3 expected.");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!this.hasDepositPermission()) break;
                ItemStack origStack = this.getInputInventory().func_70301_a(((Double)arguments[1]).intValue());
                ItemStack newStack = this.getInputInventory().func_70298_a(((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue());
                if (newStack == null) {
                    return new Object[0];
                }
                if (this.addStackToInv((IInventory)this.inv, newStack, 0)) {
                    return new Object[]{true};
                }
                this.getInputInventory().func_70299_a(((Double)arguments[1]).intValue(), origStack);
                return new Object[]{false};
            }
            case 3: {
                if (arguments.length != 2) {
                    throw new LuaException("Wrong number of arguments. 2 expected.");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!this.hasDepositPermission()) break;
                ItemStack origStack = this.getInputInventory().func_70301_a(((Double)arguments[0]).intValue());
                ItemStack newStack = this.getInputInventory().func_70298_a(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue());
                if (newStack == null) {
                    return new Object[0];
                }
                if (this.addStackToInv((IInventory)this.inv, newStack, -1)) {
                    return new Object[]{true};
                }
                this.getInputInventory().func_70299_a(((Double)arguments[0]).intValue(), origStack);
                return new Object[]{false};
            }
            case 4: {
                if (!this.hasGetStacksPermission()) break;
                return new Object[]{this.inv.func_70302_i_()};
            }
        }
        this.inv.func_70296_d();
        return new Object[0];
    }

    public String[] getMethodNames() {
        return new String[]{"getStackInSlot", "retrieveFromSlot", "pushToSlot", "push", "getSize"};
    }

    private Object getObjectFromStack(ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (stack == null) {
            return null;
        }
        String itemName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        int meta = stack.func_77960_j();
        long amount = stack.field_77994_a;
        String displayName = stack.func_82833_r();
        map.put("name", itemName);
        map.put("meta", meta);
        map.put("amount", amount);
        map.put("displayName", displayName);
        return map;
    }

    private IInventory getOutputInventory() throws LuaException {
        ForgeDirection outDir = this.playerInterface.outputSide;
        if (outDir == null) {
            throw new LuaException("Output Side has not yet been set.");
        }
        Location blockLoc = new Location((double)(this.playerInterface.field_145851_c + outDir.offsetX), (double)(this.playerInterface.field_145848_d + outDir.offsetY), (double)(this.playerInterface.field_145849_e + outDir.offsetZ), this.playerInterface.func_145831_w());
        Block block = this.playerInterface.func_145831_w().func_147439_a(blockLoc.getRoundedX(), blockLoc.getRoundedY(), blockLoc.getRoundedZ());
        if (block instanceof BlockContainer) {
            return (IInventory)this.playerInterface.func_145831_w().func_147438_o(blockLoc.getRoundedX(), blockLoc.getRoundedY(), blockLoc.getRoundedZ());
        }
        throw new LuaException("Invalid Output Inventory.");
    }

    private IInventory getInputInventory() throws LuaException {
        ForgeDirection inDir = this.playerInterface.inputSide;
        if (inDir == null) {
            throw new LuaException("Input Side has not yet been set.");
        }
        Location blockLoc = new Location((double)(this.playerInterface.field_145851_c + inDir.offsetX), (double)(this.playerInterface.field_145848_d + inDir.offsetY), (double)(this.playerInterface.field_145849_e + inDir.offsetZ), this.playerInterface.func_145831_w());
        Block block = this.playerInterface.func_145831_w().func_147439_a(blockLoc.getRoundedX(), blockLoc.getRoundedY(), blockLoc.getRoundedZ());
        if (block instanceof BlockContainer) {
            return (IInventory)this.playerInterface.func_145831_w().func_147438_o(blockLoc.getRoundedX(), blockLoc.getRoundedY(), blockLoc.getRoundedZ());
        }
        throw new LuaException("Invalid Input Inventory.");
    }

    private boolean addStackToInv(IInventory inv, ItemStack addStack, int slot) {
        for (Integer slotNum : this.getValidSlotsForStack(inv, addStack, slot)) {
            ItemStack currentStack = inv.func_70301_a(slotNum.intValue());
            if (inv.func_70301_a(slotNum.intValue()) == null) {
                inv.func_70299_a(slotNum.intValue(), addStack);
                return true;
            }
            int add = currentStack.func_77976_d() - currentStack.field_77994_a;
            if (addStack.field_77994_a <= add) {
                currentStack.field_77994_a += addStack.field_77994_a;
                return true;
            }
            currentStack.field_77994_a += add;
            addStack.field_77994_a -= add;
            if (slot != -1) {
                return false;
            }
            if (addStack.field_77994_a != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Integer> getValidSlotsForStack(IInventory inv, ItemStack stack, int slot) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (slot != -1) {
            slots.add(slot);
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null && (!inv.func_70301_a(i).func_77973_b().equals(stack.func_77973_b()) || inv.func_70301_a((int)i).field_77994_a == inv.func_70301_a(i).func_77976_d()) || i == slot) continue;
            slots.add(i);
        }
        return slots;
    }

    private boolean hasDepositPermission() {
        return !Config.enableInterfacePermissions || this.permCard.func_77978_p().func_74767_n("deposit");
    }

    private boolean hasWithdrawPermission() {
        return !Config.enableInterfacePermissions || this.permCard.func_77978_p().func_74767_n("withdraw");
    }

    private boolean hasGetStacksPermission() {
        return !Config.enableInterfacePermissions || this.permCard.func_77978_p().func_74767_n("getStacks");
    }
}

