/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftNotFoundException;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class TurtleRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation TWO_INGREDIENTS = new ResourceLocation("PeripheralsPlusPlus".toLowerCase() + ":textures/gui/turtleNEI.png");
    private static final ResourceLocation THREE_INGREDIENTS = new ResourceLocation("PeripheralsPlusPlus".toLowerCase() + ":textures/gui/turtleNEI2.png");

    public String getGuiTexture() {
        return "null";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"peripheralsplusplus.nei.turtleRecipeHandler.name");
    }

    public String getOverlayIdentifier() {
        return "turtle";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)(((CachedTurtleRecipe)((Object)this.arecipes.get((int)recipe))).hasThreeIngredients ? THREE_INGREDIENTS : TWO_INGREDIENTS));
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (this.isItemStackTurtle(result) && (NBTHelper.hasTag((ItemStack)result, (String)"leftUpgrade") || NBTHelper.hasTag((ItemStack)result, (String)"rightUpgrade"))) {
            Map<Object, Object> upgrades = new HashMap();
            try {
                upgrades = ComputerCraftRegistry.getTurtleUpgrades();
            }
            catch (ComputerCraftNotFoundException e) {
                e.printStackTrace();
            }
            if (NBTHelper.hasTag((ItemStack)result, (String)"leftUpgrade") && NBTHelper.hasTag((ItemStack)result, (String)"rightUpgrade")) {
                ITurtleUpgrade upgrade1 = (ITurtleUpgrade)upgrades.get(NBTHelper.getShort((ItemStack)result, (String)"leftUpgrade"));
                ITurtleUpgrade upgrade2 = (ITurtleUpgrade)upgrades.get(NBTHelper.getShort((ItemStack)result, (String)"rightUpgrade"));
                if (upgrade1 != null && upgrade2 != null && upgrade1.getCraftingItem() != null && upgrade2.getCraftingItem() != null) {
                    this.arecipes.add(new CachedTurtleRecipe(upgrade1, upgrade2, this.isAdvanced(result)));
                }
            } else {
                boolean isLeft = NBTHelper.hasTag((ItemStack)result, (String)"leftUpgrade");
                ITurtleUpgrade upgrade = (ITurtleUpgrade)upgrades.get(NBTHelper.getShort((ItemStack)result, (String)(isLeft ? "leftUpgrade" : "rightUpgrade")));
                if (upgrade != null && upgrade.getCraftingItem() != null) {
                    this.arecipes.add(new CachedTurtleRecipe(upgrade, this.isAdvanced(result), isLeft));
                }
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (this.isItemStackTurtle(ingredient)) {
            try {
                for (ITurtleUpgrade upgrade : ComputerCraftRegistry.getTurtleUpgrades().values()) {
                    if (upgrade == null || upgrade.getCraftingItem() == null) continue;
                    this.arecipes.add(new CachedTurtleRecipe(upgrade, this.isAdvanced(ingredient), true));
                }
            }
            catch (ComputerCraftNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            ITurtleUpgrade upgrade = null;
            try {
                upgrade = this.getUpgradeForIngredient(ingredient);
            }
            catch (ComputerCraftNotFoundException e) {
                e.printStackTrace();
            }
            if (upgrade != null && upgrade.getCraftingItem() != null) {
                this.arecipes.add(new CachedTurtleRecipe(upgrade, true));
            }
        }
    }

    private ITurtleUpgrade getUpgradeForIngredient(ItemStack ingredient) throws ComputerCraftNotFoundException {
        Map<Integer, ITurtleUpgrade> upgrades = ComputerCraftRegistry.getTurtleUpgrades();
        for (ITurtleUpgrade upgrade : upgrades.values()) {
            if (upgrade.getCraftingItem() == null || !upgrade.getCraftingItem().func_77969_a(ingredient)) continue;
            return upgrade;
        }
        return null;
    }

    private boolean isItemStackTurtle(ItemStack stack) {
        return TurtleUtil.getTurtle(true).func_77969_a(stack) || TurtleUtil.getTurtle(false).func_77969_a(stack) || new ItemStack(GameRegistry.findBlock((String)"ComputerCraft", (String)"CC-TurtleExpanded")).func_77969_a(stack);
    }

    private boolean isAdvanced(ItemStack stack) {
        return stack.func_77969_a(TurtleUtil.getTurtle(true));
    }

    public class CachedTurtleRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public boolean hasThreeIngredients;
        private boolean genPerm;
        private List<PositionedStack> inputs;
        private PositionedStack result;
        private final int[] slot_0;
        private final int[] slot_1;
        private final int[] slot_2;
        private final int[] slot2_0;
        private final int[] slot2_1;
        private final int[] slot2_2;
        private final int[] slot2_3;

        public CachedTurtleRecipe(ITurtleUpgrade upgrade, boolean isLeft) {
            super((TemplateRecipeHandler)TurtleRecipeHandler.this);
            this.hasThreeIngredients = false;
            this.genPerm = false;
            this.inputs = new ArrayList<PositionedStack>();
            this.slot_0 = new int[]{19, 12};
            this.slot_1 = new int[]{68, 12};
            this.slot_2 = new int[]{126, 12};
            this.slot2_0 = new int[]{8, 12};
            this.slot2_1 = new int[]{47, 12};
            this.slot2_2 = new int[]{86, 12};
            this.slot2_3 = new int[]{134, 12};
            this.genPerm = true;
            if (!isLeft) {
                this.inputs.add(new PositionedStack((Object)upgrade.getCraftingItem(), this.slot_0[0], this.slot_0[1]));
                this.inputs.add(new PositionedStack((Object)new ItemStack[]{TurtleUtil.getTurtle(true), TurtleUtil.getTurtle(false)}, this.slot_1[0], this.slot_1[1]));
                this.result = new PositionedStack((Object)new ItemStack[]{TurtleUtil.getTurtle(true, null, upgrade), TurtleUtil.getTurtle(false, null, upgrade)}, this.slot_2[0], this.slot_2[1]);
            } else {
                this.inputs.add(new PositionedStack((Object)upgrade.getCraftingItem(), this.slot_1[0], this.slot_1[1]));
                this.inputs.add(new PositionedStack((Object)new ItemStack[]{TurtleUtil.getTurtle(true), TurtleUtil.getTurtle(false)}, this.slot_0[0], this.slot_0[1]));
                this.result = new PositionedStack((Object)new ItemStack[]{TurtleUtil.getTurtle(true, upgrade), TurtleUtil.getTurtle(false, upgrade)}, this.slot_2[0], this.slot_2[1]);
            }
        }

        public CachedTurtleRecipe(ITurtleUpgrade upgrade, boolean isAdvanced, boolean isLeft) {
            super((TemplateRecipeHandler)TurtleRecipeHandler.this);
            this.hasThreeIngredients = false;
            this.genPerm = false;
            this.inputs = new ArrayList<PositionedStack>();
            this.slot_0 = new int[]{19, 12};
            this.slot_1 = new int[]{68, 12};
            this.slot_2 = new int[]{126, 12};
            this.slot2_0 = new int[]{8, 12};
            this.slot2_1 = new int[]{47, 12};
            this.slot2_2 = new int[]{86, 12};
            this.slot2_3 = new int[]{134, 12};
            if (!isLeft) {
                this.inputs.add(new PositionedStack((Object)upgrade.getCraftingItem(), this.slot_0[0], this.slot_0[1]));
                this.inputs.add(new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced), this.slot_1[0], this.slot_1[1]));
                this.result = new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced, null, upgrade), this.slot_2[0], this.slot_2[1]);
            } else {
                this.inputs.add(new PositionedStack((Object)upgrade.getCraftingItem(), this.slot_1[0], this.slot_1[1]));
                this.inputs.add(new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced), this.slot_0[0], this.slot_0[1]));
                this.result = new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced, upgrade), this.slot_2[0], this.slot_2[1]);
            }
        }

        public CachedTurtleRecipe(ITurtleUpgrade upgrade1, ITurtleUpgrade upgrade2, boolean isAdvanced) {
            super((TemplateRecipeHandler)TurtleRecipeHandler.this);
            this.hasThreeIngredients = false;
            this.genPerm = false;
            this.inputs = new ArrayList<PositionedStack>();
            this.slot_0 = new int[]{19, 12};
            this.slot_1 = new int[]{68, 12};
            this.slot_2 = new int[]{126, 12};
            this.slot2_0 = new int[]{8, 12};
            this.slot2_1 = new int[]{47, 12};
            this.slot2_2 = new int[]{86, 12};
            this.slot2_3 = new int[]{134, 12};
            this.hasThreeIngredients = true;
            this.inputs.add(new PositionedStack((Object)upgrade2.getCraftingItem(), this.slot2_0[0], this.slot2_0[1]));
            this.inputs.add(new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced), this.slot2_1[0], this.slot2_1[1]));
            this.inputs.add(new PositionedStack((Object)upgrade1.getCraftingItem(), this.slot2_2[0], this.slot2_2[1]));
            this.result = new PositionedStack((Object)TurtleUtil.getTurtle(isAdvanced, upgrade1, upgrade2), this.slot2_3[0], this.slot2_3[1]);
        }

        public PositionedStack getResult() {
            if (this.genPerm) {
                this.result.generatePermutations();
            }
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            if (this.genPerm) {
                for (PositionedStack stack : this.inputs) {
                    stack.generatePermutations();
                }
            }
            return this.inputs;
        }
    }
}

