/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.collectiveframework.minecraft.utils.WorldUtils;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntityInventory;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityInteractiveSorter
extends MountedTileEntityInventory {
    public static String publicName = "interactiveSorter";
    private String name = "tileEntityInteractiveSorter";
    private List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public int getSize() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"analyze", "push", "pull", "isInventoryPresent"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableInteractiveSorter) {
            throw new LuaException("Interactive Sorters have been disabled");
        }
        if (method == 0) {
            return new Object[]{this.getItemInfo(this.func_70301_a(0))};
        }
        if (method == 1) {
            int amount;
            if (this.func_70301_a(0) == null) {
                return new Object[]{false};
            }
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                throw new LuaException("Bad argument #1 (expected string or number)");
            }
            if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected number)");
            }
            ForgeDirection dir = arguments[0] instanceof String ? ForgeDirection.valueOf((String)((String)arguments[0]).toUpperCase()) : ForgeDirection.getOrientation((int)((int)((Double)arguments[0]).doubleValue()));
            int n = amount = arguments.length > 1 ? MathHelper.func_76125_a((int)((int)((Double)arguments[1]).doubleValue()), (int)0, (int)this.func_70301_a((int)0).field_77994_a) : this.func_70301_a((int)0).field_77994_a;
            if (!this.isInventoryOnSide(dir)) {
                WorldUtils.spawnItemInWorld((Location)new Location((double)(this.field_145851_c + dir.offsetX), (double)(this.field_145848_d + dir.offsetY), (double)(this.field_145849_e + dir.offsetZ), this.field_145850_b), (ItemStack)this.func_70301_a(0).func_77979_a(amount));
                this.func_70296_d();
                return new Object[]{true};
            }
            IInventory inventory = this.getInventoryForSide(dir);
            int oldSize = this.func_70301_a((int)0).field_77994_a;
            int[] slots = inventory instanceof ISidedInventory ? ((ISidedInventory)inventory).func_94128_d(dir.getOpposite().flag) : this.getDefaultSlots(inventory);
            int currentSlot = 0;
            while (this.func_70301_a(0) != null && this.func_70301_a((int)0).field_77994_a > oldSize - amount && currentSlot < slots.length) {
                if (inventory.func_70301_a(slots[currentSlot]) == null) {
                    inventory.func_70299_a(slots[currentSlot], this.func_70301_a(0));
                    this.func_70299_a(0, null);
                } else {
                    if (!inventory.func_70301_a(slots[currentSlot]).func_77969_a(this.func_70301_a(0))) {
                        ++currentSlot;
                        continue;
                    }
                    int transferred = MathHelper.func_76125_a((int)(inventory.func_70301_a((int)slots[currentSlot]).field_77994_a + amount), (int)this.func_70301_a((int)0).field_77994_a, (int)this.func_70301_a(0).func_77976_d());
                    this.func_70301_a((int)0).field_77994_a -= transferred;
                    inventory.func_70301_a((int)0).field_77994_a += transferred;
                }
                inventory.func_70296_d();
                this.func_70296_d();
                ++currentSlot;
            }
            return new Object[]{this.func_70301_a(0) == null || this.func_70301_a((int)0).field_77994_a != oldSize};
        }
        if (method == 2) {
            int transferred;
            int amount;
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                throw new LuaException("Bad argument #1 (expected string or number)");
            }
            if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected number)");
            }
            if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                throw new LuaException("Bad argument #3 (expected number)");
            }
            ForgeDirection dir = arguments[0] instanceof String ? ForgeDirection.valueOf((String)((String)arguments[0]).toUpperCase()) : ForgeDirection.getOrientation((int)((int)((Double)arguments[0]).doubleValue()));
            if (!this.isInventoryOnSide(dir)) {
                throw new LuaException("Block is not a valid inventory");
            }
            IInventory inventory = this.getInventoryForSide(dir);
            int[] slots = inventory instanceof ISidedInventory ? ((ISidedInventory)inventory).func_94128_d(dir.getOpposite().flag) : this.getDefaultSlots(inventory);
            int slot = -1;
            if (arguments.length > 2) {
                slot = this.getNearestSlot((int)((Double)arguments[2]).doubleValue(), slots);
                if (inventory.func_70301_a(slot) == null) {
                    return new Object[]{false};
                }
            } else {
                for (int slot1 : slots) {
                    if (this.func_70301_a(0) == null) {
                        if (inventory.func_70301_a(slot1) == null) continue;
                        slot = slot1;
                        break;
                    }
                    if (inventory.func_70301_a(slot1) == null || !inventory.func_70301_a(slot1).func_77969_a(this.func_70301_a(0))) continue;
                    slot = slot1;
                    break;
                }
            }
            if (slot == -1) {
                return new Object[]{false};
            }
            int n = amount = arguments.length > 1 ? MathHelper.func_76125_a((int)((int)((Double)arguments[1]).doubleValue()), (int)0, (int)inventory.func_70301_a((int)slot).field_77994_a) : inventory.func_70301_a((int)slot).field_77994_a;
            if (this.func_70301_a(0) != null) {
                transferred = MathHelper.func_76125_a((int)(this.func_70301_a((int)0).field_77994_a + amount), (int)this.func_70301_a((int)0).field_77994_a, (int)this.func_70301_a(0).func_77976_d());
                this.func_70301_a((int)0).field_77994_a += transferred;
                inventory.func_70301_a((int)slot).field_77994_a -= transferred;
            } else {
                transferred = amount;
                this.func_70299_a(0, inventory.func_70301_a(slot).func_77979_a(transferred));
            }
            if (inventory.func_70301_a(slot) != null && inventory.func_70301_a((int)slot).field_77994_a < 1) {
                inventory.func_70299_a(slot, null);
            }
            inventory.func_70296_d();
            this.func_70296_d();
            return new Object[]{true};
        }
        if (method == 3) {
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                throw new LuaException("Bad argument #1 (expected string or number)");
            }
            ForgeDirection dir = arguments[0] instanceof String ? ForgeDirection.valueOf((String)((String)arguments[0]).toUpperCase()) : ForgeDirection.getOrientation((int)((int)((Double)arguments[0]).doubleValue()));
            return new Object[]{this.isInventoryOnSide(dir)};
        }
        return new Object[0];
    }

    private int getNearestSlot(int requested, int[] slots) {
        int difference = Integer.MAX_VALUE;
        int currentSlot = slots[0];
        for (int slot : slots) {
            if (slot == requested) {
                return slot;
            }
            if (Math.abs(requested - slot) >= difference) continue;
            difference = Math.abs(requested - slot);
            currentSlot = slot;
        }
        return currentSlot;
    }

    private int[] getDefaultSlots(IInventory inventory) {
        int[] array = new int[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            array[i] = i;
        }
        return array;
    }

    private boolean isInventoryOnSide(ForgeDirection dir) {
        if (!this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (block instanceof BlockContainer || block instanceof IInventory) {
                return true;
            }
            if (block.hasTileEntity(this.field_145850_b.func_72805_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ))) {
                return this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof IInventory;
            }
        }
        return false;
    }

    private IInventory getInventoryForSide(ForgeDirection dir) {
        if (!this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (block instanceof IInventory) {
                return (IInventory)block;
            }
            if (block instanceof BlockContainer && block.hasTileEntity(this.field_145850_b.func_72805_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ))) {
                return (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            }
        }
        return null;
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Override
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        this.computers.add(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        super.detach(computer);
        this.computers.remove(computer);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (stack != null && stack.field_77994_a > 0 && slot == 0) {
            for (IComputerAccess computer : this.computers) {
                computer.queueEvent("itemReady", null);
            }
        }
    }

    private HashMap<String, Object> getItemInfo(ItemStack stack) {
        int numId;
        String id;
        if (stack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", stack.field_77994_a);
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            id = Block.field_149771_c.func_148750_c((Object)block);
            numId = Block.field_149771_c.func_148757_b((Object)block);
        } else {
            id = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
            numId = Item.field_150901_e.func_148757_b((Object)stack.func_77973_b());
        }
        map.put("stringId", id);
        map.put("numericalId", numId);
        map.put("oreDictionaryEntries", Util.getEntries(stack));
        map.put("meta", stack.func_77960_j());
        map.put("name", stack.func_82833_r());
        if (stack.func_77942_o()) {
            map.put("nbt", this.convertNBTToMap(stack.func_77978_p()));
        }
        return map;
    }

    private HashMap<String, Object> convertNBTToMap(NBTTagCompound tag) {
        HashMap<String, Object> nbtMap = new HashMap<String, Object>();
        for (String key : tag.func_150296_c()) {
            NBTBase nbtBase = tag.func_74781_a(key);
            nbtMap.put(key, this.getObjectForNBT(nbtBase.func_74737_b()));
        }
        return nbtMap;
    }

    private Object getObjectForNBT(NBTBase nbtBase) {
        if (nbtBase == null) {
            return null;
        }
        switch (nbtBase.func_74732_a()) {
            case 0: {
                return null;
            }
            case 1: {
                NBTTagByte tagByte = (NBTTagByte)nbtBase;
                return tagByte.func_150290_f();
            }
            case 2: {
                NBTTagShort tagShort = (NBTTagShort)nbtBase;
                return tagShort.func_150289_e();
            }
            case 3: {
                NBTTagInt tagInt = (NBTTagInt)nbtBase;
                return tagInt.func_150287_d();
            }
            case 4: {
                NBTTagLong tagLong = (NBTTagLong)nbtBase;
                return tagLong.func_150291_c();
            }
            case 5: {
                NBTTagFloat tagFloat = (NBTTagFloat)nbtBase;
                return Float.valueOf(tagFloat.func_150288_h());
            }
            case 6: {
                NBTTagDouble tagDouble = (NBTTagDouble)nbtBase;
                return tagDouble.func_150286_g();
            }
            case 7: {
                NBTTagByteArray tagByteArray = (NBTTagByteArray)nbtBase;
                return Util.arrayToMap(tagByteArray.func_150292_c());
            }
            case 8: {
                NBTTagString tagString = (NBTTagString)nbtBase;
                return tagString.func_150285_a_();
            }
            case 9: {
                NBTTagList tagList = (NBTTagList)nbtBase;
                Object[] tags = new Object[tagList.func_74745_c()];
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    tags[i] = this.getObjectForNBT(tagList.func_74744_a(i));
                }
                return Util.arrayToMap(tags);
            }
            case 10: {
                NBTTagCompound tagCompound = (NBTTagCompound)nbtBase;
                return this.convertNBTToMap(tagCompound);
            }
            case 11: {
                NBTTagIntArray tagIntArray = (NBTTagIntArray)nbtBase;
                return Util.arrayToMap(tagIntArray.func_150302_c());
            }
        }
        return null;
    }
}

