/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.TurtleDropCollector;
import com.austinv11.peripheralsplusplus.utils.FakeTurtlePlayer;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import com.austinv11.peripheralsplusplus.utils.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;

public abstract class TurtleProjRed
extends TurtleDropCollector
implements ITurtleUpgrade {
    public abstract int getID();

    public abstract ToolType getToolType();

    public abstract ToolMaterial getToolMaterial();

    public ItemStack getItem() {
        return TurtleProjRed.getProjRedTool(this.getToolType(), this.getToolMaterial());
    }

    public static ItemStack getProjRedTool(ToolType toolType, ToolMaterial toolMaterial) {
        String name = "projectred.exploration." + toolType.getName() + toolMaterial.getName();
        return new ItemStack(GameRegistry.findItem((String)"ProjRed|Exploration", (String)name));
    }

    public int getUpgradeID() {
        return 110 + this.getID();
    }

    public String getUnlocalisedAdjective() {
        return this.getToolType().getAdj();
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableRedPowerLikeTurtles) {
            return this.getItem();
        }
        return null;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        if (!Config.enableRedPowerLikeTurtles) {
            return TurtleCommandResult.failure((String)"RedPower-like turtles have been disabled");
        }
        FakeTurtlePlayer player = new FakeTurtlePlayer(turtle);
        switch (verb) {
            case Attack: {
                List<Entity> entities = TurtleUtil.getEntitiesNearTurtle(turtle, player, direction);
                Entity ent = TurtleUtil.getClosestEntity(entities, (Entity)player);
                if (ent != null && ent.func_70075_an() && !ent.func_85031_j((Entity)player)) {
                    this.addEntity(turtle, ent);
                    double damage = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    if (damage > 0.0 && ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)(damage *= Util.getDamageAttribute(this.getItem())))) {
                        return TurtleCommandResult.success();
                    }
                }
                return TurtleCommandResult.failure();
            }
            case Dig: {
                if (this.getToolType() == ToolType.HOE) {
                    int x = turtle.getPosition().field_71574_a + Facing.field_71586_b[direction];
                    int y = turtle.getPosition().field_71572_b + Facing.field_71587_c[direction];
                    int z = turtle.getPosition().field_71573_c + Facing.field_71585_d[direction];
                    float hitX = 0.5f + (float)Facing.field_71586_b[direction] * 0.5f;
                    float hitY = 0.5f + (float)Facing.field_71587_c[direction] * 0.5f;
                    float hitZ = 0.5f + (float)Facing.field_71585_d[direction] * 0.5f;
                    if (Math.abs(hitY - 0.5f) < 0.01f) {
                        hitY = 0.45f;
                    }
                    if (this.getItem().func_77973_b().func_77648_a(this.getItem(), (EntityPlayer)player, turtle.getWorld(), x, y, z, Facing.field_71588_a[direction], hitX, hitY, hitZ)) {
                        return TurtleCommandResult.success();
                    }
                } else {
                    List<ItemStack> items = TurtleUtil.harvestBlock(turtle, player, direction, this.getItem());
                    if (items != null) {
                        TurtleUtil.addItemListToInv(items, turtle);
                        return TurtleCommandResult.success();
                    }
                }
                return TurtleCommandResult.failure();
            }
        }
        return TurtleCommandResult.failure((String)"An unknown error has occurred, please tell the mod author");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.getItem().func_77973_b().func_77650_f(this.getItem());
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public static enum ToolMaterial {
        PERIDOT("peridot"),
        RUBY("ruby"),
        SAPPHIRE("sapphire"),
        UNKNOWN("ERROR");

        private String name;

        public String getName() {
            return this.name;
        }

        private ToolMaterial(String s) {
            this.name = s;
        }
    }

    public static enum ToolType {
        SWORD("upgrade.minecraft:diamond_sword.adjective", "sword"),
        AXE("upgrade.minecraft:diamond_axe.adjective", "axe"),
        SHOVEL("upgrade.minecraft:diamond_shovel.adjective", "shovel"),
        PICKAXE("upgrade.minecraft:diamond_pickaxe.adjective", "pickaxe"),
        HOE("upgrade.minecraft:diamond_hoe.adjective", "hoe"),
        UNKNOWN("ERROR", "ERROR");

        private String adj;
        private String name;

        public String getAdj() {
            return this.adj;
        }

        public String getName() {
            return this.name;
        }

        private ToolType(String s, String s2) {
            this.adj = s;
            this.name = s2;
        }
    }
}

