/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.NEI;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.InfinityRaider.AgriCraft.AgriCraft;
import com.InfinityRaider.AgriCraft.blocks.BlockCustomWood;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.NEI.NEICropMutationHandler;
import com.InfinityRaider.AgriCraft.compatibility.NEI.NEICropProductHandler;
import com.InfinityRaider.AgriCraft.compatibility.arsmagica.ArsMagicaHelper;
import com.InfinityRaider.AgriCraft.compatibility.botania.BotaniaHelper;
import com.InfinityRaider.AgriCraft.compatibility.thaumcraft.ThaumcraftHelper;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.init.Crops;
import com.InfinityRaider.AgriCraft.init.CustomCrops;
import com.InfinityRaider.AgriCraft.init.Items;
import com.InfinityRaider.AgriCraft.init.ResourceCrops;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIConfig
implements IConfigureNEI {
    public void loadConfig() {
        LogHelper.debug("Registering NEI recipe handlers");
        NEICropMutationHandler mutationHandler = new NEICropMutationHandler();
        API.registerRecipeHandler((ICraftingHandler)mutationHandler);
        API.registerUsageHandler((IUsageHandler)mutationHandler);
        NEICropProductHandler productHandler = new NEICropProductHandler();
        API.registerRecipeHandler((ICraftingHandler)productHandler);
        API.registerUsageHandler((IUsageHandler)productHandler);
        NEIConfig.hideItems();
    }

    private static void hideItems() {
        LogHelper.debug("Hiding crops in NEI");
        for (int i = 0; i < 16; ++i) {
            AgriCraft.proxy.hideItemInNEI(new ItemStack(Blocks.blockCrop, 1, i));
            AgriCraft.proxy.hideItemInNEI(new ItemStack(Blocks.blockWaterPad, 1, i));
            AgriCraft.proxy.hideItemInNEI(new ItemStack(Blocks.blockWaterPadFull, 1, i));
            AgriCraft.proxy.hideItemInNEI(new ItemStack(Items.clipping, 1, i));
            if (!ConfigurationHandler.debug) {
                AgriCraft.proxy.hideItemInNEI(new ItemStack(Items.debugItem, 1, i));
            }
            for (BlockModPlant plant : Crops.crops) {
                AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
            }
            if (ModHelper.allowIntegration("Botania")) {
                for (BlockModPlant plant : BotaniaHelper.botaniaCrops) {
                    AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
                }
            }
            if (ModHelper.allowIntegration("Thaumcraft")) {
                for (BlockModPlant plant : ThaumcraftHelper.thaumcraftCrops) {
                    AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
                }
            }
            if (ModHelper.allowIntegration("arsmagica2")) {
                for (BlockModPlant plant : ArsMagicaHelper.arsMagicaCrops) {
                    AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
                }
            }
            if (ConfigurationHandler.resourcePlants) {
                for (BlockModPlant plant : ResourceCrops.vanillaCrops) {
                    AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
                }
                for (BlockModPlant plant : ResourceCrops.modCrops) {
                    AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)plant, 1, i));
                }
            }
            if (!ConfigurationHandler.customCrops) continue;
            for (BlockModPlant customCrop : CustomCrops.customCrops) {
                AgriCraft.proxy.hideItemInNEI(new ItemStack((Block)customCrop, 1, i));
            }
        }
        if (ConfigurationHandler.condenseCustomWoodInNei) {
            LogHelper.debug("Hiding custom wood objects");
            Field[] blocks = Blocks.class.getDeclaredFields();
            for (Field field : blocks) {
                try {
                    Object obj = field.get(null);
                    if (obj == null || !BlockCustomWood.class.isAssignableFrom(obj.getClass())) continue;
                    Block block = (Block)obj;
                    ItemStack stack = new ItemStack(block);
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    list.add(stack);
                    API.setItemListEntries((Item)stack.func_77973_b(), list);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getName() {
        return "AgriCraft_NEI";
    }

    public String getVersion() {
        return "1.0";
    }
}

