/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class CropProduce {
    public static final int DEFAULT_WEIGHT = 100;
    private ArrayList<Product> products = new ArrayList();
    private int totalWeight;

    public void addProduce(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        this.addProduce(stack, 100);
    }

    public void addProduce(ItemStack stack, int weight) {
        this.addProduce(stack, weight, false);
    }

    public void addProduce(ItemStack stack, int weight, int minGain) {
        this.addProduce(stack, weight, minGain, false);
    }

    public void addProduce(ItemStack stack, int weight, boolean overwrite) {
        this.addProduce(stack, weight, 1, overwrite);
    }

    public void addProduce(ItemStack stack, int weight, int minGain, boolean overwrite) {
        if (overwrite) {
            this.removeProduce(stack);
        }
        this.products.add(new Product(stack, weight, minGain));
        this.totalWeight += weight;
    }

    public void overwriteWeight(ItemStack stack, int weight) {
        this.addProduce(stack, weight, true);
    }

    public void removeProduce(ItemStack stack) {
        for (int i = 0; i < this.products.size(); ++i) {
            Product product = this.products.get(i);
            if (!product.product.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)product.product)) continue;
            this.totalWeight -= product.weight;
            this.products.remove(i);
        }
    }

    public ArrayList<ItemStack> getProduce(int amount, Random rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        while (amount > 0) {
            double stop = rand.nextDouble() * (double)this.totalWeight;
            for (Product product : this.products) {
                if (!((stop -= (double)product.weight) <= 0.0)) continue;
                results.add(product.product.func_77946_l());
                break;
            }
            --amount;
        }
        return results;
    }

    public ArrayList<ItemStack> getAllProducts() {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        for (Product product : this.products) {
            fruits.add(product.product.func_77946_l());
        }
        return fruits;
    }

    public int getWeight(ItemStack stack) {
        int weight = 0;
        for (Product product : this.products) {
            if (!product.product.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)product.product)) continue;
            weight = product.weight;
            break;
        }
        return weight;
    }

    private static class Product {
        protected ItemStack product;
        protected int weight;
        protected int minGain;

        public Product(ItemStack product, int weight) {
            this(product, weight, 1);
        }

        public Product(ItemStack product, int weight, int minGain) {
            this.product = product.func_77946_l();
            this.product.field_77994_a = 1;
            this.weight = weight;
            this.minGain = minGain;
        }
    }
}

