/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.blocks;

import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.IIrrigationComponent;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityTank;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityValve;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderChannel
extends RenderBlockCustomWood<TileEntityChannel> {
    public static AtomicInteger renderCallCounter = new AtomicInteger(0);

    public RenderChannel() {
        this(com.InfinityRaider.AgriCraft.init.Blocks.blockWaterChannel, new TileEntityChannel());
    }

    protected RenderChannel(Block block, TileEntityChannel channel) {
        super(block, channel, true);
    }

    @Override
    protected void renderInInventory(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        this.renderBottom((TileEntityChannel)this.teDummy, tessellator);
        this.renderSide((TileEntityChannel)this.teDummy, tessellator, ForgeDirection.NORTH);
        this.renderSide((TileEntityChannel)this.teDummy, tessellator, ForgeDirection.EAST);
        this.renderSide((TileEntityChannel)this.teDummy, tessellator, ForgeDirection.SOUTH);
        this.renderSide((TileEntityChannel)this.teDummy, tessellator, ForgeDirection.WEST);
        tessellator.func_78381_a();
    }

    @Override
    protected boolean doWorldRender(Tessellator tessellator, IBlockAccess world, double x, double y, double z, TileEntity tile, Block block, float f, int modelId, RenderBlocks renderer, boolean callFromTESR) {
        if (tile instanceof TileEntityChannel) {
            TileEntityChannel channel = (TileEntityChannel)tile;
            if (channel.func_145832_p() == 0) {
                if (callFromTESR) {
                    if (channel.getDiscreteFluidLevel() > 0) {
                        renderCallCounter.incrementAndGet();
                        GL11.glPushMatrix();
                        GL11.glDisable((int)2896);
                        tessellator.func_78382_b();
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                        this.drawWater(channel, tessellator);
                        tessellator.func_78381_a();
                        GL11.glEnable((int)2896);
                        GL11.glPopMatrix();
                    }
                } else {
                    this.renderWoodChannel(channel, tessellator);
                    if (!this.shouldBehaveAsTESR() && channel.getDiscreteFluidLevel() > 0) {
                        this.drawWater(channel, tessellator);
                    }
                }
            } else if (channel.func_145832_p() == 1) {
                this.renderIronChannel(channel, tessellator);
            }
        }
        renderer.func_147771_a();
        return true;
    }

    @Override
    public boolean shouldBehaveAsTESR() {
        return true;
    }

    @Override
    public boolean shouldBehaveAsISBRH() {
        return true;
    }

    protected void renderWoodChannel(TileEntityChannel channel, Tessellator tessellator) {
        this.renderBottom(channel, tessellator);
        this.renderSide(channel, tessellator, ForgeDirection.NORTH);
        this.renderSide(channel, tessellator, ForgeDirection.EAST);
        this.renderSide(channel, tessellator, ForgeDirection.SOUTH);
        this.renderSide(channel, tessellator, ForgeDirection.WEST);
    }

    protected void renderBottom(TileEntityChannel channel, Tessellator tessellator) {
        IIcon icon = channel.getIcon();
        int cm = channel.colorMultiplier();
        this.drawScaledPrism(tessellator, 4.0f, 4.0f, 4.0f, 12.0f, 5.0f, 12.0f, icon, cm);
        this.drawScaledPrism(tessellator, 4.0f, 5.0f, 4.0f, 5.0f, 12.0f, 5.0f, icon, cm);
        this.drawScaledPrism(tessellator, 11.0f, 5.0f, 4.0f, 12.0f, 12.0f, 5.0f, icon, cm);
        this.drawScaledPrism(tessellator, 4.0f, 5.0f, 11.0f, 5.0f, 12.0f, 12.0f, icon, cm);
        this.drawScaledPrism(tessellator, 11.0f, 5.0f, 11.0f, 12.0f, 12.0f, 12.0f, icon, cm);
    }

    protected void renderSide(TileEntityChannel channel, Tessellator tessellator, ForgeDirection dir) {
        IIcon icon = channel.getIcon();
        int cm = channel.colorMultiplier();
        if (channel.hasNeighbourCheck(dir)) {
            this.drawScaledPrism(tessellator, 4.0f, 4.0f, 0.0f, 12.0f, 5.0f, 4.0f, icon, cm, dir);
            this.drawScaledPrism(tessellator, 4.0f, 5.0f, 0.0f, 5.0f, 12.0f, 5.0f, icon, cm, dir);
            this.drawScaledPrism(tessellator, 11.0f, 5.0f, 0.0f, 12.0f, 12.0f, 5.0f, icon, cm, dir);
        } else {
            this.drawScaledPrism(tessellator, 4.0f, 4.0f, 4.0f, 12.0f, 12.0f, 5.0f, icon, cm, dir);
        }
    }

    private void renderIronChannel(TileEntityChannel channel, Tessellator tessellator) {
    }

    protected void drawWater(TileEntityChannel channel, Tessellator tessellator) {
        float y = channel.getFluidHeight();
        IIcon icon = Blocks.field_150355_j.func_149691_a(1, 0);
        int l = Blocks.field_150355_j.func_149720_d((IBlockAccess)channel.func_145831_w(), channel.field_145851_c, channel.field_145848_d, channel.field_145849_e);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        float f4 = 1.0f;
        tessellator.func_78380_c(Blocks.field_150355_j.func_149677_c((IBlockAccess)channel.func_145831_w(), channel.field_145851_c, channel.field_145848_d, channel.field_145849_e));
        tessellator.func_78369_a(f4 * f, f4 * f1, f4 * f2, 0.8f);
        this.drawPlane(tessellator, 5.0f, y - 0.001f, 5.0f, 11.0f, y - 0.001f, 11.0f, icon, ForgeDirection.NORTH);
        this.connectWater(channel, tessellator, ForgeDirection.NORTH, y, icon);
        this.connectWater(channel, tessellator, ForgeDirection.EAST, y, icon);
        this.connectWater(channel, tessellator, ForgeDirection.SOUTH, y, icon);
        this.connectWater(channel, tessellator, ForgeDirection.WEST, y, icon);
    }

    protected void connectWater(TileEntityChannel channel, Tessellator tessellator, ForgeDirection direction, float y, IIcon icon) {
        if (channel.hasNeighbourCheck(direction)) {
            float lvl;
            IIrrigationComponent te = channel.getNeighbor(direction);
            float y2 = te instanceof TileEntityChannel ? (te instanceof TileEntityValve && ((TileEntityValve)te).isPowered() ? y : (y + te.getFluidHeight()) / 2.0f) : ((lvl = te.getFluidHeight() - (float)(16 * ((TileEntityTank)te).getYPosition())) > 12.0f ? 12.0f : (lvl < 5.0f ? 4.9999f : lvl));
            this.drawWaterEdge(tessellator, direction, y, y2, icon);
        }
    }

    protected void drawWaterEdge(Tessellator tessellator, ForgeDirection direction, float lvl1, float lvl2, IIcon icon) {
        this.drawPlane(tessellator, 5.0f, lvl1 - 0.001f, 0.0f, 11.0f, lvl2 - 0.001f, 5.0f, icon, direction);
    }
}

