/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.storage;

import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SeedStorageSlot {
    private NBTTagCompound tag;
    public int count;
    final int slotId;
    final int invId;

    public SeedStorageSlot(NBTTagCompound tag, int nr, int slotId, int invId) {
        this.tag = tag;
        this.count = nr;
        this.slotId = slotId;
        this.invId = invId;
    }

    public ItemStack getStack(Item item, int meta) {
        ItemStack stack = new ItemStack(item, this.count, meta);
        stack.field_77990_d = (NBTTagCompound)this.tag.func_74737_b();
        return stack;
    }

    public NBTTagCompound getTag() {
        return (NBTTagCompound)this.tag.func_74737_b();
    }

    private int getTotalStat() {
        return this.tag.func_74762_e("growth") + this.tag.func_74762_e("gain") + this.tag.func_74762_e("strength");
    }

    public int getId() {
        return this.invId >= 0 ? 1000 * this.invId + this.slotId : this.slotId;
    }

    public static class SlotComparator
    implements Comparator<SeedStorageSlot> {
        private final String stat;

        public SlotComparator(String stat) {
            this.stat = stat;
        }

        @Override
        public int compare(SeedStorageSlot o1, SeedStorageSlot o2) {
            int stat1 = o1.tag.func_74762_e(this.stat);
            int stat2 = o2.tag.func_74762_e(this.stat);
            if (stat2 == stat1) {
                return o2.getTotalStat() - o1.getTotalStat();
            }
            return stat2 - stat1;
        }
    }
}

