/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class IOHelper {
    private static final String grassDropInstructions = "#Put a list of seeds here that will drop from tall grass with the following schematic: <seedname:seedmeta>,<weight>\n#The seedname should be the name NEI gives you, the weight is the weighted chance for this seed to drop (for reference, minecraft wheat seeds have weight 10)\n#Only define one seed per line, meta is optional. Example: minecraft:melon_seeds,10\nAgriCraft:seedCarrot,10\nAgriCraft:seedPotato,10\n";
    private static final String customCropInstructions = "#Define custom crops here: <name>,<fruit:fruitmeta>,<soil>,<baseblock:baseblockmeta>,<tier>,<rendermethod>,<information>,<shearable>\n# - name:         is the name of the crop you want, for example: claysanthemum\n# - fruit:        the fruit you want the crop to produce, for example: minecraft:clay:0 (metadata is optional, you can get this from NEI). Type \"null\" if you want the crop to have no fruit.\n# - soil:         the soil you want the crop to be planted on, if you specify null, it will grow on farmland and any soil you whitelisted. Other possible soils are soulsand, sand or mycelium.\n# - baseblock:    this is the block that has to be underneath for the plant to grow, for example: (this can also be gotten from NEI, if you don't want to specify, type null)\n# - tier:         from 1 to 5, the higher, the slower the crop will grow\n# - rendermethod: put 1 to render like a flower (in an X-pattern), put 6 to render like wheat (hashtag-pattern)\n# - information:  put a short description (in the same line) of the crop. This will appear in the journal\n# - shearable:    (optional) the item this plant drops when sheared\n#you will need to make a texture pack and add textures for the crops in agricraft/blocks with the name cropName1, cropName2, cropName3, cropName4\n#where name is the name you specified here, there have to be 4 textures, texture 4 is the mature one\n#for the seed texture, put a texture named seedName in the agricraft/items of your resourcepack\n#Example: claysanthemum,minecraft:clay,minecraft:sand,minecraft:hardened_clay,2,6,a crop that extracts clay from the soil to grow clay buds.\n#this will need textures cropClaysanthemum1, cropClaysanthemum2, Claysanthemum3, Claysanthemum4 in the agricraft/textures/blocks folder and seedClaysanthemum in the agricraft/textures/items folder of your resourcepack.\n#Note the capitalization, always put a capital in the texture name. Also, this crop will not grow unless it has a hardened clay block underneath the block of farmland it's on";
    private static final String seedBlackListInstructions = "#Define blacklisted seeds here: <mod>:<seedname>:<seedmeta>\n#You can get these values from NEI\n#Blacklisted seeds will not be able to planted on crops\n#For example: AgriCraft:seedDandelion";
    private static final String plantingExceptionsInstructions = "#Define seeds that will ignore the vanilla planting rule here: <mod>:<seedname>:<seedmeta>\n#You can get these values from NEI\n#All seeds defined here will still be able to be planted outside of crops when vanilla farming is disabled\n#For example: AgriCraft:seedDandelion";
    private static final String soilWhitelistInstructions = "#Define blocks to whitelist as fertile soil here: <mod>:<blockname>:<blockmeta>\n#You can get these values from NEI\n#Whitelisting a block as a fertile soil means you can plant crops on them\n#Note that this only works for crops that can be planted on farmland, crops that require a specific soil (e.g. nether wart or cactus) will still need that particular soil\n#For example: Forestry:soil:0 (this will add forestry humus to the whitelist)";
    private static final String spreadChancesOverridesInstructions = "#Define overrides for spreading chances here: <mod>:<seedname>:<seedmeta>,<chance>\n#You can get these values from NEI (example: minecraft:wheat_seeds is the vanilla seeds)\n#The chance is an integer specified in percent, minimum is 0, maximum a 100. Spread chance is the chance that crops will spread to empty crosscrops\n#For example: AgriCraft:seedDandelion,85";
    private static final String seedTierOverridesInstructions = "#Define overrides for seed tiers here: <mod>:<seedname>:<seedmeta>,<tier>\n#You can get these values from NEI (example: minecraft:wheat_seeds is the vanilla seeds)\n#The tier is an integer between 1 and 5 (1 and 5 included). The higher the tier, the slower it will grow, mutate, be analysed, ...\n#For example: AgriCraft:seedDandelion,2";
    private static final String mutationInstructions = "#ONLY MODIFY THIS CONFIG IF YOU DO NOT WANT TO USE MINETWEAKER, IF YOU WANT TO MODIFY MUTATIONS USE MINETWEAKER, THIS CONFIG IS ONLY FOR PEOPLE WHO DON'T USE MINETWEAKER\n#Define mutations here: <mutation>=<parent1>+<parent2>\n#To specify a crop, write <mod>:<cropname>:<meta>, all in lowercase (meta is optional)\n#You can get these values from NEI (example: minecraft:wheat_seeds is the vanilla seeds)\n";
    private static final String harvestcraftMutations = "harvestcraft:artichokeseedItem=harvestcraft:asparagusseedItem+harvestcraft:lettuceseedItem\nharvestcraft:asparagusseedItem=harvestcraft:scallionseedItem+harvestcraft:cornseedItem\nharvestcraft:bambooshootseedItem=harvestcraft:cornseedItem+harvestcraft:riceseedItem\nharvestcraft:beanseedItem=minecraft:pumpkin_seeds+AgriCraft:seedPotato\nharvestcraft:beetseedItem=harvestcraft:radishseedItem+AgriCraft:seedCarrot\nharvestcraft:bellpepperseedItem=harvestcraft:chilipepperseedItem+harvestcraft:spiceleafseedItem\nharvestcraft:blackberryseedItem=harvestcraft:strawberryseedItem+harvestcraft:blueberryseedItem\nharvestcraft:blueberryseedItem=harvestcraft:strawberryseedItem+AgriCraft:seedOrchid\nharvestcraft:broccoliseedItem=harvestcraft:lettuceseedItem+AgriCraft:seedDaisy\nharvestcraft:brusselsproutseedItem=harvestcraft:cabbageseedItem+harvestcraft:peasseedItem\nharvestcraft:cabbageseedItem=harvestcraft:broccoliseedItem+harvestcraft:lettuceseedItem\nharvestcraft:cactusfruitseedItem=harvestcraft:kiwiseedItem+harvestcraft:bambooshootseedItem\nharvestcraft:candleberryseedItem=harvestcraft:cactusfruitseedItem+harvestcraft:grapeseedItem\nharvestcraft:cantaloupeseedItem=minecraft:melon_seeds+harvestcraft:strawberryseedItem\nharvestcraft:cauliflowerseedItem=harvestcraft:cabbageseedItem+harvestcraft:lettuceseedItem\nharvestcraft:celeryseedItem=minecraft:wheat_seeds+AgriCraft:seedAllium\nharvestcraft:chilipepperseedItem=harvestcraft:tomatoseedItem+harvestcraft:onionseedItem\nharvestcraft:coffeeseedItem=harvestcraft:beanseedItem+AgriCraft:seedSugarcane\nharvestcraft:cranberryseedItem=harvestcraft:blueberryseedItem+harvestcraft:grapeseedItem\nharvestcraft:cucumberseedItem=harvestcraft:peasseedItem+harvestcraft:okraseedItem\nharvestcraft:eggplantseedItem=harvestcraft:zucchiniseedItem+harvestcraft:tomatoseedItem\nharvestcraft:garlicseedItem=harvestcraft:onionseedItem+harvestcraft:gingerseedItem\nharvestcraft:gingerseedItem=harvestcraft:mustardseedItem+harvestcraft:peanutseedItem\nharvestcraft:grapeseedItem=harvestcraft:blueberryseedItem+harvestcraft:cantaloupeseedItem\nharvestcraft:kiwiseedItem=harvestcraft:cantaloupeseedItem+harvestcraft:strawberryseedItem\nharvestcraft:leekseedItem=harvestcraft:scallionseedItem+harvestcraft:celeryseedItem\nharvestcraft:lettuceseedItem=AgriCraft:seedDaisy+harvestcraft:celeryseedItem\nharvestcraft:spinachseedItem=harvestcraft:lettuceseedItem+AgriCraft:seedCactus\nharvestcraft:mustardseedItem=harvestcraft:chilipepperseedItem+harvestcraft:beanseedItem\nharvestcraft:oatsseedItem=harvestcraft:cornseedItem+harvestcraft:riceseedItem\nharvestcraft:okraseedItem=harvestcraft:beanseedItem+harvestcraft:leekseedItem\nharvestcraft:onionseedItem=harvestcraft:celeryseedItem+harvestcraft:brusselsproutseedItem\nharvestcraft:parsnipseedItem=AgriCraft:seedCarrot+harvestcraft:beetseedItem\nharvestcraft:peanutseedItem=harvestcraft:peasseedItem+harvestcraft:bambooshootseedItem\nharvestcraft:peasseedItem=harvestcraft:soybeanseedItem+harvestcraft:okraseedItem\nharvestcraft:pineappleseedItem=harvestcraft:bambooshootseedItem+harvestcraft:cantaloupeseedItem\nharvestcraft:radishseedItem=harvestcraft:tomatoseedItem+harvestcraft:brusselsproutseedItem\nharvestcraft:strawberryseedItem=harvestcraft:radishseedItem+AgriCraft:seedPoppy\nharvestcraft:raspberryseedItem=harvestcraft:strawberryseedItem+AgriCraft:seedTulipRed\nharvestcraft:rhubarbseedItem=AgriCraft:seedSugarcane+harvestcraft:lettuceseedItem\nharvestcraft:riceseedItem=harvestcraft:ryeseedItem+AgriCraft:seedSugarcane\nharvestcraft:rutabagaseedItem=harvestcraft:beetseedItem+harvestcraft:turnipseedItem\nharvestcraft:scallionseedItem=AgriCraft:seedCarrot+AgriCraft:seedSugarcane\nharvestcraft:seaweedseedItem=harvestcraft:lettuceseedItem+harvestcraft:celeryseedItem\nharvestcraft:soybeanseedItem=harvestcraft:beanseedItem+harvestcraft:riceseedItem\nharvestcraft:spiceleafseedItem=harvestcraft:teaseedItem+harvestcraft:chilipepperseedItem\nharvestcraft:sweetpotatoseedItem=AgriCraft:seedPotato+AgriCraft:seedSugarcane\nharvestcraft:teaseedItem=harvestcraft:seaweedseedItem+AgriCraft:seedDaisy\nharvestcraft:tomatoseedItem=harvestcraft:sweetpotatoseedItem+AgriCraft:seedCarrot\nharvestcraft:turnipseedItem=harvestcraft:parsnipseedItem+harvestcraft:radishseedItem\nharvestcraft:wintersquashseedItem=minecraft:pumpkin_seeds+harvestcraft:zucchiniseedItem\nharvestcraft:zucchiniseedItem=minecraft:pumpkin_seeds+harvestcraft:cucumberseedItem\nharvestcraft:whitemushroomseedItem=AgriCraft:seedShroomRed+AgriCraft:seedShroomBrown\nharvestcraft:curryleafseedItem=harvestcraft:spiceleafseedItem+harvestcraft:mustardseedItem\nharvestcraft:sesameseedsseedItem=harvestcraft:riceseedItem+harvestcraft:coffeeseedItem\nharvestcraft:waterchestnutseedItem=harvestcraft:sesameseedsseedItem+harvestcraft:seaweedseedItem";
    private static final String weeeFlowersMutations = "weeeflowers:Red Flower Seed=AgriCraft:seedPoppy+AgriCraft:seedCarrot\nweeeflowers:Yellow Flower Seed=AgriCraft:seedDandelion+minecraft:pumpkin_seeds\nweeeflowers:Orange Flower Seed=weeeflowers:Yellow Flower Seed+weeeflowers:Red Flower Seed\nweeeflowers:White Flower Seed=AgriCraft:seedTulipWhite+AgriCraft:seedAllium\nweeeflowers:Pink Flower Seed=weeeflowers:Red Flower Seed+weeeflowers:White Flower Seed\nweeeflowers:Blue Flower Seed=AgriCraft:seedOrchid+AgriCraft:seedDaisy\nweeeflowers:Light Blue Flower Seed=weeeflowers:Blue Flower Seed+weeeflowers:White Flower Seed\nweeeflowers:Purple Flower Seed=weeeflowers:Blue Flower Seed+weeeflowers:Red Flower Seed\nweeeflowers:Magenta Flower Seed=weeeflowers:Purple Flower Seed+weeeflowers:Pink Flower Seed\nweeeflowers:Green Flower Seed=weeeflowers:Yellow Flower Seed+weeeflowers:Blue Flower Seed\nweeeflowers:Lime Flower Seed=weeeflowers:Green Flower Seed+weeeflowers:White Flower Seed\nweeeflowers:Black Flower Seed=weeeflowers:Blue Flower Seed+weeeflowers:Green Flower Seed\nweeeflowers:Light Grey Flower Seed=weeeflowers:Black Flower Seed+weeeflowers:White Flower Seed\nweeeflowers:Dark Grey Flower Seed=weeeflowers:Light Grey Flower Seed+weeeflowers:Black Flower Seed\nweeeflowers:Cyan Flower Seed=weeeflowers:Lime Flower Seed+weeeflowers:Light Blue Flower Seed\nweeeflowers:Brown Flower Seed=weeeflowers:Green Flower Seed+weeeflowers:Red Flower Seed";
    private static final String botaniaMutations = "AgriCraft:seedBotaniaRed=AgriCraft:seedPoppy+AgriCraft:seedTulipRed\nAgriCraft:seedBotaniaYellow=AgriCraft:seedDandelion+AgriCraft:seedTulipOrange\nAgriCraft:seedBotaniaBlue=AgriCraft:seedOrchid+AgriCraft:seedAllium\nAgriCraft:seedBotaniaOrange=AgriCraft:seedBotaniaYellow+AgriCraft:seedBotaniaRed\nAgriCraft:seedBotaniaPurple=AgriCraft:seedBotaniaMagenta+AgriCraft:seedBotaniaBlue\nAgriCraft:seedBotaniaGreen=AgriCraft:seedBotaniaBlue+AgriCraft:seedBotaniaYellow\nAgriCraft:seedBotaniaMagenta=AgriCraft:seedBotaniaRed+AgriCraft:seedBotaniaBlue\nAgriCraft:seedBotaniaPink=AgriCraft:seedBotaniaPurple+AgriCraft:seedBotaniaWhite\nAgriCraft:seedBotaniaLime=AgriCraft:seedBotaniaWhite+AgriCraft:seedBotaniaGreen\nAgriCraft:seedBotaniaCyan=AgriCraft:seedBotaniaGreen+AgriCraft:seedBotaniaBlue\nAgriCraft:seedBotaniaLightBlue=AgriCraft:seedBotaniaBlue+AgriCraft:seedBotaniaWhite\nAgriCraft:seedBotaniaBlack=AgriCraft:seedBotaniaBlue+AgriCraft:seedCactus\nAgriCraft:seedBotaniaWhite=AgriCraft:seedTulipWhite+AgriCraft:seedDaisy\nAgriCraft:seedBotaniaGray=AgriCraft:seedBotaniaBlack+AgriCraft:seedBotaniaWhite\nAgriCraft:seedBotaniaLightGray=AgriCraft:seedBotaniaGray+AgriCraft:seedBotaniaWhite\nAgriCraft:seedBotaniaBrown=AgriCraft:seedBotaniaPurple+AgriCraft:seedBotaniaGreen";
    private static final String minecraftMutations = "AgriCraft:seedSugarcane=minecraft:wheat_seeds+AgriCraft:seedCarrot\nAgriCraft:seedCactus=AgriCraft:seedSugarcane+AgriCraft:seedPoppy\nminecraft:pumpkin_seeds=AgriCraft:seedPotato+AgriCraft:seedCarrot\nminecraft:melon_seeds=AgriCraft:seedCarrot+minecraft:pumpkin_seeds\nAgriCraft:seedPoppy=AgriCraft:seedSugarcane+minecraft:pumpkin_seeds\nAgriCraft:seedDandelion=AgriCraft:seedSugarcane+minecraft:melon_seeds\nAgriCraft:seedOrchid=AgriCraft:seedPoppy+AgriCraft:seedDandelion\nAgriCraft:seedAllium=AgriCraft:seedPoppy+AgriCraft:seedOrchid\nAgriCraft:seedTulipRed=AgriCraft:seedPoppy+AgriCraft:seedAllium\nAgriCraft:seedTulipOrange=AgriCraft:seedDaisy+AgriCraft:seedOrchid\nAgriCraft:seedTulipWhite=AgriCraft:seedDaisy+AgriCraft:seedDandelion\nAgriCraft:seedTulipPink=AgriCraft:seedAllium+AgriCraft:seedDandelion\nAgriCraft:seedDaisy=AgriCraft:seedDandelion+AgriCraft:seedOrchid\nAgriCraft:seedShroomRed=minecraft:nether_wart+AgriCraft:seedPoppy\nAgriCraft:seedShroomBrown=minecraft:nether_wart+AgriCraft:seedPotato\n";
    private static final String agricraftMutations = "AgriCraft:seedRedstodendron=AgriCraft:seedTulipRed+AgriCraft:seedDaisy\nAgriCraft:seedLapender=AgriCraft:seedTulipPink+AgriCraft:seedOrchid\nAgriCraft:seedFerranium=AgriCraft:seedLapender+AgriCraft:seedTulipWhite\nAgriCraft:seedAurigold=AgriCraft:seedRedstodendron+AgriCraft:seedTulipOrange\nAgriCraft:seedDiamahlia=AgriCraft:seedAurigold+AgriCraft:seedLapender\nAgriCraft:seedEmeryllis=AgriCraft:seedFerranium+AgriCraft:seedRedstodendron\nAgriCraft:seedNitorWart=minecraft:nether_wart+AgriCraft:seedTulipOrange\nAgriCraft:seedQuartzanthemum=AgriCraft:seedNitorWart+AgriCraft:seedLapender";
    private static final String barleyHarvestCraftMutations = "harvestcraft:barleyseedItem=minecraft:wheat_seeds+AgriCraft:seedSugarcane\nharvestcraft:cornseedItem=harvestcraft:barleyseedItem+harvestcraft:ryeseedItem\nharvestcraft:ryeseedItem=harvestcraft:barleyseedItem+minecraft:wheat_seeds\nharvestcraft:cottonseedItem=harvestcraft:barleyseedItem+AgriCraft:seedDaisy";
    private static final String naturaMutations = "Natura:barley.seed:0=minecraft:wheat_seeds+AgriCraft:seedSugarcane\nNatura:barley.seed:1=Natura:barley.seed:0+AgriCraft:seedDaisy";
    private static final String barleyNaturaMutations = "Natura:barley.seed:0=minecraft:wheat_seeds+AgriCraft:seedSugarcane\nharvestcraft:cornseedItem=Natura:barley.seed:0+harvestcraft:ryeseedItem\nharvestcraft:ryeseedItem=Natura:barley.seed:0+minecraft:wheat_seeds\nNatura:barley.seed:1=Natura:barley.seed:0+AgriCraft:seedDaisy";
    private static final String plantMegaPackMutations = "plantmegapack:seedCelery=minecraft:wheat_seeds+AgriCraft:seedTulipWhite\nplantmegapack:seedTomato=minecraft:melon_seeds+AgriCraft:seedCarrot\nplantmegapack:seedBroccoli=plantmegapack:seedSpinach+plantmegapack:seedCelery\nplantmegapack:seedBeet=plantmegapack:seedTomato+AgriCraft:seedPotato\nplantmegapack:seedCassava=plantmegapack:seedBeet+plantmegapack:seedCorn\nplantmegapack:seedGreenBean=plantmegapack:seedCucumber+plantmegapack:seedCelery\nplantmegapack:seedLeek=plantmegapack:seedGreenBean+plantmegapack:seedCucumber\nplantmegapack:seedLettuce=plantmegapack:seedCelery+AgriCraft:seedDaisy\nplantmegapack:seedSpinach=plantmegapack:seedLettuce+AgriCraft:seedSugarcane\nplantmegapack:seedCorn=minecraft:wheat_seeds+plantmegapack:seedCelery\nplantmegapack:seedBellPepperYellow=AgriCraft:seedCarrot+AgriCraft:seedDandelion\nplantmegapack:seedBellPepperOrange=plantmegapack:seedBellPepperYellow+plantmegapack:seedTomato\nplantmegapack:seedBellPepperRed=plantmegapack:seedBellPepperOrange+plantmegapack:seedTomato\nplantmegapack:seedSorrel=plantmegapack:seedBroccoli+plantmegapack:seedCassava\nplantmegapack:seedCucumber=plantmegapack:seedBeet+plantmegapack:seedBellPepperYellow\nplantmegapack:seedEggplant=plantmegapack:seedBeet+plantmegapack:seedCucumber";
    private static final String chococraftMutations = "chococraft:Gysahl_Seeds=AgriCraft:seedPotato+AgriCraft:seedTulipRed";
    private static final String chococraft_harvestcraftMutations = "chococraft:Gysahl_Seeds=harvestcraft:rutabagaseedItem+harvestcraft:beetseedItem";
    private static final String psychedelicraftMutations = "psychedelicraft:tobaccoSeeds=AgriCraft:seedShroomBrown+minecraft:nether_wart\npsychedelicraft:hop_seeds=psychedelicraft:tobaccoSeeds+minecraft:wheat_seeds\npsychedelicraft:cannabisSeeds=psychedelicraft:coffeaCherries+psychedelicraft:hop_seeds\npsychedelicraft:cocaSeeds=psychedelicraft:cannabisSeeds+psychedelicraft:hop_seeds\npsychedelicraft:coffeaCherries=psychedelicraft:hop_seeds+psychedelicraft:tobaccoSeeds";
    private static final String thaumcraft_ArsMagicaMutations = "AgriCraft:seedCinderpearl=AgriCraft:seedCactus+AgriCraft:seedTulipRed\nAgriCraft:seedDesertNova=AgriCraft:seedCinderpearl+AgriCraft:seedTulipRed\nAgriCraft:seedCerublossom=AgriCraft:seedDesertNova+AgriCraft:seedCinderpearl\nAgriCraft:seedAum=AgriCraft:seedCerublossom+AgriCraft:seedCinderpearl\nAgriCraft:seedWakebloom=AgriCraft:seedAum+AgriCraft:seedCerublossom\nAgriCraft:seedVishroom=AgriCraft:seedShroomBrown+AgriCraft:seedShimmerleaf\nAgriCraft:seedTarmaRoot=AgriCraft:seedDesertNova+AgriCraft:seedShroomBrown\nAgriCraft:seedShimmerleaf=AgriCraft:seedCerublossom+AgriCraft:seedTulipWhite\nAgriCraft:seedTaintedRoot=AgriCraft:seedVishroom+AgriCraft:seedTarmaRoot";
    private static final String thaumcraftMutations = "AgriCraft:seedCinderpearl=AgriCraft:seedCactus+AgriCraft:seedTulipRed\nAgriCraft:seedShimmerleaf=AgriCraft:seedTulipWhite+AgriCraft:seedCinderpearl\nAgriCraft:seedVishroom=AgriCraft:seedShroomBrown+AgriCraft:seedShimmerleaf\nAgriCraft:seedTaintedRoot=AgriCraft:seedVishroom+minecraft:nether_wart";
    private static final String arsMagicaMutations = "AgriCraft:seedDesertNova=AgriCraft:seedCactus+AgriCraft:seedTulipRed\nAgriCraft:seedCerublossom=AgriCraft:seedDesertNova+AgriCraft:seedOrchid\nAgriCraft:seedAum=AgriCraft:seedCerublossom+AgriCraft:seedTulipWhite\nAgriCraft:seedTarmaRoot=AgriCraft:seedDesertNova+AgriCraft:seedShroomBrown\nAgriCraft:seedWakebloom=AgriCraft:seedAum+AgriCraft:seedCerublossom";
    private static final String copperMutation = "AgriCraft:seedCuprosia=AgriCraft:seedRedstodendron+AgriCraft:seedTulipRed";
    private static final String tinMutation = "AgriCraft:seedPetinia=AgriCraft:seedLapender+AgriCraft:seedDaisy";
    private static final String leadMutation = "AgriCraft:seedPlombean=AgriCraft:seedFerranium+AgriCraft:seedPotato";
    private static final String silverMutation = "AgriCraft:seedSilverweed=AgriCraft:seedAurigold+AgriCraft:seedAllium";
    private static final String aluminumMutation = "AgriCraft:seedJaslumine=AgriCraft:seedFerranium+minecraft:wheat_seeds";
    private static final String nickelMutation = "AgriCraft:seedNiccissus=AgriCraft:seedAurigold+AgriCraft:seedDandelion";
    private static final String platinumMutation = "AgriCraft:seedPlatiolus=AgriCraft:seedDiamahlia+AgriCraft:seedFerranium";
    private static final String osmiumMutation = "AgriCraft:seedOsmonium=AgriCraft:seedFerranium+AgriCraft:seedOrchid";

    public static String getModId(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        int split = name.indexOf(58);
        if (split >= 0) {
            name = name.substring(0, split);
        }
        return name;
    }

    public static String readOrWrite(String directory, String fileName, String defaultData) {
        return IOHelper.readOrWrite(directory, fileName, defaultData, false);
    }

    public static String readOrWrite(String directory, String fileName, String defaultData, boolean reset) {
        Path path = Paths.get(directory, fileName + ".txt");
        try {
            if (Files.isRegularFile(path, new LinkOption[0]) && !reset) {
                return new String(Files.readAllBytes(path));
            }
            Files.write(path, defaultData.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LogHelper.info("Caught IOException when reading " + path.getFileName());
        }
        return defaultData;
    }

    public static String splitInLines(FontRenderer fontRendererObj, String input, float maxWidth, float scale) {
        maxWidth /= scale;
        String notProcessed = input;
        String output = "";
        while ((float)fontRendererObj.func_78256_a(notProcessed) > maxWidth) {
            int index = 0;
            if (notProcessed == null || notProcessed.equals("")) continue;
            while (notProcessed.length() - 1 > index && (float)fontRendererObj.func_78256_a(notProcessed.substring(0, index)) < maxWidth) {
                index = index + 1 < notProcessed.length() ? index + 1 : index;
            }
            while (index > 0 && notProcessed.charAt(index) != ' ') {
                --index;
            }
            output = output.equals("") ? output : output + '\n';
            output = output + notProcessed.substring(0, index);
            notProcessed = notProcessed.length() > index + 1 ? notProcessed.substring(index + 1) : notProcessed;
        }
        return output + '\n' + notProcessed;
    }

    public static void initSeedBlackList() {
        String[] data;
        for (String line : data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedBlackList())) {
            LogHelper.debug(new StringBuffer("parsing ").append(line));
            ItemStack seedStack = IOHelper.getStack(line);
            boolean success = seedStack != null && seedStack.func_77973_b() != null;
            String errorMsg = "Invalid seed";
            if (success) {
                CropPlantHandler.addSeedToBlackList(seedStack);
                continue;
            }
            LogHelper.info(new StringBuffer("Error when adding seed to blacklist: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    public static void initSeedTiers() {
        String[] input = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedTiers());
        LogHelper.debug("reading seed tier overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                CropPlant plant = CropPlantHandler.getPlantFromStack(seedStack);
                success = plant != null;
                errorMsg = "Invalid seed";
                if (success) {
                    int tier = Integer.parseInt(data[1]);
                    success = tier >= 1 && tier <= 5;
                    errorMsg = "Tier should be between 1 and 5";
                    if (success) {
                        plant.setTier(tier);
                        LogHelper.info(" - " + Item.field_150901_e.func_148750_c((Object)plant.getSeed().func_77973_b()) + ':' + plant.getSeed().func_77960_j() + " - tier: " + tier);
                    }
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding seed tier override: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    public static void initSpreadChancesOverrides() {
        String[] input = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSpreadChances());
        LogHelper.debug("reading mutation chance overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                CropPlant plant = CropPlantHandler.getPlantFromStack(seedStack);
                success = plant != null;
                errorMsg = "Invalid seed";
                if (success) {
                    int chance = Integer.parseInt(data[1]);
                    success = chance >= 0 && chance <= 100;
                    errorMsg = "Chance should be between 0 and 100";
                    if (success) {
                        plant.setSpreadChance(chance);
                        LogHelper.debug("Set spread chance for " + Item.field_150901_e.func_148750_c((Object)plant.getSeed().func_77973_b()) + ':' + plant.getSeed().func_77960_j() + " to " + chance + '%');
                    }
                }
            }
            if (success) continue;
            LogHelper.debug("Error when adding mutation chance override: " + errorMsg + " (line: " + line + ")");
        }
        LogHelper.debug("Registered Mutations Chances overrides:");
    }

    public static void initVannilaPlantingOverrides() {
        String[] data;
        LogHelper.debug("Registered seeds ignoring vanilla planting rule:");
        for (String line : data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readVanillaOverrides())) {
            LogHelper.debug(new StringBuffer("parsing ").append(line));
            ItemStack seedStack = IOHelper.getStack(line);
            CropPlant plant = CropPlantHandler.getPlantFromStack(seedStack);
            boolean success = plant != null;
            String errorMsg = "Invalid seed";
            if (success) {
                plant.setIgnoreVanillaPlantingRule(true);
                LogHelper.debug(Item.field_150901_e.func_148750_c((Object)plant.getSeed().func_77973_b()) + ":" + plant.getSeed().func_77960_j());
                continue;
            }
            LogHelper.debug("Error when adding seed to vanilla overrides: " + errorMsg + " (line: " + line + ")");
        }
    }

    public static String getDefaultMutations() {
        String data = mutationInstructions;
        data = data + '\n' + minecraftMutations;
        if (ConfigurationHandler.resourcePlants) {
            data = data + '\n' + agricraftMutations;
            if (OreDictHelper.getOreBlockForName("Copper") != null) {
                data = data + '\n' + copperMutation;
            }
            if (OreDictHelper.getOreBlockForName("Tin") != null) {
                data = data + '\n' + tinMutation;
            }
            if (OreDictHelper.getOreBlockForName("Lead") != null) {
                data = data + '\n' + leadMutation;
            }
            if (OreDictHelper.getOreBlockForName("Silver") != null) {
                data = data + '\n' + silverMutation;
            }
            if (OreDictHelper.getOreBlockForName("Aluminum") != null) {
                data = data + '\n' + aluminumMutation;
            }
            if (OreDictHelper.getOreBlockForName("Nickel") != null) {
                data = data + '\n' + nickelMutation;
            }
            if (OreDictHelper.getOreBlockForName("Platinum") != null) {
                data = data + '\n' + platinumMutation;
            }
            if (OreDictHelper.getOreBlockForName("Osmium") != null) {
                data = data + '\n' + osmiumMutation;
            }
        }
        if (ModHelper.allowIntegration("Botania")) {
            data = data + '\n' + botaniaMutations;
        }
        if (ModHelper.allowIntegration("harvestcraft") && ModHelper.allowIntegration("Natura")) {
            data = data + '\n' + harvestcraftMutations + '\n' + barleyNaturaMutations;
        } else {
            if (ModHelper.allowIntegration("harvestcraft")) {
                data = data + '\n' + harvestcraftMutations + '\n' + barleyHarvestCraftMutations;
            }
            if (ModHelper.allowIntegration("Natura")) {
                data = data + '\n' + naturaMutations;
            }
        }
        if (ModHelper.allowIntegration("weeeflowers")) {
            data = data + '\n' + weeeFlowersMutations;
        }
        if (ModHelper.allowIntegration("plantmegapack")) {
            data = data + '\n' + plantMegaPackMutations;
        }
        if (ModHelper.allowIntegration("chococraft")) {
            data = ModHelper.allowIntegration("harvestcraft") ? data + '\n' + chococraft_harvestcraftMutations : data + '\n' + chococraftMutations;
        }
        if (ModHelper.allowIntegration("psychedelicraft")) {
            data = data + '\n' + psychedelicraftMutations;
        }
        if (ModHelper.allowIntegration("Thaumcraft") && ModHelper.allowIntegration("arsmagica2")) {
            data = data + '\n' + thaumcraft_ArsMagicaMutations;
        } else if (ModHelper.allowIntegration("Thaumcraft")) {
            data = data + '\n' + thaumcraftMutations;
        } else if (ModHelper.allowIntegration("arsmagica2")) {
            data = data + '\n' + arsMagicaMutations;
        }
        return data;
    }

    public static String getCustomCropInstructions() {
        return customCropInstructions;
    }

    public static String getGrassDrops() {
        return grassDropInstructions;
    }

    public static String getSpreadChancesOverridesInstructions() {
        return spreadChancesOverridesInstructions;
    }

    public static String getSeedTierOverridesInstructions() {
        return seedTierOverridesInstructions;
    }

    public static String getSeedBlackListInstructions() {
        return seedBlackListInstructions;
    }

    public static String getPlantingExceptionsInstructions() {
        return plantingExceptionsInstructions;
    }

    public static String getSoilwhitelistData() {
        return soilWhitelistInstructions;
    }

    public static String[] getLinesArrayFromData(String input) {
        int count = 0;
        String unprocessed = input;
        for (int i = 0; i < unprocessed.length(); ++i) {
            if (unprocessed.charAt(i) != '\n') continue;
            ++count;
        }
        ArrayList<String> data = new ArrayList<String>(count + 1);
        if (unprocessed.length() > 0) {
            for (int i = 0; i < count; ++i) {
                String line = unprocessed.substring(0, unprocessed.indexOf(10)).trim();
                if (line.length() > 0 && line.charAt(0) != '#') {
                    data.add(line);
                }
                unprocessed = unprocessed.substring(unprocessed.indexOf(10) + 1);
            }
        }
        if ((unprocessed = unprocessed.trim()).length() > 0 && unprocessed.charAt(0) != '#') {
            data.add(unprocessed);
        }
        return data.toArray(new String[data.size()]);
    }

    public static String[] getData(String input) {
        ArrayList<String> output = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ',' || input.charAt(i + 1) == ' ') continue;
            String element = input.substring(start, i).trim();
            if (element.length() > 0) {
                output.add(element);
            }
            start = i + 1;
        }
        String element = input.substring(start).trim();
        if (element.length() > 0) {
            output.add(element);
        }
        return output.toArray(new String[output.size()]);
    }

    public static ItemStack getStack(String input) {
        String[] data = input.split(":");
        if (data.length <= 1) {
            return null;
        }
        int meta = data.length == 3 ? Integer.parseInt(data[2]) : 0;
        ItemStack stack = GameRegistry.findItemStack((String)data[0], (String)data[1], (int)1);
        if (stack != null && stack.func_77973_b() != null) {
            stack.func_77964_b(meta);
        }
        return stack;
    }

    public static BlockWithMeta getBlock(String input) {
        String[] data = input.split(":");
        if (data.length <= 1) {
            return null;
        }
        int meta = data.length == 3 ? Integer.parseInt(data[2]) : -1;
        Block block = GameRegistry.findBlock((String)data[0], (String)data[1]);
        if (block == null) {
            return null;
        }
        return meta < 0 ? new BlockWithMeta(block) : new BlockWithMeta(block, meta);
    }
}

