/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class WeightedRandom<T> {
    private int totalWeight = 0;
    private HashMap<T, Integer> entries = new HashMap();

    public void addEntry(T entry, int weight) {
        this.entries.put(entry, weight);
        this.totalWeight += weight;
    }

    public void removeEntry(T entry) {
        Iterator<Map.Entry<T, Integer>> iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Integer> mapEntry = iterator.next();
            if (!mapEntry.getKey().equals(entry)) continue;
            this.totalWeight -= mapEntry.getValue().intValue();
            iterator.remove();
        }
    }

    public T getRandomEntry(Random rand) {
        T result = null;
        Set<Map.Entry<T, Integer>> entries = this.entries.entrySet();
        double threshold = rand.nextDouble() * (double)this.totalWeight;
        for (Map.Entry<T, Integer> mapEntry : entries) {
            if (!((threshold -= (double)mapEntry.getValue().intValue()) <= 0.0)) continue;
            result = mapEntry.getKey();
            break;
        }
        return result;
    }

    public int getWeight(T entry) {
        for (Map.Entry<T, Integer> mapEntry : this.entries.entrySet()) {
            if (!entry.equals(mapEntry.getKey())) continue;
            return mapEntry.getValue();
        }
        return 0;
    }
}

