package aln.deathquotes;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.event.entity.living.LivingSpawnEvent.CheckSpawn;
import net.minecraftforge.event.world.BlockEvent.BreakEvent;
import net.minecraftforge.event.world.BlockEvent.PlaceEvent;
import net.minecraftforge.event.world.ExplosionEvent.Detonate;
import net.minecraftforge.event.world.ExplosionEvent.Start;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;

public class ForgeHooks {
  
  @SubscribeEvent
  public void LivingDeathEvent(net.minecraftforge.event.entity.living.LivingDeathEvent event) {
    if ( event.entity.worldObj.isRemote ) { return; } // server side only
    if (!(event.entity instanceof EntityPlayer)) { return; } // for players only
    EntityPlayer player = (EntityPlayer) event.entity;
    Random randomGenerator = new Random();
    if ( DeathQuotes.quotes.length == 0 ) { return; } // no quotes in array
    int tryCount = 0;
    int n = 0;
    boolean foundOne = false;
    while (! foundOne ) {
    	tryCount++; if ( tryCount > 10 ) { return; } // prevent infinite loop when only blank lines found
      n = randomGenerator.nextInt(DeathQuotes.quotes.length);
      if (! DeathQuotes.quotes[n].trim().equals("")) { foundOne = true; } 
      else { Do.Err("Death quotes file "+DeathQuotes.quotesPathAndFileName+" contains blank lines and it should not."); }
    }
    Do.SayToAll(player,"\""+DeathQuotes.quotes[n]+"\"");
    return;
  }
  
}
