/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.entity.accessor.EnergyTugDataAccessor;
import dev.murad.shipping.entity.container.EnergyTugContainer;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyTugEntity
extends AbstractTugEntity {
    private static final int MAX_ENERGY = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_CAPACITY.get();
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_MAX_CHARGE_RATE.get();
    private static final int ENERGY_USAGE = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_ENERGY_USAGE.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_ENERGY, MAX_TRANSFER, Integer.MAX_VALUE);
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.internalBattery);

    public EnergyTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.internalBattery.setEnergy(0);
    }

    public EnergyTugEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.ENERGY_TUG.get(), worldIn, x, y, z);
        this.internalBattery.setEnergy(0);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.ENERGY_TUG.get();
    }

    @Override
    protected int getNonRouteItemSlots() {
        return 1;
    }

    @Override
    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 1 && stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @Override
    protected int getTugSlotLimit(int slot) {
        return 1;
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("screen.littlelogistics.energy_tug");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
                return new EnergyTugContainer(i, EnergyTugEntity.this.f_19853_, EnergyTugEntity.this.getDataAccessor(), playerInventory, Player2);
            }
        };
    }

    @Override
    protected void makeSmoke() {
    }

    @Override
    public boolean allowDockInterface() {
        return true;
    }

    @Override
    public EnergyTugDataAccessor getDataAccessor() {
        return new EnergyTugDataAccessor.Builder(this.m_142049_()).withEnergy(this.internalBattery::getEnergyStored).withCapacity(this.internalBattery::getMaxEnergyStored).withLit(() -> this.internalBattery.getEnergyStored() > 0).build();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.internalBattery.readAdditionalSaveData(compound.m_128469_("energy_storage"));
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        CompoundTag energyNBT = new CompoundTag();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        compound.m_128365_("energy_storage", (Tag)energyNBT);
        super.m_7380_(compound);
    }

    @Nullable
    private IEnergyStorage getEnergyCapabilityInSlot(int slot) {
        Optional capabilityOpt;
        LazyOptional capabilityLazyOpt;
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (!stack.m_41619_() && (capabilityLazyOpt = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent() && (capabilityOpt = capabilityLazyOpt.resolve()).isPresent()) {
            return (IEnergyStorage)capabilityOpt.get();
        }
        return null;
    }

    @Override
    public void m_8119_() {
        IEnergyStorage capability;
        if (!this.f_19853_.f_46443_ && (capability = this.getEnergyCapabilityInSlot(1)) != null) {
            int toExtract = capability.extractEnergy(MAX_TRANSFER, true);
            toExtract = this.internalBattery.receiveEnergy(toExtract, false);
            capability.extractEnergy(toExtract, false);
        }
        super.m_8119_();
    }

    @Override
    protected boolean tickFuel() {
        return this.internalBattery.extractEnergy(ENERGY_USAGE, false) > 0;
    }

    public boolean m_7983_() {
        return false;
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(1, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(1, p_70299_2_, false);
        if (!p_70299_2_.m_41619_() && p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

