/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.recipe;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModRecipeSerializers;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteRecipe
extends CustomRecipe {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteRecipe.class);

    public TugRouteRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    private boolean isTugRouteWithTag(ItemStack stack, boolean hasTag) {
        if (stack.m_41720_() == ModItems.TUG_ROUTE.get()) {
            return stack.m_41783_() == null ^ hasTag;
        }
        return false;
    }

    private Optional<Pair<ItemStack, Integer>> checkTugRoutes(CraftingContainer inventory) {
        int i = 0;
        ItemStack filledRoute = ItemStack.f_41583_;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack stack = inventory.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (this.isTugRouteWithTag(stack, true)) {
                if (!filledRoute.m_41619_()) {
                    return Optional.empty();
                }
                filledRoute = stack;
                continue;
            }
            if (!this.isTugRouteWithTag(stack, false)) {
                return Optional.empty();
            }
            ++i;
        }
        if (!filledRoute.m_41619_() && i >= 1 && i <= filledRoute.m_41741_() - 1) {
            return Optional.of(new Pair((Object)filledRoute, (Object)i));
        }
        return Optional.empty();
    }

    public boolean matches(@Nonnull CraftingContainer inventory, @Nonnull Level level) {
        return this.checkTugRoutes(inventory).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inventory) {
        Optional<Pair<ItemStack, Integer>> matchOpt = this.checkTugRoutes(inventory);
        if (!matchOpt.isPresent()) {
            return ItemStack.f_41583_;
        }
        Pair<ItemStack, Integer> match = matchOpt.get();
        ItemStack filled = (ItemStack)match.getFirst();
        int num = (Integer)match.getSecond();
        ItemStack output = filled.m_41777_();
        output.m_41764_(num + 1);
        return output;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.TUG_ROUTE_COPY.get();
    }
}

