/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.belt;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class UniversalAttractorItem
extends CurioItem {
    public UniversalAttractorItem() {
        this.addListener(PlayerEvent.ItemPickupEvent.class, this::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(this::onItemToss);
    }

    private void onItemPickup(PlayerEvent.ItemPickupEvent event, LivingEntity wearer) {
        this.damageEquippedStacks(wearer);
    }

    public static int getCooldown(ItemStack stack) {
        return stack.m_41784_().m_128451_("Cooldown");
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        stack.m_41784_().m_128405_("Cooldown", cooldown);
    }

    private void onItemToss(ItemTossEvent event) {
        int cooldown = (Integer)ModConfig.server.universalAttractor.cooldown.get();
        if (cooldown > 0) {
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, (LivingEntity)event.getPlayer()).ifPresent(triple -> UniversalAttractorItem.setCooldown((ItemStack)triple.right, cooldown));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (ModConfig.server.isCosmetic(this) || slotContext.entity().m_5833_() || !(slotContext.entity() instanceof Player)) {
            return;
        }
        int cooldown = UniversalAttractorItem.getCooldown(stack);
        if (cooldown <= 0) {
            Vec3 playerPos = slotContext.entity().m_20182_().m_82520_(0.0, 0.75, 0.0);
            int range = (Integer)ModConfig.server.universalAttractor.range.get();
            List items = slotContext.entity().f_19853_.m_45976_(ItemEntity.class, new AABB(playerPos.f_82479_ - (double)range, playerPos.f_82480_ - (double)range, playerPos.f_82481_ - (double)range, playerPos.f_82479_ + (double)range, playerPos.f_82480_ + (double)range, playerPos.f_82481_ + (double)range));
            int pulled = 0;
            for (ItemEntity item : items) {
                if (!item.m_6084_() || item.m_32063_() || item.getPersistentData().m_128471_("PreventRemoteMovement")) continue;
                if (pulled++ <= 200) {
                    Vec3 motion = playerPos.m_82546_(item.m_20182_().m_82520_(0.0, (double)(item.m_20206_() / 2.0f), 0.0));
                    if (Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_) > 1.0) {
                        motion = motion.m_82541_();
                    }
                    item.m_20256_(motion.m_82490_(((Double)ModConfig.server.universalAttractor.motionMultiplier.get()).doubleValue()));
                    continue;
                }
                break;
            }
        } else {
            UniversalAttractorItem.setCooldown(stack, cooldown - 1);
        }
    }
}

