/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.loot;

import artifacts.common.config.ModConfig;
import artifacts.common.init.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record ConfigurableRandomChance(float defaultProbability) implements LootItemCondition
{
    public LootItemConditionType m_7940_() {
        return ModLootConditions.CONFIGURABLE_ARTIFACT_CHANCE;
    }

    public boolean test(LootContext context) {
        if ((Double)ModConfig.common.artifactRarity.get() >= 9999.0) {
            return false;
        }
        float c = (float)((Double)ModConfig.common.artifactRarity.get()).doubleValue();
        float p = this.defaultProbability;
        return context.m_78933_().nextFloat() < p / (p + c - c * p);
    }

    public static LootItemCondition.Builder configurableRandomChance(float probability) {
        return () -> new ConfigurableRandomChance(probability);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ConfigurableRandomChance> {
        public void serialize(JsonObject object, ConfigurableRandomChance condition, JsonSerializationContext context) {
            object.addProperty("default_probability", (Number)Float.valueOf(condition.defaultProbability));
        }

        public ConfigurableRandomChance deserialize(JsonObject object, JsonDeserializationContext context) {
            return new ConfigurableRandomChance(GsonHelper.m_13915_((JsonObject)object, (String)"default_probability"));
        }
    }
}

