/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.mixin;

import alternate.current.AlternateCurrentMod;
import alternate.current.interfaces.mixin.IServerLevel;
import alternate.current.redstone.LevelAccess;
import alternate.current.redstone.Node;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RedStoneWireBlock.class})
public class RedStoneWireBlockMixin
implements WireBlock {
    @Inject(method={"updatePowerStrength"}, cancellable=true, at={@At(value="HEAD")})
    private void onUpdate(Level level, BlockPos pos, BlockState state, CallbackInfo ci) {
        if (AlternateCurrentMod.on) {
            ci.cancel();
        }
    }

    @Inject(method={"onPlace"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void onBlockAdded(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moved, CallbackInfo ci) {
        if (AlternateCurrentMod.on) {
            ((IServerLevel)level).getAccess(this).getWireHandler().onWireAdded(pos);
            BlockState newState = level.m_8055_(pos);
            if (newState != state) {
                newState.m_60701_((LevelAccessor)level, pos, 2);
                newState.m_60758_((LevelAccessor)level, pos, 2);
            }
        }
    }

    @Inject(method={"onRemove"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void onBlockRemoved(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved, CallbackInfo ci) {
        if (AlternateCurrentMod.on) {
            ((IServerLevel)level).getAccess(this).getWireHandler().onWireRemoved(pos);
        }
    }

    @Inject(method={"neighborChanged"}, cancellable=true, at={@At(value="HEAD")})
    private void onNeighborUpdate(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify, CallbackInfo ci) {
        if (AlternateCurrentMod.on) {
            if (!level.m_5776_()) {
                ((IServerLevel)level).getAccess(this).getWireHandler().onWireUpdated(pos);
            }
            ci.cancel();
        }
    }

    @Override
    public Block asBlock() {
        return (Block)this;
    }

    @Override
    public boolean isOf(BlockState state) {
        return this.asBlock() == state.m_60734_();
    }

    @Override
    public int getMinPower() {
        return 0;
    }

    @Override
    public int getMaxPower() {
        return 15;
    }

    @Override
    public int getPowerStep() {
        return 1;
    }

    @Override
    public int getPower(LevelAccess level, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_);
    }

    @Override
    public BlockState updatePowerState(LevelAccess level, BlockPos pos, BlockState state, int power) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(power));
    }

    @Override
    public void findWireConnections(WireNode wire, WireHandler.NodeProvider nodes) {
        boolean belowIsConductor = nodes.getNeighbor(wire, 4).isConductor();
        boolean aboveIsConductor = nodes.getNeighbor(wire, 5).isConductor();
        wire.connections.set((connections, iDir) -> {
            Node node;
            Node neighbor = nodes.getNeighbor(wire, (int)iDir);
            if (neighbor.isWire()) {
                connections.add(neighbor.asWire(), (int)iDir, true, true);
                return;
            }
            boolean sideIsConductor = neighbor.isConductor();
            if (!sideIsConductor && (node = nodes.getNeighbor(neighbor, 4)).isWire()) {
                connections.add(node.asWire(), (int)iDir, true, belowIsConductor);
            }
            if (!aboveIsConductor && (node = nodes.getNeighbor(neighbor, 5)).isWire()) {
                connections.add(node.asWire(), (int)iDir, sideIsConductor, true);
            }
        });
    }
}

