/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.interfaces.mixin.IBlock;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class LevelAccess {
    private final WireBlock wireBlock;
    private final ServerLevel level;
    private final WireHandler wireHandler;

    public LevelAccess(WireBlock wireBlock, ServerLevel level) {
        this.wireBlock = wireBlock;
        this.level = level;
        this.wireHandler = new WireHandler(this.wireBlock, this);
    }

    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    public BlockState getBlockState(BlockPos pos) {
        int y = pos.m_123342_();
        if (y < this.level.m_141937_() || y >= this.level.m_151558_()) {
            return Blocks.f_50626_.m_49966_();
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int index = this.level.m_151564_(y);
        ChunkAccess chunk = this.level.m_6522_(x >> 4, z >> 4, ChunkStatus.f_62326_, true);
        LevelChunkSection section = chunk.m_7103_()[index];
        if (section == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean setWireState(BlockPos pos, BlockState state) {
        if (!this.wireBlock.isOf(state)) {
            return false;
        }
        int y = pos.m_123342_();
        if (y < this.level.m_141937_() || y >= this.level.m_151558_()) {
            return false;
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int index = this.level.m_151564_(y);
        ChunkAccess chunk = this.level.m_6522_(x >> 4, z >> 4, ChunkStatus.f_62326_, true);
        LevelChunkSection section = chunk.m_7103_()[index];
        if (section == null) {
            return false;
        }
        BlockState prevState = section.m_62986_(x & 0xF, y & 0xF, z & 0xF, state);
        if (state == prevState) {
            return false;
        }
        this.level.m_7726_().m_8450_(pos);
        chunk.m_8092_(true);
        return true;
    }

    public boolean breakBlock(BlockPos pos, BlockState state) {
        Block.m_49950_((BlockState)state, (Level)this.level, (BlockPos)pos);
        return this.level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public void updateNeighborShape(BlockPos pos, BlockState state, Direction fromDir, BlockPos fromPos, BlockState fromState) {
        BlockState newState = state.m_60728_(fromDir, fromState, (LevelAccessor)this.level, pos, fromPos);
        Block.m_49902_((BlockState)state, (BlockState)newState, (LevelAccessor)this.level, (BlockPos)pos, (int)2);
    }

    public void updateNeighborBlock(BlockPos pos, BlockPos fromPos, Block fromBlock) {
        this.getBlockState(pos).m_60690_((Level)this.level, pos, fromBlock, fromPos, false);
    }

    public void updateNeighborBlock(BlockPos pos, BlockState state, BlockPos fromPos, Block fromBlock) {
        state.m_60690_((Level)this.level, pos, fromBlock, fromPos, false);
    }

    public boolean isConductor(BlockPos pos) {
        return this.getBlockState(pos).m_60796_((BlockGetter)this.level, pos);
    }

    public boolean isConductor(BlockPos pos, BlockState state) {
        return state.m_60796_((BlockGetter)this.level, pos);
    }

    public boolean emitsWeakPowerTo(BlockPos pos, BlockState state, Direction dir) {
        return ((IBlock)state.m_60734_()).emitsSignalTo((Level)this.level, pos, state, dir);
    }

    public boolean emitsStrongPowerTo(BlockPos pos, BlockState state, Direction dir) {
        return ((IBlock)state.m_60734_()).emitsDirectSignalTo((Level)this.level, pos, state, dir);
    }

    public int getWeakPowerFrom(BlockPos pos, BlockState state, Direction dir) {
        return state.m_60746_((BlockGetter)this.level, pos, dir);
    }

    public int getStrongPowerFrom(BlockPos pos, BlockState state, Direction dir) {
        return state.m_60775_((BlockGetter)this.level, pos, dir);
    }

    public boolean shouldBreak(BlockPos pos, BlockState state) {
        return !state.m_60710_((LevelReader)this.level, pos);
    }
}

