/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.LevelAccess;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class Node {
    private static final int CONDUCTOR = 1;
    private static final int REDSTONE = 2;
    public final WireBlock wireBlock;
    public final LevelAccess level;
    public final Node[] neighbors;
    public BlockPos pos;
    public BlockState state;
    public boolean invalid;
    private int flags;

    public Node(WireBlock wireBlock, LevelAccess level) {
        this.wireBlock = wireBlock;
        this.level = level;
        this.neighbors = new Node[WireHandler.Directions.ALL.length];
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            return this.level == node.level && this.pos.equals((Object)node.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public Node update(BlockPos pos, BlockState state, boolean clearNeighbors) {
        if (this.wireBlock.isOf(state)) {
            throw new IllegalStateException("Cannot update a regular Node to a WireNode!");
        }
        if (clearNeighbors) {
            Arrays.fill(this.neighbors, null);
        }
        this.pos = pos.m_7949_();
        this.state = state;
        this.invalid = false;
        this.flags = 0;
        if (this.level.isConductor(this.pos, this.state)) {
            this.flags |= 1;
        }
        if (this.state.m_60803_()) {
            this.flags |= 2;
        }
        return this;
    }

    public boolean isOf(WireBlock wireBlock) {
        return this.wireBlock == wireBlock;
    }

    public boolean isWire() {
        return false;
    }

    public boolean isConductor() {
        return (this.flags & 1) != 0;
    }

    public boolean isRedstoneComponent() {
        return (this.flags & 2) != 0;
    }

    public WireNode asWire() {
        throw new UnsupportedOperationException("Not a WireNode!");
    }
}

