/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.WireConnection;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class WireConnectionManager {
    private static final int BITS = 4;
    private static final int MASK = 15;
    public final WireNode wire;
    public WireConnection[] all;
    public int count;
    private int indices;
    private int flowTotal;
    public int flow;

    public WireConnectionManager(WireNode wire) {
        this.wire = wire;
        this.all = new WireConnection[WireHandler.Directions.HORIZONTAL.length];
        this.count = 0;
        this.indices = 0;
        this.flowTotal = 0;
        this.flow = -1;
    }

    public void set(BiConsumer<ConnectionConsumer, Integer> setter) {
        if (this.count > 0) {
            this.clear();
        }
        for (int iDir = 0; iDir < WireHandler.Directions.HORIZONTAL.length; ++iDir) {
            this.setIndex(iDir, this.count);
            setter.accept(this::add, iDir);
        }
        this.setIndex(WireHandler.Directions.HORIZONTAL.length, this.count);
    }

    private void clear() {
        Arrays.fill(this.all, null);
        this.count = 0;
        this.indices = 0;
        this.flowTotal = 0;
        this.flow = -1;
    }

    private void add(WireNode wire, int iDir, boolean in, boolean out) {
        this.addConnection(new WireConnection(wire, iDir, in, out));
    }

    private void addConnection(WireConnection connection) {
        if (this.count == this.all.length) {
            this.all = WireConnectionManager.doubleSize(this.all);
        }
        this.all[this.count++] = connection;
        this.flowTotal |= 1 << connection.iDir;
        this.flow = WireHandler.FLOW_IN_TO_FLOW_OUT[this.flowTotal];
    }

    public int start(int iDir) {
        return this.getIndex(iDir);
    }

    public int end(int iDir) {
        return this.getIndex(iDir + 1);
    }

    private void setIndex(int i, int index) {
        this.indices |= (index & 0xF) << i * 4;
    }

    private int getIndex(int i) {
        return this.indices >> i * 4 & 0xF;
    }

    private static WireConnection[] doubleSize(WireConnection[] array) {
        WireConnection[] newArray = new WireConnection[array.length << 1];
        for (int index = 0; index < array.length; ++index) {
            newArray[index] = array[index];
        }
        return newArray;
    }

    @FunctionalInterface
    public static interface ConnectionConsumer {
        public void add(WireNode var1, int var2, boolean var3, boolean var4);
    }
}

