/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.LevelAccess;
import alternate.current.redstone.Node;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireConnectionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class WireNode
extends Node {
    public final WireConnectionManager connections;
    public int currentPower;
    public int virtualPower;
    public int externalPower;
    public int flowIn;
    public int flowOut;
    public boolean removed;
    public boolean shouldBreak;
    public boolean prepared;
    public boolean inNetwork;

    public WireNode(WireBlock wireBlock, LevelAccess level, BlockPos pos, BlockState state) {
        super(wireBlock, level);
        this.pos = pos.m_7949_();
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.wireBlock.getPower(this.level, this.pos, this.state);
    }

    @Override
    public Node update(BlockPos pos, BlockState state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    public int nextPower() {
        return this.wireBlock.clampPower(this.virtualPower);
    }

    public boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    public boolean updateState() {
        if (this.removed) {
            return true;
        }
        this.state = this.level.getBlockState(this.pos);
        if (this.shouldBreak) {
            return this.level.breakBlock(this.pos, this.state);
        }
        this.currentPower = this.wireBlock.clampPower(this.virtualPower);
        this.state = this.wireBlock.updatePowerState(this.level, this.pos, this.state, this.currentPower);
        return this.level.setWireState(this.pos, this.state);
    }
}

