/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.ObjectArrays;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.BakedQuadRetextured;
import team.chisel.ctm.client.util.CTMPackReloadListener;

@ParametersAreNonnullByDefault
public class ModelBakedCTM
extends AbstractCTMBakedModel {
    private static final Direction[] FACINGS = (Direction[])ObjectArrays.concat((Object[])Direction.values(), (Object)null);

    public ModelBakedCTM(IModelCTM model, BakedModel parent) {
        super(model, parent);
    }

    @Override
    protected AbstractCTMBakedModel createModel(@Nullable BlockState state, IModelCTM model, BakedModel parent, @Nullable RenderContextList ctx, Random rand) {
        while (parent instanceof ModelBakedCTM) {
            ModelBakedCTM castParent = (ModelBakedCTM)parent;
            parent = castParent.getParent(rand);
        }
        ModelBakedCTM ret = new ModelBakedCTM(model, parent);
        for (RenderType layer : LAYERS) {
            for (Direction facing : FACINGS) {
                ArrayList<BakedQuad> quads;
                List parentQuads = parent.m_6840_(state, facing, rand);
                if (facing != null) {
                    quads = new ArrayList<BakedQuad>();
                    ret.faceQuads.put((Object)layer, (Object)facing, quads);
                } else {
                    quads = ret.genQuads.get((Object)layer);
                }
                LinkedHashMap texturemap = new LinkedHashMap();
                for (BakedQuad q : parentQuads) {
                    ICTMTexture<?> tex2 = this.getOverrideTexture(rand, q.m_111305_(), q.m_173410_().m_118413_());
                    if (tex2 == null) {
                        tex2 = this.getTexture(rand, q.m_173410_().m_118413_());
                    }
                    if (tex2 == null) continue;
                    TextureAtlasSprite spriteReplacement = this.getOverrideSprite(rand, q.m_111305_());
                    if (spriteReplacement != null) {
                        q = new BakedQuadRetextured(q, spriteReplacement);
                    }
                    texturemap.put(q, tex2);
                }
                int quadGoal = ctx == null ? 1 : texturemap.values().stream().mapToInt(tex -> tex.getType().getQuadsPerSide()).max().orElse(1);
                for (Map.Entry e : texturemap.entrySet()) {
                    if ((((ICTMTexture)e.getValue()).getLayer() == null || ((ICTMTexture)e.getValue()).getLayer().getRenderType() != layer) && (((ICTMTexture)e.getValue()).getLayer() != null || state != null && !CTMPackReloadListener.canRenderInLayerFallback(state, layer))) continue;
                    ITextureContext tcx = ctx == null ? null : ctx.getRenderContext((ICTMTexture)e.getValue());
                    quads.addAll(((ICTMTexture)e.getValue()).transformQuad((BakedQuad)e.getKey(), tcx, quadGoal));
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return Optional.ofNullable(this.getModel().getTexture(this.getParent().getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_())).map(ICTMTexture::getParticle).orElse(this.getParent().getParticleIcon((IModelData)EmptyModelData.INSTANCE));
    }

    @Override
    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        this.getParent().handlePerspective(cameraTransformType, poseStack);
        return this;
    }
}

