/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.texture.render.TextureCTM;
import team.chisel.ctm.client.util.CTMLogic;

public class TextureContextCTM
implements ITextureContext {
    protected final TextureCTM<?> tex;
    private EnumMap<Direction, CTMLogic> ctmData = new EnumMap(Direction.class);
    private long data;

    public TextureContextCTM(@Nonnull BlockState state, BlockGetter world, BlockPos pos, TextureCTM<?> tex) {
        this.tex = tex;
        for (Direction face : Direction.values()) {
            CTMLogic ctm = this.createCTM(state);
            ctm.createSubmapIndices(world, pos, face);
            this.ctmData.put(face, ctm);
            this.data |= ctm.serialized() << face.ordinal() * 10;
        }
    }

    protected CTMLogic createCTM(@Nonnull BlockState state) {
        CTMLogic ret = CTMLogic.getInstance().ignoreStates(this.tex.ignoreStates()).stateComparator(this.tex::connectTo);
        ret.disableObscuredFaceCheck = this.tex.connectInside();
        return ret;
    }

    public CTMLogic getCTM(Direction face) {
        return this.ctmData.get(face);
    }

    @Override
    public long getCompressedData() {
        return this.data;
    }
}

