/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockstatePredicateParser {
    static final Type MAP_TYPE = new TypeToken<EnumMap<Direction, Predicate<BlockState>>>(){}.getType();
    static final Type PREDICATE_TYPE = new TypeToken<Predicate<BlockState>>(){}.getType();
    final PredicateDeserializer predicateDeserializer = new PredicateDeserializer();
    private final Gson GSON = new GsonBuilder().registerTypeAdapter(PREDICATE_TYPE, (Object)this.predicateDeserializer).registerTypeAdapter(ComparisonType.class, (Object)new ComparisonType.Deserializer()).registerTypeAdapter(MAP_TYPE, type -> new EnumMap(Direction.class)).registerTypeAdapter(PredicateMap.class, (Object)new MapDeserializer()).create();

    @Nullable
    public BiPredicate<Direction, BlockState> parse(JsonElement json) {
        return (BiPredicate)this.GSON.fromJson(json, PredicateMap.class);
    }

    class PredicateDeserializer
    implements JsonDeserializer<Predicate<BlockState>> {
        private static final Predicate<BlockState> EMPTY = p -> false;
        ThreadLocal<Predicate<BlockState>> defaultPredicate = new ThreadLocal();

        PredicateDeserializer() {
        }

        public Predicate<BlockState> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"block")));
                if (block == Blocks.f_50016_) {
                    return EMPTY;
                }
                Composition composition = null;
                if (obj.has("defer")) {
                    if (this.defaultPredicate.get() == null) {
                        throw new JsonParseException("Cannot defer when no default is set!");
                    }
                    try {
                        composition = Composition.valueOf(GsonHelper.m_13906_((JsonObject)obj, (String)"defer").toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException(GsonHelper.m_13906_((JsonObject)obj, (String)"defer") + " is not a valid defer type.");
                    }
                }
                if (!obj.has("predicate")) {
                    return this.compose(composition, new BlockPredicate(block));
                }
                JsonElement propsEle = obj.get("predicate");
                if (propsEle.isJsonObject()) {
                    return this.compose(composition, this.parsePredicate(block, propsEle.getAsJsonObject(), context));
                }
                if (propsEle.isJsonArray()) {
                    ArrayList<Predicate<BlockState>> predicates = new ArrayList<Predicate<BlockState>>();
                    for (JsonElement ele : propsEle.getAsJsonArray()) {
                        if (ele.isJsonObject()) {
                            predicates.add(this.parsePredicate(block, ele.getAsJsonObject(), context));
                            continue;
                        }
                        throw new JsonSyntaxException("Predicate entry must be a JSON Object. Found: " + ele);
                    }
                    return this.compose(composition, new PredicateComposition(Composition.AND, predicates));
                }
            } else if (json.isJsonArray()) {
                ArrayList<Predicate<BlockState>> predicates = new ArrayList<Predicate<BlockState>>();
                for (JsonElement ele : json.getAsJsonArray()) {
                    Predicate p = (Predicate)context.deserialize(ele, PREDICATE_TYPE);
                    if (p == EMPTY) continue;
                    predicates.add(p);
                }
                return predicates.isEmpty() ? EMPTY : (predicates.size() == 1 ? (Predicate)predicates.get(0) : new PredicateComposition(Composition.OR, predicates));
            }
            throw new JsonSyntaxException("Predicate deserialization expects an object or an array. Found: " + json);
        }

        private Predicate<BlockState> compose(@Nullable Composition composition, @Nonnull Predicate<BlockState> child) {
            if (composition == null) {
                return child;
            }
            return composition.composer.apply(this.defaultPredicate.get(), child);
        }

        private Predicate<BlockState> parsePredicate(@Nonnull Block block, JsonObject obj, JsonDeserializationContext context) {
            ComparisonType compareFunc = (ComparisonType)((Object)GsonHelper.m_13845_((JsonObject)obj, (String)"compare_func", (Object)((Object)ComparisonType.EQUAL), (JsonDeserializationContext)context, ComparisonType.class));
            obj.remove("compare_func");
            Set entryset = obj.entrySet();
            if (obj.size() != 1) {
                throw new JsonSyntaxException("Predicate entry must define exactly one property->value pair. Found: " + entryset.size());
            }
            String key = (String)((Map.Entry)entryset.iterator().next()).getKey();
            Optional<Property> prop = Optional.ofNullable(block.m_49965_().m_61081_(key));
            if (prop.isEmpty()) {
                throw new JsonParseException(key + " is not a valid property for blockstate " + block.m_49966_());
            }
            JsonElement valueEle = obj.get(key);
            if (valueEle.isJsonArray()) {
                return new MultiPropertyPredicate(block, prop.get(), StreamSupport.stream(valueEle.getAsJsonArray().spliterator(), false).map(e -> this.parseValue((Property)prop.get(), (JsonElement)e)).collect(Collectors.toSet()));
            }
            return new PropertyPredicate(BlockstatePredicateParser.this, block, prop.get(), this.parseValue(prop.get(), valueEle), compareFunc);
        }

        private Comparable parseValue(Property prop, JsonElement ele) {
            String valstr = GsonHelper.m_13805_((JsonElement)ele, (String)prop.m_61708_());
            Optional<Object> value = prop.m_6908_().stream().filter(v -> prop.m_6940_((Comparable)v).equalsIgnoreCase(valstr)).findFirst();
            if (value.isEmpty()) {
                throw new JsonParseException(valstr + " is not a valid value for property " + prop);
            }
            return (Comparable)value.get();
        }
    }

    static enum ComparisonType {
        EQUAL("=", i -> i == 0),
        NOT_EQUAL("!=", i -> i != 0),
        GREATER_THAN(">", i -> i > 0),
        LESS_THAN("<", i -> i < 0),
        GREATER_THAN_EQ(">=", i -> i >= 0),
        LESS_THAN_EQ("<=", i -> i <= 0);

        private final String key;
        private final IntPredicate compareFunc;

        private ComparisonType(String key, IntPredicate compareFunc) {
            this.key = key;
            this.compareFunc = compareFunc;
        }

        static class Deserializer
        implements JsonDeserializer<ComparisonType> {
            Deserializer() {
            }

            public ComparisonType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                    Optional<ComparisonType> type = Arrays.stream(ComparisonType.values()).filter(t -> t.key.equals(json.getAsString())).findFirst();
                    if (type.isPresent()) {
                        return type.get();
                    }
                    throw new JsonParseException(json + " is not a valid comparison type!");
                }
                throw new JsonSyntaxException("ComparisonType must be a String");
            }
        }
    }

    class PredicateMap
    implements BiPredicate<Direction, BlockState> {
        private final EnumMap<Direction, Predicate<BlockState>> predicates = new EnumMap(Direction.class);

        @Override
        public boolean test(Direction dir, BlockState state) {
            return this.predicates.get(dir).test(state);
        }
    }

    class MapDeserializer
    implements JsonDeserializer<PredicateMap> {
        MapDeserializer() {
        }

        public PredicateMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("default")) {
                    BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.set((Predicate)context.deserialize(obj.get("default"), PREDICATE_TYPE));
                    obj.remove("default");
                }
                PredicateMap ret = new PredicateMap();
                ret.predicates.putAll((Map)context.deserialize((JsonElement)obj, MAP_TYPE));
                for (Direction dir : Direction.values()) {
                    PredicateDeserializer cfr_ignored_0 = BlockstatePredicateParser.this.predicateDeserializer;
                    ret.predicates.putIfAbsent(dir, Optional.ofNullable(BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.get()).orElse(PredicateDeserializer.EMPTY));
                }
                BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.remove();
                return ret;
            }
            if (json.isJsonArray()) {
                Predicate predicate = (Predicate)context.deserialize(json, PREDICATE_TYPE);
                PredicateMap ret = new PredicateMap();
                for (Direction dir : Direction.values()) {
                    ret.predicates.put(dir, predicate);
                }
                return ret;
            }
            throw new JsonSyntaxException("connectTo must be an object or an array. Found: " + json);
        }
    }

    class PredicateComposition
    implements Predicate<BlockState> {
        private final Composition type;
        private final List<Predicate<BlockState>> composed;

        @Override
        public boolean test(BlockState t) {
            if (this.type == Composition.AND) {
                for (Predicate<BlockState> p : this.composed) {
                    if (p.test(t)) continue;
                    return false;
                }
                return true;
            }
            for (Predicate<BlockState> p : this.composed) {
                if (!p.test(t)) continue;
                return true;
            }
            return false;
        }

        public PredicateComposition(Composition type, List<Predicate<BlockState>> composed) {
            this.type = type;
            this.composed = composed;
        }

        public String toString() {
            return "BlockstatePredicateParser.PredicateComposition(type=" + this.type + ", composed=" + this.composed + ")";
        }
    }

    final class BlockPredicate
    implements Predicate<BlockState> {
        private final Block block;

        @Override
        public boolean test(BlockState t) {
            return t.m_60734_() == this.block;
        }

        public BlockPredicate(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockPredicate)) {
                return false;
            }
            BlockPredicate other = (BlockPredicate)o;
            Block this$block = this.getBlock();
            Block other$block = other.getBlock();
            return !(this$block == null ? other$block != null : !this$block.equals(other$block));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Block $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            return result;
        }

        public String toString() {
            return "BlockstatePredicateParser.BlockPredicate(block=" + this.getBlock() + ")";
        }
    }

    static final class MultiPropertyPredicate<T extends Comparable<T>>
    implements Predicate<BlockState> {
        private final Block block;
        private final Property<T> prop;
        private final Set<T> validValues;

        @Override
        public boolean test(BlockState t) {
            return t.m_60734_() == this.block && this.validValues.contains(t.m_61143_(this.prop));
        }

        public MultiPropertyPredicate(Block block, Property<T> prop, Set<T> validValues) {
            this.block = block;
            this.prop = prop;
            this.validValues = validValues;
        }

        public Block getBlock() {
            return this.block;
        }

        public Property<T> getProp() {
            return this.prop;
        }

        public Set<T> getValidValues() {
            return this.validValues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiPropertyPredicate)) {
                return false;
            }
            MultiPropertyPredicate other = (MultiPropertyPredicate)o;
            Block this$block = this.getBlock();
            Block other$block = other.getBlock();
            if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
                return false;
            }
            Property<T> this$prop = this.getProp();
            Property<T> other$prop = other.getProp();
            if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
                return false;
            }
            Set<T> this$validValues = this.getValidValues();
            Set<T> other$validValues = other.getValidValues();
            return !(this$validValues == null ? other$validValues != null : !((Object)this$validValues).equals(other$validValues));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Block $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            Property<T> $prop = this.getProp();
            result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
            Set<T> $validValues = this.getValidValues();
            result = result * 59 + ($validValues == null ? 43 : ((Object)$validValues).hashCode());
            return result;
        }

        public String toString() {
            return "BlockstatePredicateParser.MultiPropertyPredicate(block=" + this.getBlock() + ", prop=" + this.getProp() + ", validValues=" + this.getValidValues() + ")";
        }
    }

    static final class PropertyPredicate<T extends Comparable<T>>
    implements Predicate<BlockState> {
        private final Block block;
        private final Property<T> prop;
        private final T value;
        private final ComparisonType type;
        final /* synthetic */ BlockstatePredicateParser this$0;

        @Override
        public boolean test(BlockState t) {
            return t.m_60734_() == this.block && this.type.compareFunc.test(t.m_61143_(this.prop).compareTo(this.value));
        }

        public PropertyPredicate(Block block, Property<T> prop, T value, ComparisonType type) {
            this.this$0 = this$0;
            this.block = block;
            this.prop = prop;
            this.value = value;
            this.type = type;
        }

        public Block getBlock() {
            return this.block;
        }

        public Property<T> getProp() {
            return this.prop;
        }

        public T getValue() {
            return this.value;
        }

        public ComparisonType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyPredicate)) {
                return false;
            }
            PropertyPredicate other = (PropertyPredicate)o;
            Block this$block = this.getBlock();
            Block other$block = other.getBlock();
            if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
                return false;
            }
            Property<T> this$prop = this.getProp();
            Property<T> other$prop = other.getProp();
            if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            ComparisonType this$type = this.getType();
            ComparisonType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Block $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            Property<T> $prop = this.getProp();
            result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            ComparisonType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "BlockstatePredicateParser.PropertyPredicate(block=" + this.getBlock() + ", prop=" + this.getProp() + ", value=" + this.getValue() + ", type=" + this.getType() + ")";
        }
    }

    static enum Composition {
        AND(Predicate::and),
        OR(Predicate::or);

        private final BiFunction<Predicate<BlockState>, Predicate<BlockState>, Predicate<BlockState>> composer;

        private Composition(BiFunction<Predicate<BlockState>, Predicate<BlockState>, Predicate<BlockState>> composer) {
            this.composer = composer;
        }
    }
}

