/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

@ParametersAreNonnullByDefault
public class RegionCache
implements BlockGetter {
    private final BlockPos center;
    private final int radius;
    private WeakReference<BlockGetter> passthrough;
    private final Long2ObjectMap<BlockState> stateCache = new Long2ObjectOpenHashMap();

    public RegionCache(BlockPos center, int radius, @Nullable BlockGetter passthrough) {
        this.center = center;
        this.radius = radius;
        this.passthrough = new WeakReference<BlockGetter>(passthrough);
    }

    private BlockGetter getPassthrough() {
        BlockGetter ret = (BlockGetter)this.passthrough.get();
        Preconditions.checkNotNull((Object)ret);
        return ret;
    }

    @Nonnull
    public RegionCache updateWorld(BlockGetter passthrough) {
        if (this.passthrough.get() != passthrough) {
            this.stateCache.clear();
        }
        this.passthrough = new WeakReference<BlockGetter>(passthrough);
        return this;
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.getPassthrough().m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        long address = pos.m_121878_();
        return (BlockState)this.stateCache.computeIfAbsent(address, a -> this.getPassthrough().m_8055_(pos));
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.getPassthrough().m_6425_(pos);
    }

    public int m_141928_() {
        return this.getPassthrough().m_141928_();
    }

    public int m_141937_() {
        return this.getPassthrough().m_141937_();
    }
}

