/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.event;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.FoodValues;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.world.WildCropGeneration;

@Mod.EventBusSubscriber(modid="farmersdelight")
public class CommonEvents {
    private static final ResourceLocation SHIPWRECK_SUPPLY_CHEST = BuiltInLootTables.f_78694_;
    private static final Set<ResourceLocation> VILLAGE_HOUSE_CHESTS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78755_, BuiltInLootTables.f_78758_, BuiltInLootTables.f_78757_, BuiltInLootTables.f_78756_, BuiltInLootTables.f_78754_});

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (((Boolean)Configuration.CROPS_ON_SHIPWRECKS.get()).booleanValue() && event.getName().equals((Object)SHIPWRECK_SUPPLY_CHEST)) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("farmersdelight", "inject/shipwreck_supply")).m_79707_(1).m_79711_(0)).name("supply_fd_crops").m_79082_());
        }
        if (((Boolean)Configuration.CROPS_ON_VILLAGE_HOUSES.get()).booleanValue() && VILLAGE_HOUSE_CHESTS.contains(event.getName())) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("farmersdelight", "inject/crops_villager_houses")).m_79707_(1).m_79711_(0)).name("villager_houses_fd_crops").m_79082_());
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        Biome.ClimateSettings climate = event.getClimate();
        ResourceLocation biomeName = event.getName();
        if (biomeName != null && biomeName.m_135815_().equals("beach")) {
            if (((Boolean)Configuration.GENERATE_WILD_BEETROOTS.get()).booleanValue()) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_BEETROOTS);
            }
            if (((Boolean)Configuration.GENERATE_WILD_CABBAGES.get()).booleanValue()) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_CABBAGES);
            }
        }
        if ((event.getCategory().equals((Object)Biome.BiomeCategory.SWAMP) || event.getCategory().equals((Object)Biome.BiomeCategory.JUNGLE)) && ((Boolean)Configuration.GENERATE_WILD_RICE.get()).booleanValue()) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_RICE);
        }
        if (climate.f_47681_ >= 1.0f && ((Boolean)Configuration.GENERATE_WILD_TOMATOES.get()).booleanValue()) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_TOMATOES);
        }
        if (climate.f_47681_ > 0.3f && climate.f_47681_ < 1.0f) {
            if (((Boolean)Configuration.GENERATE_WILD_CARROTS.get()).booleanValue()) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_CARROTS);
            }
            if (((Boolean)Configuration.GENERATE_WILD_ONIONS.get()).booleanValue()) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_ONIONS);
            }
        }
        if (climate.f_47681_ > 0.0f && climate.f_47681_ <= 0.3f && ((Boolean)Configuration.GENERATE_WILD_POTATOES.get()).booleanValue()) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCropGeneration.PATCH_WILD_POTATOES);
        }
    }

    @SubscribeEvent
    public static void handleVanillaSoupEffects(LivingEntityUseItemEvent.Finish event) {
        FoodProperties soupEffects;
        Item food = event.getItem().m_41720_();
        LivingEntity entity = event.getEntityLiving();
        if (((Boolean)Configuration.RABBIT_STEW_JUMP_BOOST.get()).booleanValue() && food.equals(Items.f_42699_)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 200, 1));
        }
        if (((Boolean)Configuration.VANILLA_SOUP_EXTRA_EFFECTS.get()).booleanValue() && (soupEffects = FoodValues.VANILLA_SOUP_EFFECTS.get(food)) != null) {
            for (Pair pair : soupEffects.m_38749_()) {
                entity.m_7292_((MobEffectInstance)pair.getFirst());
            }
        }
    }

    @SubscribeEvent
    public static void onHoeUse(UseHoeEvent event) {
        UseOnContext context = event.getContext();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos);
        if (context.m_43719_() != Direction.DOWN && world.m_8055_(pos.m_7494_()).m_60795_() && state.m_60734_() == ModBlocks.RICH_SOIL.get()) {
            world.m_5594_(event.getPlayer(), pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, ((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).m_49966_(), 11);
            event.setResult(Event.Result.ALLOW);
        }
    }
}

