/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class HorseFeedItem
extends Item {
    public static final List<MobEffectInstance> EFFECTS = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19596_, 6000, 1), new MobEffectInstance(MobEffects.f_19603_, 6000, 0)});

    public HorseFeedItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        MutableComponent textWhenFeeding = TextUtils.getTranslation("tooltip.horse_feed.when_feeding", new Object[0]);
        tooltip.add((Component)textWhenFeeding.m_130940_(ChatFormatting.GRAY));
        for (MobEffectInstance effectInstance : EFFECTS) {
            TextComponent effectDescription = new TextComponent(" ");
            TranslatableComponent effectName = new TranslatableComponent(effectInstance.m_19576_());
            effectDescription.m_7220_((Component)effectName);
            MobEffect effect = effectInstance.m_19544_();
            if (effectInstance.m_19564_() > 0) {
                effectDescription.m_130946_(" ").m_7220_((Component)new TranslatableComponent("potion.potency." + effectInstance.m_19564_()));
            }
            if (effectInstance.m_19557_() > 20) {
                effectDescription.m_130946_(" (").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")");
            }
            tooltip.add((Component)effectDescription.m_130940_(effect.m_19483_().m_19497_()));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Horse horse;
        if (target instanceof Horse && (horse = (Horse)target).m_6084_() && horse.m_30614_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class HorseFeedEvent {
        @SubscribeEvent
        public static void onHorseFeedApplied(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getPlayer();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (ModTags.HORSE_FEED_USERS.m_8110_((Object)target.m_6095_())) {
                    boolean isTameable = entity instanceof AbstractHorse;
                    if (entity.m_6084_() && (!isTameable || ((AbstractHorse)entity).m_30614_()) && itemStack.m_41720_().equals(ModItems.HORSE_FEED.get())) {
                        entity.m_21153_(entity.m_21233_());
                        for (MobEffectInstance effect : EFFECTS) {
                            entity.m_7292_(new MobEffectInstance(effect));
                        }
                        entity.f_19853_.m_5594_(null, target.m_142538_(), SoundEvents.f_11976_, SoundSource.PLAYERS, 0.8f, 0.8f);
                        for (int i = 0; i < 5; ++i) {
                            double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                            entity.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.STAR.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                        }
                        if (!player.m_7500_()) {
                            itemStack.m_41774_(1);
                        }
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

