/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;

public class KnifeItem
extends DiggerItem {
    public KnifeItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(attackDamageIn, attackSpeedIn, tier, ModTags.MINEABLE_WITH_KNIFE, properties);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        ItemStack toolStack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        Direction facing = context.m_43719_();
        if (state.m_60734_() == Blocks.f_50133_ && ModTags.KNIVES.m_8110_((Object)toolStack.m_41720_())) {
            Player player = context.m_43723_();
            if (player != null && !world.f_46443_) {
                Direction direction = facing.m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : facing;
                world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)Blocks.f_50143_.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)direction), 11);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.65, new ItemStack((ItemLike)Items.f_42577_, 4));
                itemEntity.m_20334_(0.05 * (double)direction.m_122429_() + world.f_46441_.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.m_122431_() + world.f_46441_.nextDouble() * 0.02);
                world.m_7967_((Entity)itemEntity);
                toolStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44987_});
        if (DENIED_ENCHANTMENTS.contains(enchantment)) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class KnifeEvents {
        @SubscribeEvent
        public static void onKnifeKnockback(LivingKnockBackEvent event) {
            ItemStack toolStack;
            LivingEntity attacker = event.getEntityLiving().m_21232_();
            ItemStack itemStack = toolStack = attacker != null ? attacker.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
            if (toolStack.m_41720_() instanceof KnifeItem) {
                float f = event.getOriginalStrength();
                event.setStrength(event.getOriginalStrength() - 0.1f);
            }
        }

        @SubscribeEvent
        public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
            ItemStack toolStack = event.getPlayer().m_21120_(event.getHand());
            if (!ModTags.KNIVES.m_8110_((Object)toolStack.m_41720_())) {
                return;
            }
            Level world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = event.getWorld().m_8055_(pos);
            Block block = state.m_60734_();
            if (BlockTags.f_144268_.m_8110_((Object)block)) {
                world.m_7731_(pos, (BlockState)Blocks.f_50145_.m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
                Block.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()));
                world.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            if (block == Blocks.f_50145_) {
                int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                if (bites < 6) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    world.m_7471_(pos, false);
                }
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()));
                world.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

