/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipe;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public class CookingRecipes {
    public static final int FAST_COOKING = 100;
    public static final int NORMAL_COOKING = 200;
    public static final int SLOW_COOKING = 400;

    public static void register(Consumer<FinishedRecipe> consumer) {
        CookingRecipes.cookMiscellaneous(consumer);
        CookingRecipes.cookMinecraftSoups(consumer);
        CookingRecipes.cookMeals(consumer);
    }

    private static void cookMiscellaneous(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.HOT_COCOA.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.MILK).addIngredient((ItemLike)Items.f_42501_).addIngredient((ItemLike)Items.f_42533_).addIngredient((ItemLike)Items.f_42533_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.APPLE_CIDER.get(), 1, 200, 0.35f).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42501_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.TOMATO_SAUCE.get(), 1, 100, 0.1f).addIngredient((Tag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((Tag<Item>)ForgeTags.CROPS_TOMATO).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DOG_FOOD.get(), 1, 200, 0.35f).addIngredient((ItemLike)Items.f_42583_).addIngredient((ItemLike)Items.f_42499_).addIngredient((Tag<Item>)ModTags.WOLF_PREY).addIngredient((Tag<Item>)ForgeTags.CROPS_RICE).build(consumer);
    }

    private static void cookMinecraftSoups(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42400_, 1, 200, 0.2f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_41952_).addIngredient((ItemLike)Items.f_41953_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42734_, 1, 200, 0.2f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_42732_).addIngredient((ItemLike)Items.f_42732_).addIngredient((ItemLike)Items.f_42732_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42699_, 1, 200, 0.35f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)Items.f_42674_).addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42697_, Items.f_42698_})).addIngredient((ItemLike)Items.f_42619_).addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_, Items.f_41953_})).build(consumer);
    }

    private static void cookMeals(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BAKED_COD_STEW.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_FISHES_COD).addIngredient((ItemLike)Items.f_42620_).addIngredient((Tag<Item>)ForgeTags.EGGS).addIngredient((Tag<Item>)ForgeTags.CROPS_TOMATO).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BEEF_STEW.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_BEEF).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_42620_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CABBAGE_ROLLS.get(), 1, 100, 0.1f).addIngredient((Tag<Item>)ForgeTags.CROPS_CABBAGE).addIngredient((Tag<Item>)ModTags.CABBAGE_ROLL_INGREDIENTS).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CHICKEN_SOUP.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_CHICKEN).addIngredient((ItemLike)Items.f_42619_).addIngredient((Tag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((Tag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.COOKED_RICE.get(), 1, 100, 0.1f).addIngredient((Tag<Item>)ForgeTags.CROPS_RICE).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DUMPLINGS.get(), 2, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((Tag<Item>)ForgeTags.CROPS_CABBAGE).addIngredient((Tag<Item>)ForgeTags.CROPS_ONION).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.RAW_CHICKEN), new Ingredient.TagValue(ForgeTags.RAW_PORK), new Ingredient.TagValue(ForgeTags.RAW_BEEF), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41952_))))).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FISH_STEW.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_FISHES).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient((Tag<Item>)ForgeTags.CROPS_ONION).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FRIED_RICE.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.CROPS_RICE).addIngredient((Tag<Item>)ForgeTags.EGGS).addIngredient((ItemLike)Items.f_42619_).addIngredient((Tag<Item>)ForgeTags.CROPS_ONION).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.NOODLE_SOUP.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((Tag<Item>)ForgeTags.COOKED_EGGS).addIngredient((ItemLike)Items.f_42576_).addIngredient((Tag<Item>)ForgeTags.RAW_PORK).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get(), 1, 200, 0.35f).addIngredient((ItemLike)ModItems.MINCED_BEEF.get()).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_MUTTON).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PUMPKIN_SOUP.get(), 1, 200, 0.35f).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient((Tag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((Tag<Item>)ForgeTags.RAW_PORK).addIngredient((Tag<Item>)ForgeTags.MILK).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.RATATOUILLE.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((Tag<Item>)ForgeTags.CROPS_ONION).addIngredient((ItemLike)Items.f_42732_).addIngredient((Tag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.SQUID_INK_PASTA.get(), 1, 200, 0.35f).addIngredient((Tag<Item>)ForgeTags.RAW_FISHES).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((Tag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((ItemLike)Items.f_42532_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.STUFFED_PUMPKIN_BLOCK.get(), 1, 400, 0.5f, (ItemLike)Items.f_42046_).addIngredient((Tag<Item>)ForgeTags.CROPS_RICE).addIngredient((Tag<Item>)ForgeTags.VEGETABLES).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient((ItemLike)Items.f_42674_).addIngredient((ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()).addIngredient((ItemLike)Items.f_42780_).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_NOODLES.get(), 1, 200, 0.35f).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_41952_).addIngredient((Tag<Item>)ForgeTags.PASTA).addIngredient((Tag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((Tag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_SOUP.get(), 1, 200, 0.35f).addIngredient((ItemLike)Items.f_42619_).addIngredient((ItemLike)Items.f_42620_).addIngredient((ItemLike)Items.f_42732_).addIngredient((Tag<Item>)ForgeTags.SALAD_INGREDIENTS).build(consumer);
    }
}

