/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.client.gui.CookingPotScreen;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotContainer;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.category.CookingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.category.CuttingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.category.DecompositionRecipeCategory;
import vectorwing.farmersdelight.integration.jei.resource.DecompositionDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("farmersdelight", "jei_plugin");
    private static final Minecraft MC = Minecraft.m_91087_();

    private static List<Recipe<?>> findRecipesByType(RecipeType<?> type) {
        return JEIPlugin.MC.f_91073_.m_7465_().m_44051_().stream().filter(r -> r.m_6671_() == type).collect(Collectors.toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CookingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DecompositionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIPlugin.findRecipesByType(CookingPotRecipe.TYPE), CookingRecipeCategory.UID);
        registration.addRecipes(JEIPlugin.findRecipesByType(CuttingBoardRecipe.TYPE), CuttingRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableList.of((Object)new DecompositionDummy()), DecompositionRecipeCategory.UID);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.STRAW.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.straw", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.HAM.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.SMOKED_HAM.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.FLINT_KNIFE.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.IRON_KNIFE.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.DIAMOND_KNIFE.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.NETHERITE_KNIFE.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.GOLDEN_KNIFE.get()), VanillaTypes.ITEM, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.COOKING_POT.get()), new ResourceLocation[]{CookingRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get()), new ResourceLocation[]{CuttingRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.STOVE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CAMPFIRE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.SKILLET.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CAMPFIRE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ORGANIC_COMPOST.get()), new ResourceLocation[]{DecompositionRecipeCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CookingPotScreen.class, 89, 25, 24, 17, new ResourceLocation[]{CookingRecipeCategory.UID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CookingPotContainer.class, CookingRecipeCategory.UID, 0, 6, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

