/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.resource.CuttingBoardDrawable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CuttingRecipeCategory
implements IRecipeCategory<CuttingBoardRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelight", "cutting");
    public static final int OUTPUT_GRID_X = 76;
    public static final int OUTPUT_GRID_Y = 10;
    public static final int SLOT_SPRITE_SIZE = 18;
    private final IDrawable slot;
    private final IDrawable slotChance;
    private final Component title = TextUtils.getTranslation("jei.cutting", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final CuttingBoardDrawable cuttingBoard;

    public CuttingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/jei/cutting_board.png");
        this.slot = helper.createDrawable(backgroundImage, 0, 58, 18, 18);
        this.slotChance = helper.createDrawable(backgroundImage, 18, 58, 18, 18);
        this.background = helper.createDrawable(backgroundImage, 0, 0, 117, 57);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get()));
        this.cuttingBoard = new CuttingBoardDrawable(() -> new ItemStack((ItemLike)ModBlocks.CUTTING_BOARD.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CuttingBoardRecipe> getRecipeClass() {
        return CuttingBoardRecipe.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CuttingBoardRecipe cuttingBoardRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients(cuttingBoardRecipe.getIngredientsAndTool());
        ingredients.setOutputs(VanillaTypes.ITEM, cuttingBoardRecipe.getResults());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CuttingBoardRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<ChanceResult> recipeOutputs = recipe.getRollableResults();
        itemStacks.init(0, true, 15, 7);
        itemStacks.set(0, Arrays.asList(recipe.getTool().m_43908_()));
        itemStacks.init(1, true, 15, 26);
        itemStacks.set(1, Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        int size = recipeOutputs.size();
        int centerX = size > 1 ? 0 : 9;
        int centerY = size > 2 ? 0 : 9;
        for (int i = 0; i < size; ++i) {
            int xOffset = centerX + (i % 2 == 0 ? 0 : 19);
            int yOffset = centerY + i / 2 * 19;
            itemStacks.init(i + 2, false, 76 + xOffset, 10 + yOffset);
            itemStacks.set(i + 2, ((ChanceResult)recipeOutputs.get(i)).getStack());
        }
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input || slotIndex < 2) {
                return;
            }
            ChanceResult output = (ChanceResult)recipeOutputs.get(slotIndex - 2);
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add(1, TextUtils.getTranslation("jei.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
            }
        });
    }

    public void draw(CuttingBoardRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        NonNullList<ChanceResult> recipeOutputs = recipe.getRollableResults();
        int size = recipe.getResults().size();
        int centerX = size > 1 ? 0 : 9;
        int centerY = size > 2 ? 0 : 9;
        for (int i = 0; i < size; ++i) {
            int xOffset = centerX + (i % 2 == 0 ? 0 : 19);
            int yOffset = centerY + i / 2 * 19;
            if (((ChanceResult)recipeOutputs.get(i)).getChance() != 1.0f) {
                this.slotChance.draw(matrixStack, 76 + xOffset, 10 + yOffset);
                continue;
            }
            this.slot.draw(matrixStack, 76 + xOffset, 10 + yOffset);
        }
    }
}

