/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.BitSet;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfo;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfoAccess;
import net.caffeinemc.phosphor.common.chunk.light.InitialLightingAccess;
import net.caffeinemc.phosphor.common.chunk.light.LightProviderUpdateTracker;
import net.caffeinemc.phosphor.common.chunk.light.LightStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLevelPropagator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LayerLightEngine.class})
public abstract class MixinChunkLightProvider
extends MixinLevelPropagator
implements InitialLightingAccess,
LightProviderUpdateTracker {
    private static final BlockState DEFAULT_STATE = Blocks.f_50016_.m_49966_();
    private static final LevelChunkSection[] EMPTY_SECTION_ARRAY = new LevelChunkSection[0];
    @Shadow
    @Final
    protected BlockPos.MutableBlockPos f_75633_;
    @Shadow
    @Final
    protected LightChunkGetter f_75630_;
    private final long[] cachedChunkPos = new long[2];
    private final LevelChunkSection[][] cachedChunkSections = new LevelChunkSection[2][];
    private final Long2ObjectOpenHashMap<BitSet> buckets = new Long2ObjectOpenHashMap();
    private long prevChunkBucketKey = ChunkPos.f_45577_;
    private BitSet prevChunkBucketSet;
    private static final long BLOCK_TO_BUCKET_KEY_MASK = BlockPos.m_121882_((int)15, (int)15, (int)15) ^ 0xFFFFFFFFFFFFFFFFL;
    @Shadow
    @Final
    protected LayerLightSectionStorage<?> f_75632_;

    @Inject(method={"clearChunkCache"}, at={@At(value="RETURN")})
    private void onCleanup(CallbackInfo ci) {
        if (this.cachedChunkPos != null) {
            Arrays.fill(this.cachedChunkPos, ChunkPos.f_45577_);
            Arrays.fill((Object[])this.cachedChunkSections, null);
        }
    }

    @Unique
    protected boolean hasSection(long sectionPos) {
        return ((LightStorageAccess)this.f_75632_).callHasSection(sectionPos);
    }

    @Unique
    protected BlockState getBlockStateForLighting(int x, int y, int z) {
        long chunkPos = ChunkPos.m_45589_((int)(x >> 4), (int)(z >> 4));
        for (int i = 0; i < 2; ++i) {
            if (this.cachedChunkPos[i] != chunkPos) continue;
            return this.getBlockStateFromSection(this.cachedChunkSections[i], x, y, z);
        }
        return this.getBlockStateForLightingUncached(x, y, z);
    }

    private BlockState getBlockStateForLightingUncached(int x, int y, int z) {
        return this.getBlockStateFromSection(this.getAndCacheChunkSections(x >> 4, z >> 4), x, y, z);
    }

    private BlockState getBlockStateFromSection(LevelChunkSection[] sections, int x, int y, int z) {
        LevelChunkSection section;
        int index = this.f_75630_.m_7653_().m_151564_(y);
        if (index >= 0 && index < sections.length && !(section = sections[index]).m_188008_()) {
            return section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
        }
        return DEFAULT_STATE;
    }

    private LevelChunkSection[] getAndCacheChunkSections(int x, int z) {
        ChunkAccess chunk = (ChunkAccess)this.f_75630_.m_6196_(x, z);
        LevelChunkSection[] sections = chunk != null ? chunk.m_7103_() : EMPTY_SECTION_ARRAY;
        LevelChunkSection[][] cachedSections = this.cachedChunkSections;
        cachedSections[1] = cachedSections[0];
        cachedSections[0] = sections;
        long[] cachedCoords = this.cachedChunkPos;
        cachedCoords[1] = cachedCoords[0];
        cachedCoords[0] = ChunkPos.m_45589_((int)x, (int)z);
        return sections;
    }

    @Unique
    protected int getSubtractedLight(BlockState state, int x, int y, int z) {
        BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
        if (info != null) {
            return info.getLightSubtracted();
        }
        return this.getSubtractedLightFallback(state, x, y, z);
    }

    private int getSubtractedLightFallback(BlockState state, int x, int y, int z) {
        return state.m_60734_().m_7753_(state, this.f_75630_.m_7653_(), (BlockPos)this.f_75633_.m_122178_(x, y, z));
    }

    @Unique
    protected VoxelShape getOpaqueShape(BlockState state, int x, int y, int z, Direction dir) {
        if (state != null && state.m_60787_()) {
            BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
            if (info != null) {
                VoxelShape[] extrudedFaces = info.getExtrudedFaces();
                if (extrudedFaces != null) {
                    return extrudedFaces[dir.ordinal()];
                }
            } else {
                return this.getOpaqueShapeFallback(state, x, y, z, dir);
            }
        }
        return Shapes.m_83040_();
    }

    private VoxelShape getOpaqueShapeFallback(BlockState state, int x, int y, int z, Direction dir) {
        return Shapes.m_83121_((VoxelShape)state.m_60768_(this.f_75630_.m_7653_(), (BlockPos)this.f_75633_.m_122178_(x, y, z)), (Direction)dir);
    }

    @Override
    public void cancelUpdatesForChunk(long sectionPos) {
        long key = this.getBucketKeyForSection(sectionPos);
        BitSet bits = this.removeChunkBucket(key);
        if (bits != null && !bits.isEmpty()) {
            int startX = SectionPos.m_123213_((long)sectionPos) << 4;
            int startY = SectionPos.m_123225_((long)sectionPos) << 4;
            int startZ = SectionPos.m_123230_((long)sectionPos) << 4;
            int i = bits.nextSetBit(0);
            while (i != -1) {
                int x = i >> 8 & 0xF;
                int y = i >> 4 & 0xF;
                int z = i & 0xF;
                this.m_75600_(BlockPos.m_121882_((int)(startX + x), (int)(startY + y), (int)(startZ + z)));
                i = bits.nextSetBit(i + 1);
            }
        }
    }

    @Override
    protected void onPendingUpdateRemoved(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                return;
            }
        }
        bits.clear(MixinChunkLightProvider.getLocalIndex(blockPos));
        if (bits.isEmpty()) {
            this.removeChunkBucket(key);
        }
    }

    @Override
    protected void onPendingUpdateAdded(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                bits = new BitSet(4096);
                this.buckets.put(key, (Object)bits);
            }
            this.prevChunkBucketKey = key;
            this.prevChunkBucketSet = bits;
        }
        bits.set(MixinChunkLightProvider.getLocalIndex(blockPos));
    }

    private long getBucketKeyForBlock(long blockPos) {
        return blockPos & BLOCK_TO_BUCKET_KEY_MASK;
    }

    private long getBucketKeyForSection(long sectionPos) {
        return BlockPos.m_121882_((int)(SectionPos.m_123213_((long)sectionPos) << 4), (int)(SectionPos.m_123225_((long)sectionPos) << 4), (int)(SectionPos.m_123230_((long)sectionPos) << 4));
    }

    private BitSet removeChunkBucket(long key) {
        BitSet set = (BitSet)this.buckets.remove(key);
        if (this.prevChunkBucketSet == set) {
            this.prevChunkBucketKey = ChunkPos.f_45577_;
            this.prevChunkBucketSet = null;
        }
        return set;
    }

    private static int getLocalIndex(long blockPos) {
        int x = BlockPos.m_121983_((long)blockPos) & 0xF;
        int y = BlockPos.m_122008_((long)blockPos) & 0xF;
        int z = BlockPos.m_122015_((long)blockPos) & 0xF;
        return x << 8 | y << 4 | z;
    }

    @Shadow
    protected void m_6185_(long id) {
    }

    @Overwrite
    public void m_141940_(ChunkPos pos, boolean enabled) {
        long chunkPos = SectionPos.m_123240_((long)SectionPos.m_123209_((int)pos.f_45578_, (int)0, (int)pos.f_45579_));
        LightStorageAccess lightStorage = (LightStorageAccess)this.f_75632_;
        if (enabled) {
            lightStorage.invokeSetColumnEnabled(chunkPos, true);
            lightStorage.enableLightUpdates(chunkPos);
        } else {
            lightStorage.disableChunkLight(chunkPos, (LayerLightEngine)this);
        }
    }

    @Override
    public void enableSourceLight(long chunkPos) {
        ((LightStorageAccess)this.f_75632_).invokeSetColumnEnabled(chunkPos, true);
    }

    @Override
    public void enableLightUpdates(long chunkPos) {
        ((LightStorageAccess)this.f_75632_).enableLightUpdates(chunkPos);
    }

    @Inject(method={"doLightUpdates(IZZ)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/LightStorage;notifyChanges()V")})
    private void runCleanups(CallbackInfoReturnable<Integer> ci) {
        ((LightStorageAccess)this.f_75632_).runCleanups();
    }
}

