/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import net.caffeinemc.phosphor.common.chunk.light.IReadonly;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageDataAccess;
import net.caffeinemc.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.chunk.light.SkyLightChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={SkyLightSectionStorage.class})
public abstract class MixinSkyLightStorage
extends MixinLightStorage
implements SkyLightStorageAccess {
    @Unique
    private final LongSet initSkylightChunks = new LongOpenHashSet();
    @Shadow
    @Final
    private LongSet f_75864_;
    @Shadow
    private volatile boolean f_75865_;
    @Unique
    private static final DataLayer DIRECT_SKYLIGHT_MAP = new SkyLightChunkNibbleArray(ArrayUtils.toPrimitive((Byte[])new Byte[2048], (byte)-1));
    @Unique
    private static final DataLayer EMPTY_SKYLIGHT_MAP = new EmptyChunkNibbleArray();
    @Unique
    private final Long2IntMap vanillaLightmapComplexities = new Long2IntOpenHashMap();
    @Unique
    private final LongSet removedLightmaps = new LongOpenHashSet();
    @Unique
    private final Long2IntMap scheduledHeightIncreases = (Long2IntMap)Util.m_137469_((Object)new Long2IntOpenHashMap(), map -> map.defaultReturnValue(Integer.MIN_VALUE));
    @Unique
    private final LongSet scheduledHeightChecks = new LongOpenHashSet();

    /*
     * Unable to fully structure code
     */
    @Overwrite
    public int m_6181_(long pos) {
        posX = BlockPos.m_121983_((long)pos);
        posYOrig = BlockPos.m_122008_((long)pos);
        posZ = BlockPos.m_122015_((long)pos);
        chunkX = SectionPos.m_123171_((int)posX);
        chunkYOrig = SectionPos.m_123171_((int)posYOrig);
        chunkZ = SectionPos.m_123171_((int)posZ);
        chunkOrig = SectionPos.m_123209_((int)chunkX, (int)chunkYOrig, (int)chunkZ);
        lock = this.uncachedLightArraysLock;
        do lbl-1000:
        // 4 sources

        {
            block2: {
                stamp = lock.tryOptimisticRead();
                posY = posYOrig;
                chunkY = chunkYOrig;
                data = this.f_75731_;
                sdata = (SkyLightStorageDataAccess)data;
                chunk = chunkOrig;
                height = sdata.getHeight(SectionPos.m_123240_((long)chunk));
                if (height != sdata.getDefaultHeight() && chunkY < height) break block2;
                if (!lock.validate(stamp)) ** GOTO lbl-1000
                return 15;
            }
            array = data.m_75532_(chunk);
            while (array == null) {
                block3: {
                    if (++chunkY < height) break block3;
                    if (!lock.validate(stamp)) ** GOTO lbl-1000
                    return 15;
                }
                chunk = ChunkSectionPosHelper.updateYLong(chunk, chunkY);
                array = data.m_75532_(chunk);
                posY = chunkY << 4;
            }
        } while (!lock.validate(stamp));
        return array.m_62560_(SectionPos.m_123207_((int)posX), SectionPos.m_123207_((int)posY), SectionPos.m_123207_((int)posZ));
    }

    @Shadow
    protected abstract boolean m_75892_(long var1);

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        long sectionPos = SectionPos.m_123235_((long)blockPos);
        DataLayer lightmap = this.getLightmapAbove(sectionPos);
        if (lightmap == null) {
            return this.m_75892_(sectionPos) ? 15 : 0;
        }
        return lightmap.m_62560_(SectionPos.m_123207_((int)BlockPos.m_121983_((long)blockPos)), 0, SectionPos.m_123207_((int)BlockPos.m_122015_((long)blockPos)));
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, at=@At(value="NEW", target="()Lnet/minecraft/world/chunk/ChunkNibbleArray;"))
    private DataLayer initializeLightmap(long pos) {
        DataLayer ret = new DataLayer();
        if (this.m_75892_(pos)) {
            Arrays.fill(ret.m_7877_(), (byte)-1);
        }
        return ret;
    }

    @Override
    protected void beforeChunkEnabled(long chunkPos) {
        long sectionPos;
        int y;
        int minHeight = Integer.MAX_VALUE;
        int height = Integer.MIN_VALUE;
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
            if (y < minHeight && (this.nonOptimizableSections.contains(sectionPos) || this.m_75758_(sectionPos, true) != null)) {
                minHeight = y;
            }
            if (y <= height || !this.f_75728_.contains(sectionPos)) continue;
            height = y;
        }
        this.updateMinHeight(minHeight);
        if (height != Integer.MIN_VALUE) {
            this.setHeight(chunkPos, height);
        }
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            if (y <= height || this.f_75732_.m_75535_(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y)) == null) continue;
            this.untrackSection(chunkPos, y);
            this.f_75733_.add(sectionPos);
        }
        this.f_75732_.m_75531_();
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            long sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt());
            DataLayer lightmap = this.m_75758_(sectionPos2, true);
            if (lightmap == null) continue;
            this.initializeVanillaLightmapComplexity(sectionPos2, lightmap);
        }
    }

    @Override
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
        IntIterator it = removedLightmaps.iterator();
        while (it.hasNext()) {
            this.vanillaLightmapComplexities.remove(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()));
        }
        ((SkyLightStorageDataAccess)this.f_75732_).setHeight(chunkPos, this.getMinHeight());
        this.scheduledHeightChecks.remove(chunkPos);
        this.scheduledHeightIncreases.remove(chunkPos);
    }

    @Override
    @Overwrite
    public void m_7358_(long chunkPos, boolean enabled) {
        if (enabled) {
            if (this.enabledChunks.contains(chunkPos) && !this.f_75864_.contains(chunkPos)) {
                this.initSkylightChunks.add(chunkPos);
                this.markForUpdates();
            } else {
                this.f_75864_.add(chunkPos);
            }
        } else {
            this.f_75864_.remove(chunkPos);
            this.initSkylightChunks.remove(chunkPos);
        }
    }

    @Unique
    private static void spreadSourceSkylight(LevelPropagatorAccess lightProvider, long src, Direction dir) {
        lightProvider.invokePropagateLevel(src, BlockPos.m_121915_((long)src, (Direction)dir), 0, true);
    }

    @Unique
    private static void spreadZeroSkylight(LevelPropagatorAccess lightProvider, long src, Direction dir, int prevLight) {
        if (prevLight != 0) {
            lightProvider.invokePropagateLevel(src, BlockPos.m_121915_((long)src, (Direction)dir), 15 - prevLight, false);
        }
    }

    @Unique
    private static void pullSkylight(LevelPropagatorAccess lightProvider, long dst, Direction dir) {
        lightProvider.propagateLevel(BlockPos.m_121915_((long)dst, (Direction)dir), dst, true);
    }

    @Override
    protected void runCleanups(LayerLightEngine<?, ?> lightProvider) {
        super.runCleanups(lightProvider);
        if (!this.f_75865_) {
            return;
        }
        this.updateRemovedLightmaps();
        if (lightProvider == null) {
            this.m_75881_();
        }
    }

    @Override
    @Overwrite
    public void m_6716_(LayerLightEngine<?, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        super.m_6716_(lightProvider, doSkylight, skipEdgeLightPropagation);
        if (!doSkylight || !this.f_75865_) {
            return;
        }
        this.updateHeights(lightProvider);
        this.lightChunks(lightProvider);
        this.f_75865_ = false;
    }

    @Unique
    private void updateHeights(LayerLightEngine<?, ?> lightProvider) {
        int blockPosZ;
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        if (!this.scheduledHeightIncreases.isEmpty()) {
            for (Long2IntMap.Entry entry : this.scheduledHeightIncreases.long2IntEntrySet()) {
                int height;
                long chunkPos = entry.getLongKey();
                int oldHeight = this.getHeight(chunkPos) - 1;
                for (height = entry.getIntValue(); height > oldHeight && !this.f_75728_.contains(ChunkSectionPosHelper.updateYLong(chunkPos, height)); --height) {
                }
                if (height == oldHeight) continue;
                this.setHeight(chunkPos, height);
                int blockPosX = SectionPos.m_123223_((int)SectionPos.m_123213_((long)chunkPos));
                blockPosZ = SectionPos.m_123223_((int)SectionPos.m_123230_((long)chunkPos));
                if (this.m_75758_(ChunkSectionPosHelper.updateYLong(chunkPos, oldHeight + 1), true) != null) {
                    long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)(oldHeight + 1)), (int)blockPosZ);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            MixinSkyLightStorage.pullSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN);
                        }
                    }
                }
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    if (!this.enabledChunks.contains(SectionPos.m_123191_((long)chunkPos, (Direction)dir))) continue;
                    int ox = 15 * Math.max(dir.m_122429_(), 0);
                    int oz = 15 * Math.max(dir.m_122431_(), 0);
                    int dx = Math.abs(dir.m_122431_());
                    int dz = Math.abs(dir.m_122429_());
                    for (int y = height; y > oldHeight; --y) {
                        if (this.m_75758_(ChunkSectionPosHelper.updateYLong(chunkPos, y), true) == null) continue;
                        long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)y), (int)blockPosZ);
                        for (int t = 0; t < 16; ++t) {
                            for (int dy = 0; dy < 16; ++dy) {
                                MixinSkyLightStorage.pullSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                            }
                        }
                    }
                }
            }
            this.scheduledHeightIncreases.clear();
        }
        if (!this.scheduledHeightChecks.isEmpty()) {
            LongIterator it = this.scheduledHeightChecks.iterator();
            while (it.hasNext()) {
                long sectionPos;
                long chunkPos = it.nextLong();
                int height = this.getHeight(chunkPos) - 1;
                if (!this.m_75870_(height)) continue;
                if (this.f_75864_.contains(chunkPos)) {
                    long sectionPos2;
                    while (this.m_75870_(height) && !this.f_75728_.contains(sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, height)) && !this.hasLightmap(sectionPos2)) {
                        if (this.m_75758_(sectionPos2, true) != null) {
                            this.m_75764_(lightProvider, sectionPos2);
                        }
                        --height;
                    }
                    this.setHeight(chunkPos, height);
                    continue;
                }
                int lightmapPosAbove = Integer.MIN_VALUE;
                DataLayer lightmapAbove = null;
                while (this.m_75870_(height) && !this.f_75728_.contains(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, height))) {
                    DataLayer lightmap = this.m_75758_(sectionPos, true);
                    if (lightmap != null) {
                        this.m_75764_(lightProvider, sectionPos);
                        if (lightmapPosAbove == Integer.MIN_VALUE && !((IReadonly)lightmap).isReadonly()) {
                            lightmapPosAbove = height;
                            lightmapAbove = lightmap;
                        }
                    }
                    --height;
                }
                this.setHeight(chunkPos, height);
                if (lightmapPosAbove == Integer.MIN_VALUE) continue;
                int blockPosX = SectionPos.m_123223_((int)SectionPos.m_123213_((long)chunkPos));
                blockPosZ = SectionPos.m_123223_((int)SectionPos.m_123230_((long)chunkPos));
                boolean hasSectionBelow = this.m_75870_(height);
                for (int curY = lightmapPosAbove - 1; curY >= height; --curY) {
                    int x;
                    long curSectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, curY);
                    DataLayer lightmap = this.getLightmap(curSectionPos);
                    if (curY > height && lightmap == null) continue;
                    if (curY == height && hasSectionBelow) {
                        if (lightmap == null) {
                            this.getOrAddLightmap(curSectionPos);
                            this.setLightmapComplexity(curSectionPos, this.vanillaLightmapComplexities.get(ChunkSectionPosHelper.updateYLong(chunkPos, lightmapPosAbove)));
                        } else {
                            int amount = 0;
                            for (int z = 0; z < 16; ++z) {
                                for (x = 0; x < 16; ++x) {
                                    amount += MixinSkyLightStorage.getComplexityChange(lightmap.m_62560_(x, 15, z), lightmapAbove.m_62560_(x, 0, z), 0);
                                }
                            }
                            this.changeLightmapComplexity(curSectionPos, amount);
                        }
                    }
                    for (int y = lightmapPosAbove; y > curY; --y) {
                        long sectionPos3 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                        if (this.m_75758_(sectionPos3, true) == null) continue;
                        if (this.removeLightmap(sectionPos3)) {
                            this.vanillaLightmapComplexities.remove(sectionPos3);
                        }
                        if (!this.nonOptimizableSections.contains(sectionPos3)) continue;
                        this.f_75732_.m_75526_(sectionPos3, EMPTY_SKYLIGHT_MAP);
                    }
                    this.f_75732_.m_75531_();
                    if (curY == height && hasSectionBelow) {
                        long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)(height + 1)), (int)blockPosZ);
                        for (x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN, lightmapAbove.m_62560_(x, 0, z));
                            }
                        }
                    }
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        int ox = 15 * Math.max(dir.m_122429_(), 0);
                        int oz = 15 * Math.max(dir.m_122431_(), 0);
                        int dx = Math.abs(dir.m_122431_());
                        int dz = Math.abs(dir.m_122429_());
                        for (int y = lightmapPosAbove; y > curY; --y) {
                            long sectionPos4 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                            long neighborSectionPos = SectionPos.m_123191_((long)sectionPos4, (Direction)dir);
                            if (!this.m_75791_(neighborSectionPos)) continue;
                            long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)y), (int)blockPosZ);
                            for (int t = 0; t < 16; ++t) {
                                for (int dy = 0; dy < 16; ++dy) {
                                    int x2 = ox + t * dx;
                                    int z = oz + t * dz;
                                    MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)x2, (int)dy, (int)z), dir, lightmapAbove.m_62560_(x2, y == lightmapPosAbove ? dy : 0, z));
                                }
                            }
                        }
                    }
                    lightmapPosAbove = curY;
                    lightmapAbove = lightmap;
                }
            }
            this.scheduledHeightChecks.clear();
        }
        levelPropagator.checkForUpdates();
    }

    @Unique
    private void lightChunks(LayerLightEngine<?, ?> lightProvider) {
        if (this.initSkylightChunks.isEmpty()) {
            return;
        }
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        LongIterator cit = this.initSkylightChunks.iterator();
        while (cit.hasNext()) {
            long chunkPos = cit.nextLong();
            int minY = this.getHeight(chunkPos) - 1;
            boolean hasSectionBelow = this.m_75870_(minY);
            if (hasSectionBelow) {
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, minY);
                DataLayer lightmap = this.getLightmap(sectionPos);
                if (lightmap == null) {
                    this.getOrAddLightmap(sectionPos);
                    this.setLightmapComplexity(sectionPos, 3840);
                } else {
                    int amount = 0;
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            amount += MixinSkyLightStorage.getComplexityChange(lightmap.m_62560_(x, 15, z), 0, 15);
                        }
                    }
                    this.changeLightmapComplexity(sectionPos, amount);
                }
            }
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                int y = it.nextInt();
                if (y <= minY) continue;
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                this.removeLightmap(sectionPos);
                if (!this.nonOptimizableSections.contains(sectionPos)) continue;
                this.f_75732_.m_75526_(sectionPos, DIRECT_SKYLIGHT_MAP);
            }
            this.f_75732_.m_75531_();
            this.f_75864_.add(chunkPos);
            int blockPosX = SectionPos.m_123223_((int)SectionPos.m_123213_((long)chunkPos));
            int blockPosZ = SectionPos.m_123223_((int)SectionPos.m_123230_((long)chunkPos));
            if (hasSectionBelow) {
                long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)(minY + 1)), (int)blockPosZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN);
                    }
                }
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                long neighborChunkPos = SectionPos.m_123191_((long)chunkPos, (Direction)dir);
                int ox = 15 * Math.max(dir.m_122429_(), 0);
                int oz = 15 * Math.max(dir.m_122431_(), 0);
                int dx = Math.abs(dir.m_122431_());
                int dz = Math.abs(dir.m_122429_());
                for (int y = this.getHeight(neighborChunkPos) - 1; y > minY; --y) {
                    if (!this.m_75791_(ChunkSectionPosHelper.updateYLong(neighborChunkPos, y))) continue;
                    long blockPos = BlockPos.m_121882_((int)blockPosX, (int)SectionPos.m_123223_((int)y), (int)blockPosZ);
                    for (int t = 0; t < 16; ++t) {
                        for (int dy = 0; dy < 16; ++dy) {
                            MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.m_121910_((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                        }
                    }
                }
            }
        }
        levelPropagator.checkForUpdates();
        this.initSkylightChunks.clear();
    }

    @Unique
    private void updateRemovedLightmaps() {
        while (!this.removedLightmaps.isEmpty()) {
            int y;
            long sectionPos = this.removedLightmaps.iterator().nextLong();
            if (!this.enabledChunks.contains(SectionPos.m_123240_((long)sectionPos))) continue;
            long removedLightmapPosAbove = sectionPos;
            int height = this.getHeight(SectionPos.m_123240_((long)sectionPos));
            if (height == this.getMinHeight()) {
                y = height;
            } else {
                for (y = SectionPos.m_123225_((long)sectionPos); y < height && !this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y)); ++y) {
                    if (!this.removedLightmaps.contains(sectionPos)) continue;
                    removedLightmapPosAbove = sectionPos;
                }
            }
            DataLayer lightmapAbove = y >= height ? (this.m_75892_(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP) : (this.vanillaLightmapComplexities.get(sectionPos) == 0 ? EMPTY_SKYLIGHT_MAP : this.m_75758_(sectionPos, true));
            this.updateVanillaLightmapsBelow(removedLightmapPosAbove, lightmapAbove);
        }
    }

    @Overwrite
    private void m_75881_() {
        this.f_75865_ = !this.initSkylightChunks.isEmpty() || !this.removedLightmaps.isEmpty() || !this.scheduledHeightIncreases.isEmpty() || !this.scheduledHeightChecks.isEmpty();
    }

    @Unique
    private void markForUpdates() {
        if (!this.f_75865_) {
            this.f_75865_ = true;
        }
    }

    @Override
    public boolean m_75791_(long sectionPos) {
        return super.m_75791_(sectionPos) && this.m_75758_(sectionPos, true) != null && !this.m_75890_(sectionPos);
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<DataLayer> lightmapArray, long pos) {
        return null;
    }

    @Unique
    private static int getComplexityChange(int val, int oldNeighborVal, int newNeighborVal) {
        return Math.abs(newNeighborVal - val) - Math.abs(oldNeighborVal - val);
    }

    @Override
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, DataLayer lightmap) {
        long sectionPos = SectionPos.m_123235_((long)blockPos);
        if (SectionPos.m_123207_((int)BlockPos.m_122008_((long)blockPos)) == 0) {
            this.vanillaLightmapComplexities.put(sectionPos, this.vanillaLightmapComplexities.get(sectionPos) + newVal - oldVal);
            long sectionPosBelow = this.getSectionBelow(sectionPos);
            if (sectionPosBelow != Long.MAX_VALUE) {
                DataLayer lightmapBelow = this.getOrAddLightmap(sectionPosBelow);
                int x = SectionPos.m_123207_((int)BlockPos.m_121983_((long)blockPos));
                int z = SectionPos.m_123207_((int)BlockPos.m_122015_((long)blockPos));
                this.changeLightmapComplexity(sectionPosBelow, MixinSkyLightStorage.getComplexityChange(lightmapBelow.m_62560_(x, 15, z), oldVal, newVal));
            }
        } else if (this.f_75733_.add(sectionPos)) {
            this.f_75732_.m_75524_(sectionPos);
            if (this.vanillaLightmapComplexities.get(sectionPos) != 0) {
                this.updateVanillaLightmapsBelow(sectionPos, this.m_75758_(sectionPos, true));
            }
        }
    }

    @Override
    @Invoker(value="isAboveMinHeight")
    public abstract boolean callIsAboveMinHeight(int var1);

    @Shadow
    protected abstract boolean m_75870_(int var1);

    @Shadow
    protected abstract boolean m_75890_(long var1);

    @Unique
    private int getHeight(long chunkPos) {
        return ((SkyLightStorageDataAccess)this.f_75732_).getHeight(chunkPos);
    }

    @Unique
    private int getMinHeight() {
        return ((SkyLightStorageDataAccess)this.f_75732_).getDefaultHeight();
    }

    @Unique
    private void setHeight(long chunkPos, int height) {
        ((SkyLightStorageDataAccess)this.f_75732_).setHeight(chunkPos, height + 1);
    }

    @Unique
    private void updateMinHeight(int y) {
        ((SkyLightStorageDataAccess)this.f_75732_).updateMinHeight(y);
    }

    @Unique
    private long getSectionBelow(long sectionPos) {
        int y = SectionPos.m_123225_((long)sectionPos);
        while (this.m_75870_(y)) {
            if (this.m_75791_(sectionPos = SectionPos.m_123191_((long)sectionPos, (Direction)Direction.DOWN))) {
                return sectionPos;
            }
            --y;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, DataLayer lightmap) {
        DataLayer lightmapAbove;
        long sectionPos = SectionPos.m_123235_((long)blockPos);
        int x = SectionPos.m_123207_((int)BlockPos.m_121983_((long)blockPos));
        int y = SectionPos.m_123207_((int)BlockPos.m_122008_((long)blockPos));
        int z = SectionPos.m_123207_((int)BlockPos.m_122015_((long)blockPos));
        int valAbove = y < 15 ? lightmap.m_62560_(x, y + 1, z) : ((lightmapAbove = this.getLightmapAbove(sectionPos)) == null ? this.getDirectSkylight(sectionPos) : lightmapAbove.m_62560_(x, 0, z));
        int amount = MixinSkyLightStorage.getComplexityChange(valAbove, oldVal, newVal);
        if (y > 0) {
            amount += MixinSkyLightStorage.getComplexityChange(lightmap.m_62560_(x, y - 1, z), oldVal, newVal);
        }
        return amount;
    }

    @Unique
    private DataLayer getLightmapAbove(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        return sectionPosAbove == Long.MAX_VALUE ? null : this.m_75758_(sectionPosAbove, true);
    }

    @Unique
    private long getSectionAbove(long sectionPos) {
        int height = this.getHeight(SectionPos.m_123240_((long)sectionPos));
        if (height != this.getMinHeight()) {
            for (int y = SectionPos.m_123225_((long)sectionPos) + 1; y < height; ++y) {
                if (!this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y))) continue;
                return sectionPos;
            }
        }
        return Long.MAX_VALUE;
    }

    @Unique
    private int getDirectSkylight(long sectionPos) {
        return this.m_75892_(sectionPos) ? 15 : 0;
    }

    @Override
    protected void beforeLightmapChange(long sectionPos, DataLayer oldLightmap, DataLayer newLightmap) {
        int vanillaComplexity;
        long sectionPosBelow = this.getSectionBelow(sectionPos);
        int n = vanillaComplexity = oldLightmap == null ? 0 : this.initializeVanillaLightmapComplexity(sectionPos, newLightmap);
        if (sectionPosBelow != Long.MAX_VALUE) {
            DataLayer lightmapBelow = this.getLightmap(sectionPosBelow);
            DataLayer lightmapAbove = oldLightmap == null ? this.getLightmapAbove(sectionPos) : oldLightmap;
            int skyLight = this.getDirectSkylight(sectionPos);
            if (lightmapBelow == null) {
                int complexity = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        complexity += Math.abs(newLightmap.m_62560_(x, 0, z) - (lightmapAbove == null ? skyLight : lightmapAbove.m_62560_(x, 0, z)));
                    }
                }
                if (complexity != 0) {
                    this.getOrAddLightmap(sectionPosBelow);
                    this.setLightmapComplexity(sectionPosBelow, complexity);
                } else if (vanillaComplexity != 0) {
                    this.updateVanillaLightmapsBelow(sectionPos, newLightmap);
                }
            } else {
                int amount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.m_62560_(x, 15, z), lightmapAbove == null ? skyLight : lightmapAbove.m_62560_(x, 0, z), newLightmap.m_62560_(x, 0, z));
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, DataLayer lightmap) {
        int x;
        int z;
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int skyLight = this.getDirectSkylight(sectionPos);
        if (lightmap.m_62575_()) {
            return sectionPosAbove == Long.MAX_VALUE ? 256 * skyLight : this.vanillaLightmapComplexities.get(sectionPosAbove);
        }
        int complexity = 0;
        for (int y = 0; y < 15; ++y) {
            for (z = 0; z < 16; ++z) {
                for (x = 0; x < 16; ++x) {
                    complexity += Math.abs(lightmap.m_62560_(x, y + 1, z) - lightmap.m_62560_(x, y, z));
                }
            }
        }
        DataLayer lightmapAbove = sectionPosAbove == Long.MAX_VALUE ? null : this.m_75758_(sectionPosAbove, true);
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                complexity += Math.abs((lightmapAbove == null ? skyLight : lightmapAbove.m_62560_(x, 0, z)) - lightmap.m_62560_(x, 15, z));
            }
        }
        return complexity;
    }

    @Override
    public void m_7351_(long id, int level) {
        long chunkPos = SectionPos.m_123240_((long)id);
        if (this.enabledChunks.contains(chunkPos)) {
            int oldLevel = this.m_6172_(id);
            int y = SectionPos.m_123225_((long)id);
            if (oldLevel != 0 && level == 0) {
                if (y + 1 > this.getHeight(chunkPos)) {
                    if (this.f_75864_.contains(chunkPos)) {
                        this.setHeight(chunkPos, y);
                    } else if (y > this.scheduledHeightIncreases.get(chunkPos)) {
                        this.scheduledHeightIncreases.put(chunkPos, y);
                        this.markForUpdates();
                    }
                }
            } else if (oldLevel == 0 && level != 0) {
                if (y + 1 == this.getHeight(chunkPos)) {
                    this.scheduledHeightChecks.add(chunkPos);
                    this.markForUpdates();
                }
            } else if (oldLevel >= 2 && level < 2) {
                this.updateMinHeight(y);
            }
        }
        super.m_7351_(id, level);
    }

    @Override
    protected DataLayer createInitialVanillaLightmap(long sectionPos) {
        if (!this.f_75728_.contains(sectionPos) && !this.f_75728_.contains(SectionPos.m_123191_((long)sectionPos, (Direction)Direction.UP))) {
            return this.createTrivialVanillaLightmap(sectionPos);
        }
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int complexity = sectionPosAbove == Long.MAX_VALUE ? (this.m_75892_(sectionPos) ? 3840 : 0) : this.vanillaLightmapComplexities.get(sectionPosAbove);
        if (complexity == 0) {
            return EMPTY_SKYLIGHT_MAP;
        }
        DataLayer lightmap = new DataLayer(new byte[2048]);
        this.f_75732_.m_75526_(sectionPos, lightmap);
        this.trackSection(sectionPos);
        this.f_75732_.m_75531_();
        this.m_6177_(sectionPos);
        this.setLightmapComplexity(sectionPos, complexity);
        return lightmap;
    }

    @Override
    protected DataLayer createTrivialVanillaLightmap(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        if (sectionPosAbove == Long.MAX_VALUE) {
            return this.m_75892_(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP;
        }
        return this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? EMPTY_SKYLIGHT_MAP : new SkyLightChunkNibbleArray(this.m_75758_(sectionPosAbove, true));
    }

    @Override
    @Overwrite
    public void m_6177_(long sectionPos) {
        DataLayer lightmap;
        int y = SectionPos.m_123225_((long)sectionPos);
        this.updateMinHeight(y);
        long chunkPos = SectionPos.m_123240_((long)sectionPos);
        if (y + 1 > this.getHeight(chunkPos)) {
            this.setHeight(chunkPos, y);
        }
        this.updateVanillaLightmapsBelow(sectionPos, this.initializeVanillaLightmapComplexity(sectionPos, lightmap = this.m_75758_(sectionPos, true)) == 0 ? EMPTY_SKYLIGHT_MAP : lightmap);
    }

    @Unique
    private int initializeVanillaLightmapComplexity(long sectionPos, DataLayer lightmap) {
        int complexity = 0;
        if (!lightmap.m_62575_()) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += lightmap.m_62560_(x, 0, z);
                }
            }
        }
        this.vanillaLightmapComplexities.put(sectionPos, complexity);
        return complexity;
    }

    @Override
    @Overwrite
    public void m_6187_(long sectionPos) {
        if (this.vanillaLightmapComplexities.remove(sectionPos) != 0) {
            this.removedLightmaps.add(sectionPos);
            this.markForUpdates();
        }
        long chunkPos = SectionPos.m_123240_((long)sectionPos);
        if (SectionPos.m_123225_((long)sectionPos) + 1 == this.getHeight(chunkPos)) {
            this.scheduledHeightChecks.add(chunkPos);
            this.markForUpdates();
        }
    }

    @Unique
    private void updateVanillaLightmapsBelow(long sectionPos, DataLayer lightmapAbove) {
        this.removedLightmaps.remove(sectionPos);
        DataLayer lightmap = ((IReadonly)lightmapAbove).isReadonly() ? lightmapAbove : new SkyLightChunkNibbleArray(lightmapAbove);
        int y = SectionPos.m_123225_((long)sectionPos) - 1;
        while (this.m_75870_(y)) {
            long sectionPosBelow = SectionPos.m_123209_((int)SectionPos.m_123213_((long)sectionPos), (int)y, (int)SectionPos.m_123230_((long)sectionPos));
            this.removedLightmaps.remove(sectionPosBelow);
            DataLayer lightmapBelow = this.m_75758_(sectionPosBelow, true);
            if (lightmapBelow != null) {
                if (!((IReadonly)lightmapBelow).isReadonly()) break;
                this.f_75732_.m_75526_(sectionPosBelow, lightmap);
                this.f_75733_.add(sectionPosBelow);
            }
            --y;
        }
        this.f_75732_.m_75531_();
    }
}

