/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.Config;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("createdeco", "config");
    private final String configName;

    public ConfigCondition(String name) {
        this.configName = name;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return Config.getSetting(this.configName);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("config", value.configName);
        }

        public ConfigCondition read(JsonObject json) {
            return new ConfigCondition(json.get("config").getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

