/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.github.talrey.createdeco.connected.CatwalkCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalSlabCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalVertCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.items.CatwalkBlockItem;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.DoorMovingInteraction;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.Registrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.ItemEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Registration {
    private static HashMap<DyeColor, String> BRICK_COLOR_NAMES = new HashMap();
    private static ArrayList<String> COIN_TYPES = new ArrayList();
    private static HashMap<String, Function<String, Item>> DOOR_TYPES = new HashMap();
    public static HashMap<String, Function<String, Item>> METAL_TYPES = new HashMap();
    private static HashMap<String, Function<String, Item>> METAL_LOOKUP = new HashMap();
    public static ItemEntry<Item> WORN_BRICK_ITEM;
    public static HashMap<String, BlockEntry<Block>> WORN_BRICK_TYPES;
    public static HashMap<String, BlockEntry<StairBlock>> WORN_STAIRS;
    public static HashMap<String, BlockEntry<SlabBlock>> WORN_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> WORN_VERTS;
    public static HashMap<String, BlockEntry<WallBlock>> WORN_WALLS;
    public static HashMap<DyeColor, BlockEntry<Block>> BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> TILE_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> LONG_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> SHORT_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_SHORT_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_SHORT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<StairBlock>>> BRICK_STAIRS_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<SlabBlock>>> BRICK_SLAB_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<VerticalSlabBlock>>> BRICK_VERT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<WallBlock>>> BRICK_WALL_BLOCK;
    public static HashMap<String, BlockEntry<CoinStackBlock>> COIN_BLOCKS;
    public static HashMap<String, BlockEntry<DoorBlock>> DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<DoorBlock>> LOCK_DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<IronBarsBlock>> BAR_BLOCKS;
    public static HashMap<String, BlockEntry<IronBarsBlock>> BAR_PANEL_BLOCKS;
    public static HashMap<String, BlockEntry<Block>> SHEET_METAL_BLOCKS;
    public static HashMap<String, BlockEntry<StairBlock>> SHEET_STAIRS;
    public static HashMap<String, BlockEntry<SlabBlock>> SHEET_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> SHEET_VERT_SLABS;
    public static HashMap<String, BlockEntry<FenceBlock>> MESH_FENCE_BLOCKS;
    public static HashMap<String, BlockEntry<CatwalkBlock>> CATWALK_BLOCKS;
    public static HashMap<DyeColor, BlockEntry<DecalBlock>> DECAL_BLOCKS;
    public static HashMap<DyeColor, ItemEntry<Item>> BRICK_ITEM;
    public static HashMap<String, ItemEntry<Item>> COIN_ITEM;
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACK_ITEM;
    public static ItemEntry<Item> ZINC_SHEET;
    public static ItemEntry<Item> NETHERITE_SHEET;
    public static ItemEntry<Item> NETHERITE_NUGGET;
    public static final CreativeModeTab BRICKS_GROUP;
    public static final CreativeModeTab METALS_GROUP;
    public static final CreativeModeTab PROPS_GROUP;
    private static final String BRICKS_NAME = "CreateDeco Bricks";
    private static final String METALS_NAME = "CreateDeco Metals";
    private static final String PROPS_NAME = "CreateDeco Props";

    public Registration() {
        BRICK_COLOR_NAMES.put(DyeColor.BLACK, "Dusk");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_GRAY, "Pearl");
        BRICK_COLOR_NAMES.put(DyeColor.RED, "Scarlet");
        BRICK_COLOR_NAMES.put(DyeColor.YELLOW, "Dean");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_BLUE, "Blue");
        BRICK_COLOR_NAMES.put(null, "Red");
        COIN_TYPES.add("Zinc");
        COIN_TYPES.add("Copper");
        COIN_TYPES.add("Brass");
        COIN_TYPES.add("Iron");
        COIN_TYPES.add("Gold");
        COIN_TYPES.add("Netherite");
        DOOR_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        DOOR_TYPES.put("Copper", str -> Items.f_151052_);
        DOOR_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        DOOR_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> Items.f_151052_);
        METAL_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> Items.f_42416_);
        METAL_TYPES.put("Gold", str -> Items.f_42417_);
        METAL_TYPES.put("Netherite", str -> Items.f_42418_);
        METAL_LOOKUP.put("Andesite", str -> str.equals("block") ? ((CasingBlock)AllBlocks.ANDESITE_CASING.get()).m_5456_() : (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_LOOKUP.put("Zinc", str -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:zinc_block")));
        METAL_LOOKUP.put("Copper", str -> Items.f_151000_);
        METAL_LOOKUP.put("Brass", str -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:brass_block")));
        METAL_LOOKUP.put("Iron", str -> Items.f_41913_);
        METAL_LOOKUP.put("Gold", str -> Items.f_41912_);
        METAL_LOOKUP.put("Netherite", str -> Items.f_42791_);
    }

    private static BlockEntry<?> getBrickFromName(String overlay, DyeColor dye, String shape) {
        if (overlay.trim().equals("Mossy")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> MOSSY_TILE_BLOCK.get(dye);
                case "Long Bricks" -> MOSSY_LONG_BLOCK.get(dye);
                case "Short Bricks" -> MOSSY_SHORT_BLOCK.get(dye);
                default -> MOSSY_BRICK_BLOCK.get(dye);
            };
        }
        if (overlay.trim().equals("Cracked")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> CRACKED_TILE_BLOCK.get(dye);
                case "Long Bricks" -> CRACKED_LONG_BLOCK.get(dye);
                case "Short Bricks" -> CRACKED_SHORT_BLOCK.get(dye);
                default -> CRACKED_BRICK_BLOCK.get(dye);
            };
        }
        return switch (shape.trim()) {
            case "Brick Tiles" -> TILE_BRICK_BLOCK.get(dye);
            case "Long Bricks" -> LONG_BRICK_BLOCK.get(dye);
            case "Short Bricks" -> SHORT_BRICK_BLOCK.get(dye);
            default -> BRICK_BLOCK.get(dye);
        };
    }

    public static String getBrickColorName(DyeColor color) {
        return BRICK_COLOR_NAMES.getOrDefault(color, "");
    }

    public static Item getBrickItemFromColor(DyeColor color) {
        return color != null ? (Item)BRICK_ITEM.get(color).get() : Items.f_42460_;
    }

    public static Block getBrickBlockFromColor(DyeColor color) {
        return color != null ? (Block)BRICK_BLOCK.get(color).get() : Blocks.f_50076_;
    }

    public static Block getBrickStairBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50193_;
        }
        return (Block)BRICK_STAIRS_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickSlabBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50410_;
        }
        return (Block)BRICK_SLAB_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickWallBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50604_;
        }
        return (Block)BRICK_WALL_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickVertBlockFromColor(DyeColor color, String suf) {
        return (Block)BRICK_VERT_BLOCK.get(color).get(suf).get();
    }

    private static BlockBuilder<Block, ?> buildBrick(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf, Block::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf)))).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix).defaultLoot().simpleItem();
    }

    private static BlockBuilder<StairBlock, ?> buildBrickStairs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_stairs", props -> new StairBlock(() -> ((Block)Blocks.f_50193_).m_49966_(), props));
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Stairs").defaultLoot().simpleItem();
    }

    private static BlockBuilder<SlabBlock, ?> buildBrickSlabs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_slab", SlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + pre + name.toLowerCase(Locale.ROOT) + (String)(suf.equals("") ? "" : "_" + suf)), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Slab").simpleItem();
    }

    private static BlockBuilder<VerticalSlabBlock, ?> buildBrickVerts(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_slab_vert", VerticalSlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> {
            String texLoc = "block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf;
            ResourceLocation tex = prov.modLoc(texLoc);
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", tex);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", tex);
            int y = 0;
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Vertical Slab").simpleItem();
    }

    private static BlockBuilder<WallBlock, ?> buildBrickWalls(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_wall", WallBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return (BlockBuilder)ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Wall").defaultLoot().tag(new Tag.Named[]{BlockTags.f_13032_}).item().model((ctx, prov) -> prov.wallInventory("item/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_wall", prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).build();
    }

    private static BlockBuilder<IronBarsBlock, ?> buildBars(Registrate reg, String metal, Function<String, Item> getter, String suffix) {
        ResourceLocation postTexture;
        File touch;
        ResourceLocation barTexture;
        String base = metal.replace(' ', '_').toLowerCase(Locale.ROOT) + "_bars";
        String suf = suffix.equals("") ? "" : "_" + suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String post = "block/palettes/metal_bars/" + base + (metal.equals("Brass") || metal.equals("Netherite") ? "_post" : "");
        try {
            barTexture = new ResourceLocation("createdeco", "block/palettes/metal_bars/" + base);
            touch = new File("../src/main/resources/assets/createdeco/textures/" + barTexture.m_135815_() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            barTexture = new ResourceLocation("block/" + base);
        }
        try {
            postTexture = new ResourceLocation("createdeco", post);
            touch = new File("../src/main/resources/assets/createdeco/textures/" + postTexture.m_135815_() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            postTexture = barTexture;
        }
        ResourceLocation bartex = barTexture;
        ResourceLocation postex = postTexture;
        return (BlockBuilder)reg.block(base + suf, IronBarsBlock::new).properties(props -> props.m_60955_().m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postex)).texture("particle", postex)).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postex)).texture("particle", postex)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            if (!suf.equals("")) {
                BlockModelBuilder sideOverlayModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf, prov.mcLoc("block/iron_bars_side"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                BlockModelBuilder sideOverlayAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf + "_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            }
        }).tag(new Tag.Named[]{BlockTags.f_13032_}).item().model((ctx, prov) -> {
            if (suf.isEmpty()) {
                prov.singleTexture(base, prov.mcLoc("item/generated"), "layer0", bartex);
            } else {
                ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(base + suf, prov.mcLoc("item/generated"))).texture("layer0", bartex)).texture("layer1", prov.modLoc("block/palettes/metal_bars/" + base + suf));
            }
        }).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build();
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> BRICKS_GROUP);
        BlockBuilder wornBrick = Registration.buildBrick(reg, null, "", "Worn", "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("bb").m_126130_("bb").m_126127_(Character.valueOf('b'), (ItemLike)WORN_BRICK_ITEM.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WORN_BRICK_ITEM.get()})).m_176498_((Consumer)prov));
        WORN_BRICK_TYPES.put("Worn Bricks", (BlockEntry<Block>)wornBrick.register());
        String[] prefs = new String[]{"", "Cracked", "Mossy"};
        String[] sufs = new String[]{"Bricks", "Brick Tiles", "Long Bricks", "Short Bricks"};
        for (String string : prefs) {
            for (String suf : sufs) {
                String full = (String)(string.equals("") ? "" : string + " ") + "Worn " + suf;
                if (!string.equals("") || !suf.equals("Bricks")) {
                    WORN_BRICK_TYPES.put(full, (BlockEntry<Block>)Registration.buildBrick(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((ItemLike)((Item)WORN_BRICK_ITEM.get()), (ItemLike[])new Item[0]), (Supplier)ctx);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((ItemLike)((Item)WORN_BRICK_ITEM.get()), (ItemLike[])new Item[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
                WORN_STAIRS.put(full, (BlockEntry<StairBlock>)Registration.buildBrickStairs(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    prov.stairs(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_STAIRS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_SLABS.put(full, (BlockEntry<SlabBlock>)Registration.buildBrickSlabs(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    prov.slab(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_SLABS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_VERTS.put(full, (BlockEntry<VerticalSlabBlock>)Registration.buildBrickVerts(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)WORN_SLABS.get(full).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WORN_SLABS.get(full).get()})).m_176498_((Consumer)prov);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_VERTS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_WALLS.put(full, (BlockEntry<WallBlock>)Registration.buildBrickWalls(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.wall(DataIngredient.items((ItemLike)((Block)WORN_BRICK_TYPES.get(full).get()), (ItemLike[])new Block[0]), (Supplier)ctx);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_WALLS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
            }
        }
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye != null) {
                BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("bb").m_126130_("bb").m_126127_(Character.valueOf('b'), (ItemLike)Registration.getBrickItemFromColor(dye)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Registration.getBrickItemFromColor(dye)})).m_176498_((Consumer)prov)).register());
            }
            TILE_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            LONG_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            SHORT_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            CRACKED_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Brick Tiles").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)TILE_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Long Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)LONG_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Short Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)SHORT_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            MOSSY_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            HashMap<CallSite, BlockEntry> stair = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> slab = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> vert = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> wall = new HashMap<CallSite, BlockEntry>();
            for (String pre : prefs) {
                for (String suf : sufs) {
                    String full = (String)(pre.equals("") ? "" : pre + " ") + name + " " + suf;
                    if (dye != null || !pre.equals("") || !suf.equals("Bricks")) {
                        stair.put((CallSite)((Object)full), Registration.buildBrickStairs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                            prov.stairs(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickStairBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        slab.put((CallSite)((Object)full), Registration.buildBrickSlabs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                            prov.slab(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        wall.put((CallSite)((Object)full), Registration.buildBrickWalls(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.wall(DataIngredient.items((ItemLike)((Block)Registration.getBrickFromName(pre, dye, suf).get()), (ItemLike[])new Block[0]), (Supplier)ctx);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickWallBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                    }
                    vert.put((CallSite)((Object)full), Registration.buildBrickVerts(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx, 2);
                        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)Registration.getBrickSlabBlockFromColor(dye, full)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Registration.getBrickSlabBlockFromColor(dye, full)})).m_176498_((Consumer)prov);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
            }
            BRICK_STAIRS_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<StairBlock>>)stair);
            BRICK_SLAB_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<SlabBlock>>)slab);
            BRICK_VERT_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<VerticalSlabBlock>>)vert);
            BRICK_WALL_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<WallBlock>>)wall);
        });
        reg.creativeModeTab(() -> PROPS_GROUP);
        COIN_TYPES.forEach(metal -> COIN_BLOCKS.put(metal.toLowerCase(Locale.ROOT), (BlockEntry<CoinStackBlock>)reg.block(metal.toLowerCase(Locale.ROOT) + "_coinstack_block", CoinStackBlock::new).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56728_)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int layer = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + layer, prov.modLoc("block/layers_bottom_top_" + layer))).texture("side", prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_coinstack_side"))).texture("bottom", prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_coinstack_bottom"))).texture("top", prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_coinstack_top"))).build();
        })).addLayer(() -> RenderType::m_110457_).lang(metal + " Stack Block").loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            for (int layer = 1; layer <= 8; ++layer) {
                LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)((ItemLike)COINSTACK_ITEM.get(metal).get()));
                ((LootPoolSingletonContainer.Builder)entry.m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61417_, layer)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)layer)));
                pool.m_79076_((LootPoolEntryContainer.Builder)entry);
            }
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).register()));
        for (String string : DyeColor.values()) {
            DECAL_BLOCKS.put((DyeColor)string, (BlockEntry<DecalBlock>)((BlockBuilder)reg.block(string.name().toLowerCase(Locale.ROOT) + "_decal", DecalBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56762_)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int y = 0;
                switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/decal"))).texture("face", prov.modLoc("block/palettes/decal/" + ctx.getName()))).texture("particle", prov.modLoc("block/palettes/decal/" + ctx.getName()))).rotationY(y).build();
            })).addLayer(() -> RenderType::m_110457_).lang(string.name().charAt(0) + string.name().substring(1).toLowerCase() + " Decal").item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/decal/" + ctx.getName()))).build()).recipe((arg_0, arg_1) -> Registration.lambda$registerBlocks$75((DyeColor)string, arg_0, arg_1)).register());
        }
        reg.creativeModeTab(() -> METALS_GROUP);
        DOOR_TYPES.forEach((metal, ingot) -> DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT), (BlockEntry<DoorBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_door", DoorBlock::new).initialProperties(Material.f_76321_).properties(props -> props.m_60955_().m_60913_(5.0f, 5.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_door_bottom"), prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_door_top"))).addLayer(() -> RenderType::m_110457_).tag(new Tag.Named[]{BlockTags.f_144282_}).tag(new Tag.Named[]{BlockTags.f_13103_}).lang(metal + " Door").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("mm").m_126130_("mm").m_126130_("mm").m_126127_(Character.valueOf('m'), (ItemLike)ingot.apply(metal)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ingot.apply(metal)})).m_176498_((Consumer)prov)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()))).properties(props -> metal.equals("Netherite") ? props.m_41486_() : props).build()).onRegister(door -> AllInteractionBehaviours.addInteractionBehaviour((Block)door, DoorMovingInteraction::new))).register()));
        DOOR_TYPES.forEach((metal, ingot) -> LOCK_DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT), (BlockEntry<DoorBlock>)((BlockBuilder)reg.block("locked_" + metal.toLowerCase(Locale.ROOT) + "_door", DoorBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60955_().m_60913_(5.0f, 5.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/locked_" + metal.toLowerCase(Locale.ROOT) + "_door_bottom"), prov.modLoc("block/locked_" + metal.toLowerCase(Locale.ROOT) + "_door_top"))).addLayer(() -> RenderType::m_110457_).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new Tag.Named[]{BlockTags.f_144282_}).tag(new Tag.Named[]{BlockTags.f_13103_}).lang("Locked " + metal + " Door").recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)Items.f_41978_, 1).m_126211_((ItemLike)DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT)).get(), 1).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT)).asStack().m_41720_()})).m_176498_((Consumer)prov)).item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()))).properties(props -> metal.equals("Netherite") ? props.m_41486_() : props).build()).register()));
        METAL_TYPES.forEach((metal, getter) -> {
            BAR_BLOCKS.put((String)metal, (BlockEntry<IronBarsBlock>)Registration.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "").tag(new Tag.Named[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).addLayer(() -> RenderType::m_110457_).recipe((ctx, prov) -> {
                if (!metal.equals("Iron")) {
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)16).m_126130_("mmm").m_126130_("mmm").m_126127_(Character.valueOf('m'), (ItemLike)getter.apply(metal)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)getter.apply(metal)})).m_176498_((Consumer)prov);
                }
                ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)BAR_PANEL_BLOCKS.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BAR_PANEL_BLOCKS.get(metal).get()})).m_142700_((Consumer)prov, new ResourceLocation("createdeco", metal.toLowerCase(Locale.ROOT) + "_bars_from_panel"));
            }).register());
            BAR_PANEL_BLOCKS.put((String)metal, (BlockEntry<IronBarsBlock>)Registration.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "overlay").addLayer(() -> RenderType::m_110457_).lang((metal.equals("Iron") ? "Polished Iron" : metal) + " Panel Bars ").recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)BAR_BLOCKS.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BAR_BLOCKS.get(metal).get()})).m_176498_((Consumer)prov)).register());
            if (metal.equals("Iron")) {
                BAR_PANEL_BLOCKS.put("Vanilla Iron", (BlockEntry<IronBarsBlock>)Registration.buildBars(reg, metal, getter, "overlay").lang(metal + " Panel Bars").recipe((ctx, prov) -> {
                    ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)Items.f_42025_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42025_})).m_176498_((Consumer)prov);
                    ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42025_).m_126209_((ItemLike)ctx.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ctx.get()})).m_142700_((Consumer)prov, new ResourceLocation("createdeco", "vanilla_metal_bars_from_panel"));
                }).register());
            }
            SHEET_METAL_BLOCKS.put((String)metal, (BlockEntry<Block>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_sheet_metal", Block::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/sheet_metal/" + ctx.getName())))).tag(new Tag.Named[]{BlockTags.f_144282_}).lang(metal + " Sheet Metal").defaultLoot().item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build()).recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)METAL_LOOKUP.get(metal).apply("block"), (ItemLike[])new Item[0]), (Supplier)ctx, 4)).onRegister(CreateRegistrate.connectedTextures(new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal)).getSupplier()))).register());
            SHEET_STAIRS.put((String)metal, (BlockEntry<StairBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_sheet_stairs", props -> new StairBlock(() -> ((Block)Blocks.f_50193_).m_49966_(), props)).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build()).tag(new Tag.Named[]{BlockTags.f_13030_}).tag(new Tag.Named[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT) + "_sheet_metal"))).lang(metal + " Sheet Stairs").recipe((ctx, prov) -> {
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                prov.stairs(DataIngredient.items((ItemLike)((Block)SHEET_METAL_BLOCKS.get(metal).get()), (ItemLike[])new Block[0]), (Supplier)ctx, null, false);
            }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal)).getSupplier()))).register());
            SHEET_SLABS.put((String)metal, (BlockEntry<SlabBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_sheet_slab", SlabBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build()).tag(new Tag.Named[]{BlockTags.f_13031_}).tag(new Tag.Named[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + metal.toLowerCase(Locale.ROOT) + "_sheet_metal"), prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT) + "_sheet_metal"))).loot((table, block) -> {
                LootTable.Builder builder = LootTable.m_79147_();
                LootPool.Builder pool = LootPool.m_79043_();
                pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
                table.m_124165_((Block)block, builder.m_79161_(pool));
            }).lang(metal + " Sheet Slab").recipe((ctx, prov) -> {
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                prov.slab(DataIngredient.items((ItemLike)((Block)SHEET_METAL_BLOCKS.get(metal).get()), (ItemLike[])new Block[0]), (Supplier)ctx, null, false);
            }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalSlabCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal)).getSupplier()))).register());
            SHEET_VERT_SLABS.put((String)metal, (BlockEntry<VerticalSlabBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_sheet_slab_vert", VerticalSlabBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build()).tag(new Tag.Named[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> {
                String texLoc = "block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT) + "_sheet_metal";
                ResourceLocation tex = prov.modLoc(texLoc);
                BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", tex);
                BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", tex);
                int y = 0;
                for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                    switch (dir) {
                        case NORTH: {
                            y = 0;
                            break;
                        }
                        case SOUTH: {
                            y = 180;
                            break;
                        }
                        case WEST: {
                            y = -90;
                            break;
                        }
                        case EAST: {
                            y = 90;
                        }
                    }
                    ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                    ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
                }
            }).loot((table, block) -> {
                LootTable.Builder builder = LootTable.m_79147_();
                LootPool.Builder pool = LootPool.m_79043_();
                pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
                table.m_124165_((Block)block, builder.m_79161_(pool));
            }).recipe((ctx, prov) -> {
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)SHEET_SLABS.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SHEET_METAL_BLOCKS.get(metal).asStack().m_41720_()})).m_176498_((Consumer)prov);
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
            }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalVertCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal)).getSupplier()))).register());
            MESH_FENCE_BLOCKS.put((String)metal, (BlockEntry<FenceBlock>)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_mesh_fence", FenceBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56728_)).addLayer(() -> RenderType::m_110457_).tag(new Tag.Named[]{BlockTags.f_13039_}).tag(new Tag.Named[]{BlockTags.f_144282_}).item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase(Locale.ROOT) + "_chain_link"))).build()).recipe((ctx, prov) -> {
                if (metal.equals("Andesite")) {
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("psp").m_126130_("psp").m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42401_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()})).m_176498_((Consumer)prov);
                } else {
                    Tag.Named sheet = ItemTags.m_13194_((String)("forge:plates/" + metal.toLowerCase(Locale.ROOT)));
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("psp").m_126130_("psp").m_126121_(Character.valueOf('p'), (Tag)sheet).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42401_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_45069_((Tag)sheet).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                String dir = "chainlink_fence";
                boolean north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
                boolean south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
                boolean east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
                boolean west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
                int sides = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
                ResourceLocation mesh = prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase(Locale.ROOT) + "_chain_link");
                ResourceLocation wall = prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT) + "_sheet_metal");
                switch (sides) {
                    case 4: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_four_way", prov.modLoc(dir + "_four_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
                    }
                    case 3: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tri_way", prov.modLoc(dir + "_tri_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (south ? (east ? 90 : -90) : 0) : 180).build();
                    }
                    case 2: {
                        if (north && south || east && west) {
                            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_straight", prov.modLoc(dir + "_straight"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(east ? 0 : 90).build();
                        }
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_corner", prov.modLoc(dir + "_corner"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (east ? 0 : -90) : (east ? 90 : 180)).build();
                    }
                    case 1: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_end", prov.modLoc(dir + "_end"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? -90 : (south ? 90 : (east ? 0 : 180))).build();
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_post", prov.modLoc(dir + "_post"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
            })).register());
            CATWALK_BLOCKS.put((String)metal, (BlockEntry<CatwalkBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT) + "_catwalk", CatwalkBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60955_().m_60918_(SoundType.f_56725_)).addLayer(() -> RenderType::m_110457_).tag(new Tag.Named[]{BlockTags.f_144282_}).item(CatwalkBlockItem::new).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/template_trapdoor_bottom"))).texture("texture", prov.modLoc("block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT) + "_catwalk"))).build()).recipe((ctx, prov) -> {
                if (metal.equals("Andesite")) {
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_(" p ").m_126130_("pBp").m_126130_(" p ").m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAR_BLOCKS.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()})).m_176498_((Consumer)prov);
                } else {
                    Tag.Named sheet = ItemTags.m_13194_((String)("forge:plates/" + metal.toLowerCase(Locale.ROOT)));
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_(" p ").m_126130_("pBp").m_126130_(" p ").m_126121_(Character.valueOf('p'), (Tag)sheet).m_126127_(Character.valueOf('B'), (ItemLike)BAR_BLOCKS.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_45069_((Tag)sheet).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).blockstate((ctx, prov) -> {
                String texture = "createdeco:block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT) + "_catwalk";
                BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_bottom", prov.modLoc("block/catwalk_bottom"))).texture("2", texture)).texture("particle", texture);
                BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_top", prov.modLoc("block/catwalk_top"))).texture("2", texture)).texture("particle", texture);
                BlockModelBuilder rail_upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_upper", prov.modLoc("block/catwalk_rail_upper"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
                BlockModelBuilder rail_lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_lower", prov.modLoc("block/catwalk_rail_lower"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)lower).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)upper).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            }).onRegister(CreateRegistrate.connectedTextures(new CatwalkCTBehaviour(SpriteShifts.CATWALK_TOPS.get(metal)).getSupplier()))).register());
        });
    }

    public static void registerItems(Registrate reg) {
        reg.creativeModeTab(() -> BRICKS_GROUP, BRICKS_NAME);
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye == null) {
                WORN_BRICK_ITEM = reg.item("worn_brick", Item::new).recipe((ctx, prov) -> prov.blasting(DataIngredient.items((ItemLike)Items.f_42460_, (ItemLike[])new Item[0]), (Supplier)ctx, 0.3f)).register();
            } else {
                BRICK_ITEM.put((DyeColor)dye, (ItemEntry<Item>)reg.item(name.toLowerCase(Locale.ROOT) + "_brick", Item::new).lang(name + " Brick").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)8).m_126130_("bbb").m_126130_("bCb").m_126130_("bbb").m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('C'), (ItemLike)DyeItem.m_41082_((DyeColor)dye)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)dye)})).m_176498_((Consumer)prov)).register());
            }
        });
        reg.creativeModeTab(() -> METALS_GROUP, METALS_NAME);
        ZINC_SHEET = reg.item("zinc_sheet", Item::new).tag(new Tag.Named[]{ItemTags.m_13194_((String)"forge:plates/zinc")}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = reg.item("netherite_sheet", Item::new).properties(p -> p.m_41486_()).tag(new Tag.Named[]{ItemTags.m_13194_((String)"forge:plates/netherite")}).lang("Netherite Sheet").register();
        NETHERITE_NUGGET = reg.item("netherite_nugget", Item::new).properties(p -> p.m_41486_()).tag(new Tag.Named[]{ItemTags.m_13194_((String)"forge:nuggets/netherite")}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> Items.f_42418_)).register();
        reg.creativeModeTab(() -> PROPS_GROUP, PROPS_NAME);
        for (String metal : COIN_TYPES) {
            COIN_ITEM.put(metal, (ItemEntry<Item>)reg.item(metal.toLowerCase(Locale.ROOT) + "_coin", Item::new).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ctx.get()), (int)4).m_126209_((ItemLike)COINSTACK_ITEM.get(metal).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)COINSTACK_ITEM.get(metal).get()})).m_176498_((Consumer)prov)).lang(metal + " Coin").register());
            COINSTACK_ITEM.put(metal, (ItemEntry<CoinStackItem>)reg.item(metal.toLowerCase(Locale.ROOT) + "_coinstack", CoinStackItem::new).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)COIN_ITEM.get(metal).get(), 4).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)COIN_ITEM.get(metal).get()})).m_176498_((Consumer)prov)).lang(metal + " Coinstack").register());
        }
    }

    private static /* synthetic */ void lambda$registerBlocks$75(DyeColor color, DataGenContext ctx, RegistrateRecipeProvider prov) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)AllItems.IRON_SHEET.get(), 1).m_126211_((ItemLike)DyeItem.m_41082_((DyeColor)color), 1).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.IRON_SHEET.get()})).m_142284_("has_dye", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)color)})).m_176498_((Consumer)prov);
    }

    static {
        WORN_BRICK_TYPES = new HashMap();
        WORN_STAIRS = new HashMap();
        WORN_SLABS = new HashMap();
        WORN_VERTS = new HashMap();
        WORN_WALLS = new HashMap();
        BRICK_BLOCK = new HashMap();
        TILE_BRICK_BLOCK = new HashMap();
        LONG_BRICK_BLOCK = new HashMap();
        SHORT_BRICK_BLOCK = new HashMap();
        CRACKED_BRICK_BLOCK = new HashMap();
        CRACKED_TILE_BLOCK = new HashMap();
        CRACKED_LONG_BLOCK = new HashMap();
        CRACKED_SHORT_BLOCK = new HashMap();
        MOSSY_BRICK_BLOCK = new HashMap();
        MOSSY_TILE_BLOCK = new HashMap();
        MOSSY_LONG_BLOCK = new HashMap();
        MOSSY_SHORT_BLOCK = new HashMap();
        BRICK_STAIRS_BLOCK = new HashMap();
        BRICK_SLAB_BLOCK = new HashMap();
        BRICK_VERT_BLOCK = new HashMap();
        BRICK_WALL_BLOCK = new HashMap();
        COIN_BLOCKS = new HashMap();
        DOOR_BLOCKS = new HashMap();
        LOCK_DOOR_BLOCKS = new HashMap();
        BAR_BLOCKS = new HashMap();
        BAR_PANEL_BLOCKS = new HashMap();
        SHEET_METAL_BLOCKS = new HashMap();
        SHEET_STAIRS = new HashMap();
        SHEET_SLABS = new HashMap();
        SHEET_VERT_SLABS = new HashMap();
        MESH_FENCE_BLOCKS = new HashMap();
        CATWALK_BLOCKS = new HashMap();
        DECAL_BLOCKS = new HashMap();
        BRICK_ITEM = new HashMap();
        COIN_ITEM = new HashMap();
        COINSTACK_ITEM = new HashMap();
        BRICKS_GROUP = new DecoCreativeModeTab("createdeco.bricks", () -> BRICK_BLOCK.get(DyeColor.LIGHT_BLUE).asStack());
        METALS_GROUP = new DecoCreativeModeTab("createdeco.metals", () -> BAR_BLOCKS.get("Brass").asStack());
        PROPS_GROUP = new DecoCreativeModeTab("createdeco.props", () -> COINSTACK_ITEM.get("Brass").asStack());
    }

    public static class DecoCreativeModeTab
    extends CreativeModeTab {
        private final Supplier<ItemStack> sup;

        public DecoCreativeModeTab(String name, Supplier<ItemStack> supplier) {
            super(name);
            this.sup = supplier;
        }

        @NotNull
        public ItemStack m_6976_() {
            return this.sup.get();
        }
    }
}

