/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix.mixin;

import java.util.Optional;
import net.blay09.mods.netherportalfix.NetherPortalFix;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.blay09.mods.netherportalfix.ReturnPortalManager;
import net.blay09.mods.netherportalfix.mixin.EntityAccessor;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"getExitPortal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, cancellable=true)
    public void getExitPortal(ServerLevel level, BlockPos pos, boolean isToNether, WorldBorder worldBorder, CallbackInfoReturnable<Optional<BlockUtil.FoundRectangle>> callbackInfo) {
        boolean isTeleportBetweenNetherAndOverworld;
        ServerPlayer player = (ServerPlayer)this;
        BlockPos fromPos = player.m_142538_();
        ResourceKey fromDim = player.f_19853_.m_46472_();
        ResourceKey toDim = level.m_46472_();
        ResourceKey OVERWORLD = Level.f_46428_;
        ResourceKey THE_NETHER = Level.f_46429_;
        boolean isPlayerCurrentlyInPortal = ((EntityAccessor)player).getIsInsidePortal();
        boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD;
        if (isPlayerCurrentlyInPortal && isTeleportBetweenNetherAndOverworld) {
            ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, (ResourceKey<Level>)fromDim, fromPos);
            if (returnPortal == null) {
                NetherPortalFix.logger.info("No return portal found");
                return;
            }
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            ServerLevel toLevel = server.m_129880_(toDim);
            if (toLevel == null) {
                return;
            }
            NetherPortalFix.logger.info("Return portal found, redirecting! :)");
            callbackInfo.setReturnValue(Optional.of(returnPortal.getRectangle()));
        }
    }
}

