/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.corn_delight;

import cn.mcmod.corn_delight.CornDelightConfig;
import cn.mcmod.corn_delight.worldgen.WildCornGeneration;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="corn_delight")
public class CornCommonEvent {
    private static final ResourceLocation SHIPWRECK_SUPPLY_CHEST = BuiltInLootTables.f_78694_;
    private static final Set<ResourceLocation> VILLAGE_HOUSE_CHESTS = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78755_, BuiltInLootTables.f_78758_, BuiltInLootTables.f_78757_, BuiltInLootTables.f_78756_, BuiltInLootTables.f_78754_});

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (((Boolean)Configuration.CROPS_ON_SHIPWRECKS.get()).booleanValue() && event.getName().equals((Object)SHIPWRECK_SUPPLY_CHEST)) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("corn_delight", "inject/shipwreck_supply")).m_79707_(1).m_79711_(0)).name("supply_cd_crops").m_79082_());
        }
        if (((Boolean)Configuration.CROPS_ON_VILLAGE_HOUSES.get()).booleanValue() && VILLAGE_HOUSE_CHESTS.contains(event.getName())) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("corn_delight", "inject/crops_villager_houses")).m_79707_(1).m_79711_(0)).name("villager_houses_cd_crops").m_79082_());
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        Biome.ClimateSettings climate = event.getClimate();
        if (climate.f_47681_ > 0.0f && climate.f_47681_ <= 1.0f && ((Boolean)CornDelightConfig.GENERATE_WILD_CORN.get()).booleanValue()) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, WildCornGeneration.PATCH_WILD_CORN);
        }
    }
}

