/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.common.world.data.GlobeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GlobeTextureManager
implements AutoCloseable {
    public static GlobeTextureManager INSTANCE = null;
    private final TextureManager textureManager;
    private final Map<String, TextureInstance> globeTextures = Maps.newHashMap();

    public static void init(TextureManager textureManager) {
        INSTANCE = new GlobeTextureManager(textureManager);
    }

    public GlobeTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public void update() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            this.getTextureInstance((Level)world, false).updateTexture((Level)world);
            this.getTextureInstance((Level)world, true).updateTexture((Level)world);
        }
    }

    public RenderType getRenderType(Level world, boolean sepia) {
        return this.getTextureInstance((Level)world, (boolean)sepia).renderType;
    }

    private TextureInstance getTextureInstance(Level world, boolean sepia) {
        return this.globeTextures.computeIfAbsent(GlobeTextureManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(Level level, boolean sepia) {
        Object id = level.m_46472_().m_135782_().m_135815_();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    @Override
    public void close() {
        for (TextureInstance textureInstance : this.globeTextures.values()) {
            textureInstance.close();
        }
        this.globeTextures.clear();
    }

    private class TextureInstance
    implements AutoCloseable {
        private final DynamicTexture texture;
        private final RenderType renderType;
        private final String dimensionId;
        private final boolean sepia;

        private TextureInstance(Level world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.m_46472_().m_135782_().toString();
            this.texture = new DynamicTexture(32, 16, false);
            this.updateTexture(world);
            ResourceLocation resourcelocation = GlobeTextureManager.this.textureManager.m_118490_("globe/" + this.dimensionId.replace(":", "_"), this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)resourcelocation);
        }

        private void updateTexture(Level world) {
            byte[][] pixels = GlobeData.get((Level)world).globePixels;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.m_117991_().m_84988_(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.m_117991_().m_84988_(y, x, GlobeColors.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            this.texture.m_117985_();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }

    public static class GlobeColors {
        public static final HashMap<String, List<Integer>> dimensionColorMap = new HashMap();
        public static final List<Integer> defaultColorMap = new ArrayList<Integer>();
        public static final List<Integer> sepiaColorMap = new ArrayList<Integer>();

        public static List<List<String>> getDefaultConfig() {
            ArrayList<List<String>> l = new ArrayList<List<String>>();
            ArrayList<String> col = new ArrayList<String>();
            col.add("minecraft:overworld");
            for (int i = 1; i < 13; ++i) {
                col.add(Integer.toHexString(defaultColorMap.get((byte)i)));
            }
            l.add(col);
            l.add(Arrays.asList("minecraft:the_nether", "941818", "7b0000", "6a0400", "16615b", "941818", "ca4e06", "e66410", "f48522", "5a0000", "32333d", "118066", "100c1c"));
            l.add(Arrays.asList("minecraft:the_end", "061914", "000000", "2a0d2a", "000000", "d5da94", "cdc68b", "061914", "2a0d2a", "cdc68b", "000000", "eef6b4", "b286b2"));
            return l;
        }

        public static void refreshColorsFromConfig() {
            dimensionColorMap.clear();
            try {
                List<? extends List<String>> customColors = ConfigHandler.safeGetListString(ClientConfigs.CLIENT_SPEC, ClientConfigs.block.GLOBE_COLORS);
                for (List<String> list : customColors) {
                    if (list.size() < 13) continue;
                    String id = list.get(0);
                    ArrayList<Integer> col = new ArrayList<Integer>();
                    col.add(0);
                    for (int i = 1; i < 13; ++i) {
                        int hex;
                        try {
                            hex = Integer.parseInt(list.get(i).replace("0x", ""), 16);
                        }
                        catch (Exception e) {
                            Supplementaries.LOGGER.warn("failed to parse config 'globe_colors' (at dimension" + id + "). Try deleting them");
                            continue;
                        }
                        col.add(hex);
                    }
                    dimensionColorMap.put(id, col);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to parse config globe_color configs. Try deleting them");
                dimensionColorMap.put("minecraft:overworld", new ArrayList<Integer>(defaultColorMap));
            }
        }

        private static int getRGB(byte b, String dimension, boolean sepia) {
            if (sepia) {
                return sepiaColorMap.get(b);
            }
            return dimensionColorMap.getOrDefault(dimension, defaultColorMap).get(b);
        }

        public static int getRGBA(byte b, String dimension, boolean sepia) {
            int rgb = GlobeColors.getRGB(b, dimension, sepia);
            return 0xFF000000 | (rgb & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb >> 16 & 0xFF;
        }

        static {
            defaultColorMap.add(0, 0);
            defaultColorMap.add(1, 2319757);
            defaultColorMap.add(2, 2445949);
            defaultColorMap.add(3, 1915245);
            defaultColorMap.add(4, 2984540);
            defaultColorMap.add(5, 3448890);
            defaultColorMap.add(6, 7250251);
            defaultColorMap.add(7, 9021501);
            defaultColorMap.add(8, 11909733);
            defaultColorMap.add(9, 13424597);
            defaultColorMap.add(10, 8631494);
            defaultColorMap.add(11, 3113890);
            defaultColorMap.add(12, 8547953);
            defaultColorMap.add(13, 9340533);
            defaultColorMap.add(14, 2984540);
            defaultColorMap.add(15, 12749127);
            defaultColorMap.add(16, 12230501);
            defaultColorMap.add(17, 12230501);
            defaultColorMap.add(18, 7770473);
            sepiaColorMap.add(0, 0);
            sepiaColorMap.add(1, 12301734);
            sepiaColorMap.add(2, 10920080);
            sepiaColorMap.add(3, 9472632);
            sepiaColorMap.add(4, 8747877);
            sepiaColorMap.add(5, 7759959);
            sepiaColorMap.add(6, 6773322);
            sepiaColorMap.add(7, 7759959);
            sepiaColorMap.add(8, 8747877);
            sepiaColorMap.add(9, 7759959);
            sepiaColorMap.add(10, 8747877);
            sepiaColorMap.add(11, 9472632);
            sepiaColorMap.add(12, 8747877);
            sepiaColorMap.add(13, 8747877);
        }
    }
}

