/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;

public class ClockBlockTileRenderer
implements BlockEntityRenderer<ClockBlockTile> {
    public final Material HAND_TEXTURE = new Material(TextureAtlas.f_118259_, Textures.CLOCK_HAND_TEXTURE);
    public final ModelPart hourHand;
    public final ModelPart minuteHand;

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("hour", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        root.m_171599_("minute", CubeListBuilder.m_171558_().m_171514_(2, 0).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)16, (int)16);
    }

    public ClockBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.CLOCK_HANDS_MODEL);
        this.minuteHand = model.m_171324_("minute");
        this.hourHand = model.m_171324_("hour");
    }

    public void render(ClockBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = this.HAND_TEXTURE.m_119194_(bufferIn, RenderType::m_110458_);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_85845_(RotHlpr.rot(tile.getDirection()));
        matrixStackIn.m_85845_(RotHlpr.X90);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14189_((float)partialTicks, (float)tile.prevRoll, (float)tile.roll)));
        matrixStackIn.m_85837_(0.0, -1.5, -0.47916667);
        this.hourHand.m_104306_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14189_((float)partialTicks, (float)tile.sPrevRoll, (float)tile.sRoll)));
        matrixStackIn.m_85837_(0.0, -1.5, -0.45833333);
        this.minuteHand.m_104306_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }
}

