/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeKnotBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.utils.BlockItemUtils;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.decorativeblocks.RopeChandelierBlock;
import net.mehvahdjukaar.supplementaries.integration.quark.QuarkPistonPlugin;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBlock
extends WaterBlock {
    private final Map<BlockState, VoxelShape> SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61388_;
    public static final BooleanProperty KNOT = BlockProperties.KNOT;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    });
    private static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.makeShapes();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.SHAPES_MAP.getOrDefault(((BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    protected void makeShapes() {
        VoxelShape down = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.m_49796_((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        VoxelShape knot = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        for (BlockState state : this.f_49792_.m_61056_()) {
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || (Integer)state.m_61143_((Property)DISTANCE) != 0) continue;
            VoxelShape v = Shapes.m_83040_();
            if (((Boolean)state.m_61143_((Property)KNOT)).booleanValue()) {
                v = Shapes.m_83124_((VoxelShape)knot, (VoxelShape[])new VoxelShape[0]);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)east);
            }
            v = v.m_83296_();
            boolean flag = true;
            for (VoxelShape existing : this.SHAPES_MAP.values()) {
                if (!existing.equals(v)) continue;
                this.SHAPES_MAP.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            this.SHAPES_MAP.put(state, v);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, WATERLOGGED, DISTANCE, KNOT});
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity2) {
        return (Boolean)state.m_61143_((Property)DOWN) != false && ((Boolean)state.m_61143_((Property)UP) != false || entity2.m_20182_().m_7098_() - (double)pos.m_123342_() < 0.8125);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        return (Boolean)state.m_61143_((Property)UP) == false && (context.m_6513_(COLLISION_SHAPE, pos, true) || (Boolean)state.m_61143_((Property)DOWN) == false) || !(context instanceof EntityCollisionContext) || !((ec = (EntityCollisionContext)context).m_193113_() instanceof LivingEntity) ? this.m_5940_(state, worldIn, pos, context) : Shapes.m_83040_();
    }

    public static boolean shouldConnectToDir(BlockState thisState, BlockPos currentPos, LevelReader world, Direction dir) {
        BlockPos facingPos = currentPos.m_142300_(dir);
        return RopeBlock.shouldConnectToFace(thisState, world.m_8055_(facingPos), facingPos, dir, world);
    }

    public static boolean shouldConnectToFace(BlockState thisState, BlockState facingState, BlockPos facingPos, Direction dir, LevelReader world) {
        Block thisBlock = thisState.m_60734_();
        Block b = facingState.m_60734_();
        boolean isKnot = thisBlock == ModRegistry.ROPE_KNOT.get();
        boolean isVerticalKnot = isKnot && thisState.m_61143_(RopeKnotBlock.AXIS) == Direction.Axis.Y;
        switch (dir) {
            case UP: {
                if (isVerticalKnot) {
                    return false;
                }
                return RopeBlock.isSupportingCeiling(facingState, facingPos, world);
            }
            case DOWN: {
                if (isVerticalKnot) {
                    return false;
                }
                return RopeBlock.isSupportingCeiling(facingPos.m_6630_(2), world) || RopeBlock.canConnectDown(facingState);
            }
        }
        if (ServerConfigs.cached.ROPE_UNRESTRICTED && facingState.m_60783_((BlockGetter)world, facingPos, dir.m_122424_())) {
            return true;
        }
        if (facingState.m_60713_((Block)ModRegistry.ROPE_KNOT.get())) {
            return thisBlock != b && (dir.m_122434_() == Direction.Axis.Y || facingState.m_61143_(RopeKnotBlock.AXIS) == Direction.Axis.Y);
        }
        if (isKnot && !isVerticalKnot) {
            return false;
        }
        return b == ModRegistry.ROPE.get();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.m_5776_()) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if (facing == Direction.UP) {
            stateIn = (BlockState)stateIn.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(RopeBlock.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, Direction.DOWN)));
        }
        stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(RopeBlock.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, facing)));
        if (facing == Direction.DOWN && !worldIn.m_5776_() && CompatHandler.deco_blocks) {
            RopeChandelierBlock.tryConverting(facingState, worldIn, facingPos);
        }
        return (BlockState)stateIn.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(stateIn)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean hasWater = context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_;
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(dir), (Comparable)Boolean.valueOf(RopeBlock.shouldConnectToDir(state, pos, (LevelReader)world, dir)));
        }
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (BlockState)((BlockState)state.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(state)))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(this.getDistance((LevelReader)world, pos)));
        return state;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.f_46443_) {
            worldIn.m_186460_(pos, (Block)this, 1);
            if (CompatHandler.deco_blocks) {
                BlockPos down = pos.m_7495_();
                RopeChandelierBlock.tryConverting(worldIn.m_8055_(down), (LevelAccessor)worldIn, down);
            }
        }
    }

    public static boolean hasMiddleKnot(BlockState state) {
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        return !(up && down && !north && !south && !east && !west || !up && !down && north && south && !east && !west || !up && !down && !north && !south && east && west);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.getDistance(worldIn, pos) < 7;
    }

    public static boolean isSupportingCeiling(BlockState facingState, BlockPos pos, LevelReader world) {
        Block b = facingState.m_60734_();
        return RopeBlock.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN) || facingState.m_60620_(ModTags.ROPE_SUPPORT_TAG) || facingState.m_60713_((Block)ModRegistry.ROPE_KNOT.get()) && facingState.m_61143_(RopeKnotBlock.AXIS) != Direction.Axis.Y;
    }

    public static boolean isSupportingCeiling(BlockPos pos, LevelReader world) {
        return RopeBlock.isSupportingCeiling(world.m_8055_(pos), pos, world);
    }

    public static boolean canConnectDown(BlockPos currentPos, LevelReader world) {
        BlockState state = world.m_8055_(currentPos.m_7495_());
        return RopeBlock.canConnectDown(state);
    }

    public static boolean canConnectDown(BlockState downState) {
        Block b = downState.m_60734_();
        return downState.m_60713_((Block)ModRegistry.ROPE.get()) || downState.m_60620_(ModTags.ROPE_HANG_TAG) || downState.m_60713_((Block)ModRegistry.ROPE_KNOT.get()) && downState.m_61143_(RopeKnotBlock.AXIS) != Direction.Axis.Y || downState.m_61138_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) && downState.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.CEILING || b instanceof ChainBlock && downState.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y || downState.m_61138_((Property)BlockStateProperties.f_61435_) && (Boolean)downState.m_61143_((Property)BlockStateProperties.f_61435_) != false;
    }

    public int getDistance(LevelReader world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_().m_122173_(Direction.UP);
        BlockState blockstate = world.m_8055_((BlockPos)mutable);
        int i = 7;
        if (blockstate.m_60713_((Block)this)) {
            if (((Boolean)blockstate.m_61143_((Property)DOWN)).booleanValue() || !((Boolean)blockstate.m_61143_((Property)UP)).booleanValue()) {
                i = (Integer)blockstate.m_61143_((Property)DISTANCE);
            }
        } else if (RopeBlock.isSupportingCeiling((BlockPos)mutable, world)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos facingPos = mutable.m_122159_((Vec3i)pos, direction);
            BlockState sideState = world.m_8055_((BlockPos)facingPos);
            Block b = sideState.m_60734_();
            if (b instanceof RopeBlock) {
                if ((i = Math.min(i, (Integer)sideState.m_61143_((Property)DISTANCE) + 1)) != 1) continue;
                break;
            }
            if (!RopeBlock.shouldConnectToFace(this.m_49966_(), sideState, (BlockPos)facingPos, direction, world)) continue;
            i = 0;
        }
        return i;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        int i = this.getDistance((LevelReader)worldIn, pos);
        BlockState blockstate = (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
        if (i == 7) {
            worldIn.m_46961_(pos, true);
        } else if (state != blockstate) {
            worldIn.m_7731_(pos, blockstate, 3);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public static boolean findAndRingBell(Level world, BlockPos pos, Player player, int it, Predicate<BlockState> predicate) {
        if (it > ServerConfigs.cached.BELL_CHAIN_LENGTH) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block b = state.m_60734_();
        if (predicate.test(state)) {
            return RopeBlock.findAndRingBell(world, pos.m_7494_(), player, it + 1, predicate);
        }
        if (b instanceof BellBlock && it != 0) {
            BlockHitResult hit = new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ((Direction)state.m_61143_((Property)BellBlock.f_49679_)).m_122427_(), pos, true);
            return ((BellBlock)b).m_49701_(world, state, hit, player, true);
        }
        return false;
    }

    private static boolean findConnectedPulley(Level world, BlockPos pos, Player player, int it, Rotation rot) {
        if (it > 64) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block b = state.m_60734_();
        if (b instanceof RopeBlock) {
            return RopeBlock.findConnectedPulley(world, pos.m_7494_(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock) {
            BlockEntity blockEntity;
            PulleyBlock pulley = (PulleyBlock)b;
            if (it != 0 && (blockEntity = world.m_7702_(pos)) instanceof PulleyBlockTile) {
                PulleyBlockTile tile = (PulleyBlockTile)blockEntity;
                if (tile.m_7983_() && !player.m_6144_()) {
                    tile.setDisplayedItem(new ItemStack((ItemLike)ModRegistry.ROPE_ITEM.get()));
                    boolean ret = pulley.windPulley(state, pos, (LevelAccessor)world, rot, null);
                    tile.getDisplayedItem().m_41774_(1);
                    return ret;
                }
                return pulley.windPulley(state, pos, (LevelAccessor)world, rot, null);
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        Item i = stack.m_41720_();
        if (i == this.m_5456_()) {
            if (hit.m_82434_().m_122434_() == Direction.Axis.Y || ((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && !((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(pos, state, 0);
                }
                if (RopeBlock.addRope(pos.m_7495_(), world, player, handIn, (Block)this)) {
                    SoundType soundtype = state.getSoundType((LevelReader)world, pos, (Entity)player);
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            return InteractionResult.PASS;
        }
        if (stack.m_41619_()) {
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                if (ServerConfigs.cached.BELL_CHAIN && RopeBlock.findAndRingBell(world, pos, player, 0, s -> s.m_60734_() == this)) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                if (RopeBlock.findConnectedPulley(world, pos, player, 0, player.m_6144_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90)) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            if (!player.m_6144_() && handIn == InteractionHand.MAIN_HAND && world.m_8055_(pos.m_7495_()).m_60734_() == this && RopeBlock.removeRope(pos.m_7495_(), world, (Block)this)) {
                world.m_5594_(player, pos, SoundEvents.f_12087_, SoundSource.BLOCKS, 1.0f, 0.6f);
                if (!player.m_150110_().f_35937_) {
                    Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        } else if (i instanceof ShearsItem) {
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                if (!world.f_46443_) {
                    world.m_5594_(null, pos, SoundEvents.f_12480_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 0.8f, 1.3f);
                    BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(pos, newState, 3);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static boolean removeRope(BlockPos pos, Level world, Block ropeBlock) {
        BlockState state = world.m_8055_(pos);
        if (ropeBlock == state.m_60734_()) {
            return RopeBlock.removeRope(pos.m_7495_(), world, ropeBlock);
        }
        BlockPos up = pos.m_7494_();
        if (world.m_8055_(up).m_60734_() != ropeBlock) {
            return false;
        }
        FluidState fromFluid = world.m_6425_(up);
        boolean water = fromFluid.m_76152_() == Fluids.f_76193_ && fromFluid.m_76170_();
        world.m_46597_(up, water ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
        RopeBlock.tryMove(pos, up, world);
        return true;
    }

    public static boolean addRope(BlockPos pos, Level world, @Nullable Player player, InteractionHand hand, Block ropeBlock) {
        BlockState state = world.m_8055_(pos);
        if (ropeBlock == state.m_60734_()) {
            return RopeBlock.addRope(pos.m_7495_(), world, player, hand, ropeBlock);
        }
        return RopeBlock.tryPlaceAndMove(player, hand, world, pos, ropeBlock);
    }

    public static boolean tryPlaceAndMove(@Nullable Player player, InteractionHand hand, Level world, BlockPos pos, Block ropeBlock) {
        BlockState state;
        ItemStack stack = new ItemStack((ItemLike)ropeBlock);
        BlockUtils.PlayerLessContext context = new BlockUtils.PlayerLessContext(world, player, hand, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
        if (!context.m_7059_()) {
            BlockPos downPos = pos.m_7495_();
            if (!world.m_8055_(downPos).m_60767_().m_76336_() || !RopeBlock.tryMove(pos, downPos, world)) {
                return false;
            }
            context = new BlockUtils.PlayerLessContext(world, player, hand, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
        }
        if ((state = BlockItemUtils.getPlacementState(context, ropeBlock)) == null) {
            return false;
        }
        if (state == world.m_8055_(context.m_8083_())) {
            return false;
        }
        if (world.m_7731_(context.m_8083_(), state, 11)) {
            BlockState placedState;
            Block block2;
            if (player != null && (block2 = (placedState = world.m_8055_(context.m_8083_())).m_60734_()) == state.m_60734_()) {
                block2.m_6402_(world, context.m_8083_(), placedState, (LivingEntity)player, stack);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, context.m_8083_(), stack);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isBlockMovable(BlockState state, Level level, BlockPos pos) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_50080_) && !state.m_60713_(Blocks.f_50723_) && !state.m_60713_(Blocks.f_50724_) && state.m_60800_((BlockGetter)level, pos) != -1.0f;
    }

    private static boolean tryMove(BlockPos fromPos, BlockPos toPos, Level world) {
        if (toPos.m_123342_() < world.m_141937_() || toPos.m_123342_() > world.m_151558_()) {
            return false;
        }
        BlockState state = world.m_8055_(fromPos);
        PushReaction push = state.m_60811_();
        if (RopeBlock.isBlockMovable(state, world, fromPos) && ((push == PushReaction.NORMAL || toPos.m_123342_() < fromPos.m_123342_() && push == PushReaction.PUSH_ONLY) && state.m_60710_((LevelReader)world, toPos) || state.m_60620_(ModTags.ROPE_HANG_TAG))) {
            FluidState fromFluid;
            Fluid fluidState;
            BlockEntity tile = world.m_7702_(fromPos);
            if (tile != null) {
                if (CompatHandler.quark && !QuarkPistonPlugin.canMoveTile(state)) {
                    return false;
                }
                tile.m_7651_();
            }
            boolean waterFluid = (fluidState = world.m_6425_(toPos).m_76152_()) == Fluids.f_76193_;
            boolean canHoldWater = false;
            if (state.m_61138_((Property)WATERLOGGED)) {
                canHoldWater = state.m_60620_(ModTags.WATER_HOLDER);
                if (!canHoldWater) {
                    state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterFluid));
                }
            } else if (state.m_60734_() instanceof AbstractCauldronBlock) {
                if (waterFluid && state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152476_)) {
                    state = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                }
                if (fluidState == Fluids.f_76195_ && state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152477_)) {
                    state = (BlockState)Blocks.f_152477_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                }
            }
            boolean leaveWater = (fromFluid = world.m_6425_(fromPos)).m_76152_() == Fluids.f_76193_ && fromFluid.m_76170_() && !canHoldWater;
            world.m_46597_(fromPos, leaveWater ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
            BlockState newState = Block.m_49931_((BlockState)state, (LevelAccessor)world, (BlockPos)toPos);
            world.m_46597_(toPos, newState);
            if (tile != null) {
                CompoundTag tag = tile.m_187482_();
                BlockEntity te = world.m_7702_(toPos);
                if (te != null) {
                    te.m_142466_(tag);
                }
            }
            world.m_46586_(toPos, state.m_60734_(), toPos);
            return true;
        }
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (entityIn instanceof Arrow && !worldIn.f_46443_) {
            worldIn.m_46953_(pos, true, entityIn);
            worldIn.m_5594_(null, pos, SoundEvents.f_12033_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

