/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IColored;
import net.mehvahdjukaar.supplementaries.common.block.util.IPresentItemBehavior;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlock
extends WaterBlock
implements EntityBlock,
IColored {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty PRIMED = BlockProperties.PACKED;
    private final DyeColor color;
    private static final Map<Item, IPresentItemBehavior> TRAPPED_PRESENT_REGISTRY = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((source, stack) -> Optional.empty()));

    public TrappedPresentBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void registerBehavior(ItemLike pItem, IPresentItemBehavior pBehavior) {
        TRAPPED_PRESENT_REGISTRY.put(pItem.m_5456_(), pBehavior);
    }

    public static IPresentItemBehavior getPresentBehavior(ItemStack pStack) {
        return TRAPPED_PRESENT_REGISTRY.get(pStack.m_41720_());
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PRIMED, WATERLOGGED, FACING});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TrappedPresentBlockTile(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                return tile.interact(serverPlayer, pos);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            if (!worldIn.f_46443_ && player.m_7500_() && !tile.m_7983_()) {
                ItemStack itemstack = tile.getPresentItem((ItemLike)this);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            } else {
                tile.m_59640_(player);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)object;
            ItemStack itemstack = tile.getPresentItem((ItemLike)this);
            return Collections.singletonList(itemstack);
        }
        return super.m_7381_(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            return tile.getPresentItem((ItemLike)this);
        }
        return itemstack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            tile.m_58638_(stack.m_41786_());
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)PRIMED)).booleanValue()) {
            return PresentBlock.SHAPE_CLOSED;
        }
        return PresentBlock.SHAPE_OPEN;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46717_(pos, state.m_60734_());
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menu;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (menu = (MenuProvider)blockEntity) : null;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag t;
        BlockState state = super.m_5573_(context);
        CompoundTag tag = context.m_43722_().m_41783_();
        if (tag != null && tag.m_128441_("BlockEntityTag") && (t = tag.m_128469_("BlockEntityTag")).m_128441_("Items")) {
            state = (BlockState)state.m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            if (pLevel.f_46443_) {
                Random random = pLevel.f_46441_;
                double cx = (double)pPos.m_123341_() + 0.5;
                double cy = (double)pPos.m_123342_() + 0.5 + 0.4;
                double cz = (double)pPos.m_123343_() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double speed = random.nextDouble() * 0.15 + 0.015;
                    double py = cy + 0.02 + (random.nextDouble() - 0.5) * 0.3;
                    double dx = random.nextGaussian() * 0.01;
                    double dy = speed + random.nextGaussian() * 0.01;
                    double dz = random.nextGaussian() * 0.01;
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, cx, py, cz, dx, dy, dz);
                }
                this.destroyLid(pPos, pState, pLevel);
            }
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void destroyLid(BlockPos pPos, BlockState pState, Level level) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        VoxelShape voxelshape = PresentBlock.SHAPE_LID;
        voxelshape.m_83286_((p_172273_, p_172274_, p_172275_, p_172276_, p_172277_, p_172278_) -> {
            double d1 = Math.min(1.0, p_172276_ - p_172273_);
            double d2 = Math.min(1.0, p_172277_ - p_172274_);
            double d3 = Math.min(1.0, p_172278_ - p_172275_);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_172273_;
                        double d8 = d5 * d2 + p_172274_;
                        double d9 = d6 * d3 + p_172275_;
                        particleEngine.m_107344_(new TerrainParticle((ClientLevel)level, (double)pPos.m_123341_() + d7, (double)pPos.m_123342_() + d8, (double)pPos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, pState, pPos).updateSprite(pState, pPos));
                    }
                }
            }
        });
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        super.m_6861_(state, world, pos, p_220069_4_, p_220069_5_, p_220069_6_);
        boolean isPowered = world.m_46753_(pos);
        if (world instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)world;
            if (isPowered && ((Boolean)state.m_61143_((Property)PRIMED)).booleanValue() && (blockEntity = world.m_7702_(pos)) instanceof TrappedPresentBlockTile) {
                TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
                tile.detonate(serverLevel, pos);
            }
        }
    }
}

