/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Random;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class SwayingBlockTile
extends BlockEntity {
    public static final ModelProperty<Boolean> FANCY = BlockProperties.FANCY;
    protected static float maxSwingAngle = 45.0f;
    protected static float minSwingAngle = 2.5f;
    protected static float maxPeriod = 25.0f;
    protected static float angleDamping = 150.0f;
    protected static float periodDamping = 100.0f;
    private float angle = 0.0f;
    private float prevAngle = 0.0f;
    private int animationCounter = 800 + new Random().nextInt(80);
    private boolean inv = false;
    protected boolean shouldHaveTESR = false;
    protected boolean currentlyHasTESR = false;
    private int ticksToSwitchMode = 0;

    public SwayingBlockTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean isAlwaysFast() {
        return ClientConfigs.cached.FAST_LANTERNS;
    }

    public IModelData getModelData() {
        this.ticksToSwitchMode = 2;
        return new ModelDataMap.Builder().withInitial(FANCY, (Object)this.shouldHaveTESR).build();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setFancyRenderer(boolean fancy) {
        if (this.isAlwaysFast()) {
            fancy = false;
        }
        if (fancy != this.shouldHaveTESR) {
            this.currentlyHasTESR = this.shouldHaveTESR;
            this.shouldHaveTESR = fancy;
            if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 8);
            }
            if (!fancy) {
                this.animationCounter = 800;
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean shouldRenderFancy() {
        if (this.currentlyHasTESR != this.shouldHaveTESR && !this.currentlyHasTESR) {
            this.currentlyHasTESR = true;
        }
        return this.currentlyHasTESR;
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, SwayingBlockTile tile) {
        if (tile.currentlyHasTESR != tile.shouldHaveTESR && tile.currentlyHasTESR && tile.ticksToSwitchMode > 0) {
            --tile.ticksToSwitchMode;
            if (tile.ticksToSwitchMode == 0) {
                tile.currentlyHasTESR = false;
            }
        }
        if (tile.shouldRenderFancy()) {
            ++tile.animationCounter;
            double timer = tile.animationCounter;
            if (((Boolean)pState.m_61143_((Property)WaterBlock.WATERLOGGED)).booleanValue()) {
                timer /= 2.0;
            }
            tile.prevAngle = tile.angle;
            float a = minSwingAngle;
            float k = 0.01f;
            if (timer < 800.0) {
                a = (float)Math.max((double)maxSwingAngle * Math.exp(-(timer / (double)angleDamping)), (double)minSwingAngle);
                k = (float)Math.max(Math.PI * 2 * (double)((float)Math.exp(-(timer / (double)periodDamping))), (double)0.01f);
            }
            tile.angle = (tile.angle = a * Mth.m_14089_((float)((float)(timer / (double)maxPeriod - (double)k)))) * (tile.inv ? -1.0f : 1.0f);
        }
    }

    public float getSwingAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    public abstract Vec3i getNormalRotationAxis(BlockState var1);

    public void hitByEntity(Entity entity2, BlockState state) {
        Vec3 mot = entity2.m_20184_();
        if (mot.m_82553_() > 0.05) {
            Vec3i dv;
            Vec3 vec;
            Vec3 norm = new Vec3(mot.f_82479_, 0.0, mot.f_82481_).m_82541_();
            double dot = norm.m_82526_(vec = new Vec3((double)(dv = this.getNormalRotationAxis(state)).m_123341_(), 0.0, (double)dv.m_123343_()).m_82541_());
            if (dot != 0.0) {
                boolean bl = this.inv = dot < 0.0;
            }
            if (Math.abs(dot) > 0.4) {
                this.animationCounter = 0;
            }
        }
    }

    public boolean isFlipped() {
        return false;
    }
}

