/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.blocks.WindVaneBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WindVaneBlockTile
extends BlockEntity {
    public float yaw = 0.0f;
    public float prevYaw = 0.0f;
    private float offset = 0.0f;

    public WindVaneBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.WIND_VANE_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        float tp = (float)Math.PI * 2;
        this.offset = 400.0f * (Mth.m_14031_((float)(0.005f * (float)this.f_58858_.m_123341_() % tp)) + Mth.m_14031_((float)(0.005f * (float)this.f_58858_.m_123343_() % tp)) + Mth.m_14031_((float)(0.005f * (float)this.f_58858_.m_123342_() % tp)));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, WindVaneBlockTile tile) {
        float currentYaw;
        tile.prevYaw = currentYaw = tile.yaw;
        if (!pLevel.m_5776_()) {
            Block block2;
            if (pLevel.m_46467_() % 20L == 0L && (block2 = pState.m_60734_()) instanceof WindVaneBlock) {
                WindVaneBlock.updatePower(pState, pLevel, pPos);
            }
        } else {
            int power = (Integer)pState.m_61143_((Property)WindVaneBlock.WIND_STRENGTH);
            float tp = (float)Math.PI * 2;
            float t = (float)(pLevel.m_46467_() % 24000L) + tile.offset;
            float b = (float)Math.max(1.0, (double)power * ClientConfigs.cached.WIND_VANE_POWER_SCALING);
            float max_angle_1 = (float)ClientConfigs.cached.WIND_VANE_ANGLE_1;
            float max_angle_2 = (float)ClientConfigs.cached.WIND_VANE_ANGLE_2;
            float period_1 = (float)ClientConfigs.cached.WIND_VANE_PERIOD_1;
            float period_2 = (float)ClientConfigs.cached.WIND_VANE_PERIOD_2;
            float newYaw = max_angle_1 * Mth.m_14031_((float)(tp * (t * b / period_1 % 360.0f))) + max_angle_2 * Mth.m_14031_((float)(tp * (t * b / period_2 % 360.0f)));
            tile.yaw = Mth.m_14036_((float)newYaw, (float)(currentYaw - 8.0f), (float)(currentYaw + 8.0f));
        }
    }
}

