/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.mobholder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ConfigHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;

public class CapturedMobsHelper {
    public static final List<String> COMMAND_MOBS = new ArrayList<String>();
    public static final List<List<String>> DEFAULT_CONFIG = new ArrayList<List<String>>();
    private static final List<String> FISHES_2D = new ArrayList<String>();
    private static final Map<String, CapturedMobConfigProperties> TYPES = new HashMap<String, CapturedMobConfigProperties>();
    private static final CapturedMobConfigProperties DEFAULT = new CapturedMobConfigProperties("69", 0.0f, 0.0f, 0, 0, AnimationCategory.DEFAULT);
    private static final CapturedMobConfigProperties MODDED_FISH = new CapturedMobConfigProperties("420", 0.0f, 0.0f, 0, 1, AnimationCategory.DEFAULT);
    private static int fishIndex = 0;

    public static boolean is2DFish(EntityType<?> type) {
        return FISHES_2D.contains(type.getRegistryName().toString());
    }

    private static List<String> addFish(String id) {
        return CapturedMobsHelper.addDef(id, 0.0f, 0.125f, 0, ++fishIndex);
    }

    private static List<String> addFish(String id, int fishIndex) {
        return CapturedMobsHelper.addDef(id, 0.0f, 0.125f, 0, fishIndex);
    }

    private static List<String> addDef(String id, float h, float w, int l, int f) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, "" + f);
    }

    private static List<String> addDef(String id, float h, float w, int l, AnimationCategory c) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, c.toString());
    }

    private static List<String> addDef(String id, float h, float w, int l) {
        return Arrays.asList(id, "" + h, "" + w, "" + l);
    }

    private static List<String> addDef(String id, float h, float w) {
        return Arrays.asList(id, "" + h, "" + w);
    }

    public static CapturedMobConfigProperties getTypeFromBucket(Item bucket) {
        EntityType<?> t = BucketHelper.getEntityType(bucket);
        if (t != null) {
            return CapturedMobsHelper.getType(t);
        }
        return CapturedMobsHelper.getType("minecraft:fish");
    }

    public static CapturedMobConfigProperties getType(Entity mob) {
        return CapturedMobsHelper.getType(mob.m_6095_());
    }

    public static CapturedMobConfigProperties getType(EntityType<?> type) {
        return CapturedMobsHelper.getType(type.getRegistryName().toString());
    }

    public static CapturedMobConfigProperties getType(String mobId) {
        if (TYPES.containsKey(mobId)) {
            return TYPES.get(mobId);
        }
        return TYPES.getOrDefault(mobId, DEFAULT);
    }

    private static float strToFloat(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    private static int strToInt(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public static void refresh() {
        TYPES.clear();
        List<? extends List<String>> config = ConfigHandler.safeGetListString(ClientConfigs.CLIENT_SPEC, ClientConfigs.block.CAPTURED_MOBS_PROPERTIES);
        for (List<String> list : config) {
            try {
                Object type;
                int size = list.size();
                if (size < 2) continue;
                String id = list.get(0);
                float h = CapturedMobsHelper.strToFloat(list.get(1));
                float w = 0.0f;
                int light = 0;
                int fish = 0;
                AnimationCategory cat = AnimationCategory.DEFAULT;
                if (size > 2) {
                    w = CapturedMobsHelper.strToFloat(list.get(2));
                }
                if (size > 3) {
                    light = CapturedMobsHelper.strToInt(list.get(3));
                }
                if (size > 4) {
                    type = list.get(4).toLowerCase(Locale.ROOT);
                    switch (type) {
                        case "air": {
                            cat = AnimationCategory.AIR;
                            break;
                        }
                        case "land": {
                            cat = AnimationCategory.LAND;
                            break;
                        }
                        case "floating": {
                            cat = AnimationCategory.FLOATING;
                            break;
                        }
                        default: {
                            fish = CapturedMobsHelper.strToInt((String)type);
                            if (fish <= 0) break;
                            cat = AnimationCategory.FISH;
                        }
                    }
                }
                if (!ModList.get().isLoaded(new ResourceLocation(id).m_135827_()) && cat != AnimationCategory.FISH) continue;
                type = new CapturedMobConfigProperties(id, h, w, light, fish, cat);
                TYPES.put(id, (CapturedMobConfigProperties)type);
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to load captured mob configs");
            }
        }
    }

    static {
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:bee", 0.3125f, 0.0f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:vex", 0.0f, 0.125f, 0, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:silverfish", 0.0f, 0.25f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:chicken", 0.25f, 0.3125f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:endermite", 0.0f, 0.0f, 5));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:fox", 0.0f, 0.2f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:squid", 0.25f, 0.25f, 0, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:glow_squid", 0.25f, 0.25f, 3, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("supplementaries:firefly", 0.0f, 0.0f, 9, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("druidcraft:lunar_moth", 0.375f, 0.1375f, 10, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("iceandfire:pixie", 0.0f, 0.0f, 10));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("feywild:winter_pixie", 0.125f, 0.0f, 8, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("feywild:summer_pixie", 0.125f, 0.0f, 8, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("feywild:spring_pixie", 0.125f, 0.0f, 8, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("feywild:autumn_pixie", 0.25f, 0.0f, 8, AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:tropical_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:salmon"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:cod"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:pufferfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:axolotl"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:pea_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:wee_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:vibra_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:blu_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:ornate_bugfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:spindly_gem_crab"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:phantom_nudibranch"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:high_finned_blue"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:teal_arrowfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:midnight_squid"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:banded_redback_shrimp"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:flatback_sucker"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:swamp_mucker"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:lionfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:nautilus"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:pike"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("alexsmobs:stradpole"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("alexsmobs:blobfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:flashlight_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:elephantnose_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:black_diamond_stingray"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:humphead_parrotfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:tomato_frog"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:pacman_frog"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("bettas:betta_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("pogfish:pogfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("undergarden:gwibling"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("environmental:koi"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betterendforge:end_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:flying_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:nautilus"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:eel_freshwater"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:eel_saltwater"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:lamprey"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:piranha"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:barracuda"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("rediscovered:fish", 1));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("biomemakeover:glowfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("biomemakeover:tadpoles"));
        for (List<String> d : DEFAULT_CONFIG) {
            int f;
            if (d.size() != 5 || (f = CapturedMobsHelper.strToInt(d.get(4))) <= 0 || d.get(0).equals("")) continue;
            FISHES_2D.add(d.get(0));
        }
        for (String id : FISHES_2D) {
            BucketHelper.tryAddingFromEntityId(id);
        }
    }

    public static enum AnimationCategory {
        DEFAULT,
        FISH,
        LAND,
        AIR,
        FLOATING;


        public boolean isFlying() {
            return this == AIR || this == FLOATING;
        }

        public boolean isLand() {
            return this == LAND;
        }

        public boolean isFloating() {
            return this == FLOATING;
        }

        public boolean isFish() {
            return this == FISH;
        }
    }

    public static class CapturedMobConfigProperties {
        private final String id;
        private final float extraWidth;
        private final float extraHeight;
        private final int lightLevel;
        private final int fishTexture;
        private final AnimationCategory category;

        private CapturedMobConfigProperties(String id, float h, float w, int light, int fish, AnimationCategory c) {
            this.id = id;
            this.extraWidth = w;
            this.extraHeight = h;
            this.lightLevel = light;
            this.fishTexture = fish - 1;
            this.category = c;
        }

        public AnimationCategory getCategory() {
            return this.category;
        }

        public boolean canHaveWater() {
            return this.isFlying() || this.is2DFish();
        }

        public String getId() {
            return this.id;
        }

        public float getHeight() {
            return this.extraHeight;
        }

        public float getWidth() {
            return this.extraWidth;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public boolean is2DFish() {
            return this.category.isFish();
        }

        public boolean isFlying() {
            return this.category.isFlying();
        }

        public boolean isLand() {
            return this.category.isLand();
        }

        public boolean isFloating() {
            return this.category.isFloating();
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public boolean canBe2dFish() {
            return this == DEFAULT || this.is2DFish();
        }
    }
}

