/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WaySignStructure
extends StructureFeature<JigsawConfiguration> {
    public WaySignStructure(Codec<JigsawConfiguration> codec) {
        super(codec, context -> {
            if (!WaySignStructure.isFeatureChunk((PieceGeneratorSupplier.Context<JigsawConfiguration>)context)) {
                return Optional.empty();
            }
            return WaySignStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)context);
        }, PostPlacementProcessor.f_192427_);
    }

    public StructureStart<?> generate(RegistryAccess registryAccess, ChunkGenerator generator, BiomeSource biomeSource, StructureManager manager, long seed, ChunkPos chunkPos, int p_191139_, StructureFeatureConfiguration configuration, JigsawConfiguration jigsawConfiguration, LevelHeightAccessor levelHeightAccessor, Predicate<Biome> biomePredicate) {
        return super.m_191132_(registryAccess, generator, biomeSource, manager, seed, chunkPos, p_191139_, configuration, (FeatureConfiguration)jigsawConfiguration, levelHeightAccessor, biomePredicate);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.STRONGHOLDS;
    }

    private static boolean isPosNotValid(ChunkGenerator gen, int x, int z, Set<Integer> heightMap, LevelHeightAccessor heightLimitView) {
        int y = gen.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        NoiseColumn noisecolumn = gen.m_141914_(x, z, heightLimitView);
        BlockState state = noisecolumn.m_183556_(y);
        try {
            if (state.m_60819_().m_76178_()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private static boolean isNearOutpost(ChunkGenerator generator, long seed, ChunkPos chunkPos) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        StructureFeatureConfiguration featureConfiguration = generator.m_62205_().m_64593_(StructureFeature.f_67013_);
        if (featureConfiguration != null) {
            for (int i = chunkX - 8; i <= chunkX + 8; ++i) {
                for (int j = chunkZ - 8; j <= chunkZ + 8; ++j) {
                    ChunkPos chunkpos = StructureFeature.f_67013_.m_191122_(featureConfiguration, seed, i, j);
                    if (i != chunkpos.f_45578_ || j != chunkpos.f_45579_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator generator = context.f_197352_();
        LevelHeightAccessor heightLimitView = context.f_197357_();
        BlockPos blockPos = chunkPos.m_45615_();
        int x = blockPos.m_123341_();
        int z = blockPos.m_123343_();
        int y = generator.m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        if (y > 105 || y < generator.m_6337_()) {
            return false;
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(y);
        if (WaySignStructure.isPosNotValid(generator, x + 2, z + 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x + 2, z - 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z + 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z - 2, set, heightLimitView)) {
            return false;
        }
        if (set.last() - set.first() > 1) {
            return false;
        }
        return !WaySignStructure.isNearOutpost(generator, context.f_197354_(), chunkPos);
    }

    public String m_67098_() {
        String name = super.m_67098_();
        if (name == null) {
            Supplementaries.LOGGER.error((Object)new Exception("failed to register way sign structure. this is a bug"));
            return ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this).toString();
        }
        return name;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator generator = context.f_197352_();
        LevelHeightAccessor levelHeight = context.f_197357_();
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        int sum = 0;
        sum += generator.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x + 2, z + 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x + 2, z - 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x - 2, z + 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        int y = Math.round((float)(sum += generator.m_156179_(x - 2, z - 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight)) / 5.0f);
        BlockPos blockpos = new BlockPos(x, y + 1, z);
        JigsawConfiguration newConfig = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(Supplementaries.res("way_sign/start_pool")), 4);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        Optional structurePiecesGenerator = JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

